/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action;

import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.Action;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ListenableActionFuture;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.PlainListenableActionFuture;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.ElasticsearchClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> {
    protected final Action<Request, Response, RequestBuilder> action;
    protected final Request request;
    private final ThreadPool threadPool;
    protected final ElasticsearchClient client;

    protected ActionRequestBuilder(ElasticsearchClient client, Action<Request, Response, RequestBuilder> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
        this.threadPool = client.threadPool();
    }

    public Request request() {
        return this.request;
    }

    public ListenableActionFuture<Response> execute() {
        PlainListenableActionFuture future = new PlainListenableActionFuture(this.threadPool);
        this.execute(future);
        return future;
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.beforeExecute(this.request), listener);
    }

    protected Request beforeExecute(Request request) {
        return request;
    }
}

