/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;

public final class TaskOperationFailure
implements Writeable,
ToXContent {
    private final String nodeId;
    private final long taskId;
    private final Exception reason;
    private final RestStatus status;

    public TaskOperationFailure(String nodeId, long taskId, Exception e) {
        this.nodeId = nodeId;
        this.taskId = taskId;
        this.reason = e;
        this.status = ExceptionsHelper.status(e);
    }

    public TaskOperationFailure(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.taskId = in.readLong();
        this.reason = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeLong(this.taskId);
        out.writeException(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getReason() {
        return ExceptionsHelper.detailedMessage(this.reason);
    }

    public RestStatus getStatus() {
        return this.status;
    }

    public Exception getCause() {
        return this.reason;
    }

    public String toString() {
        return "[" + this.nodeId + "][" + this.taskId + "] failed, reason [" + this.getReason() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("task_id", this.getTaskId());
        builder.field("node_id", this.getNodeId());
        builder.field("status", this.status.name());
        if (this.reason != null) {
            builder.field("reason");
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
        }
        return builder;
    }
}

