/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.verify;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public class VerifyRepositoryResponse
extends ActionResponse
implements ToXContentObject {
    private DiscoveryNode[] nodes;
    private ClusterName clusterName;

    VerifyRepositoryResponse() {
    }

    public VerifyRepositoryResponse(ClusterName clusterName, DiscoveryNode[] nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new DiscoveryNode(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        out.writeVInt(this.nodes.length);
        for (DiscoveryNode node : this.nodes) {
            node.writeTo(out);
        }
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("nodes");
        for (DiscoveryNode node : this.nodes) {
            builder.startObject(node.getId());
            builder.field("name", node.getName());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static final class Fields {
        static final String NODES = "nodes";
        static final String NAME = "name";

        Fields() {
        }
    }
}

