/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.InitialSearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhaseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchShardIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchTransportService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.TransportSearchAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.AliasFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.Transport;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchTransportService.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory) {
        super("can_match", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new BitSetSearchPhaseResults(shardsIts.size()), shardsIts.size());
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<SearchTransportService.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<SearchTransportService.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((BitSetSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(BitSetSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            possibleMatches.set(0);
        }
        int i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        return shardsIts;
    }

    private static final class BitSetSearchPhaseResults
    extends InitialSearchPhase.SearchPhaseResults<SearchTransportService.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private int numPossibleMatches;

        BitSetSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
        }

        @Override
        void consumeResult(SearchTransportService.CanMatchResponse result) {
            if (result.canMatch()) {
                this.consumeShardFailure(result.getShardIndex());
            }
        }

        @Override
        boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        synchronized void consumeShardFailure(int shardIndex) {
            this.possibleMatches.set(shardIndex);
            ++this.numPossibleMatches;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        Stream<SearchTransportService.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

