/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.UnavailableShardsException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActiveShardCount;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.TransportActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.replication.ReplicationRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.AllocationId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.set.Sets;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;

public class ReplicationOperation<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, PrimaryResultT extends PrimaryResult<ReplicaRequest>> {
    private final Logger logger;
    private final Request request;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final String opType;
    private final AtomicInteger totalShards = new AtomicInteger();
    private final AtomicInteger pendingActions = new AtomicInteger();
    private final AtomicInteger successfulShards = new AtomicInteger();
    private final boolean executeOnReplicas;
    private final Primary<Request, ReplicaRequest, PrimaryResultT> primary;
    private final Replicas<ReplicaRequest> replicasProxy;
    private final AtomicBoolean finished = new AtomicBoolean();
    protected final ActionListener<PrimaryResultT> resultListener;
    private volatile PrimaryResultT primaryResult = null;
    private final List<ReplicationResponse.ShardInfo.Failure> shardReplicaFailures = Collections.synchronizedList(new ArrayList());

    public ReplicationOperation(Request request, Primary<Request, ReplicaRequest, PrimaryResultT> primary, ActionListener<PrimaryResultT> listener, boolean executeOnReplicas, Replicas<ReplicaRequest> replicas, Supplier<ClusterState> clusterStateSupplier, Logger logger, String opType) {
        this.executeOnReplicas = executeOnReplicas;
        this.replicasProxy = replicas;
        this.primary = primary;
        this.resultListener = listener;
        this.logger = logger;
        this.request = request;
        this.clusterStateSupplier = clusterStateSupplier;
        this.opType = opType;
    }

    public void execute() throws Exception {
        String activeShardCountFailure = this.checkActiveShardCount();
        ShardRouting primaryRouting = this.primary.routingEntry();
        ShardId primaryId = primaryRouting.shardId();
        if (activeShardCountFailure != null) {
            this.finishAsFailed(new UnavailableShardsException(primaryId, "{} Timeout: [{}], request: [{}]", activeShardCountFailure, ((ReplicationRequest)this.request).timeout(), this.request));
            return;
        }
        this.totalShards.incrementAndGet();
        this.pendingActions.incrementAndGet();
        this.primaryResult = this.primary.perform(this.request);
        Object replicaRequest = this.primaryResult.replicaRequest();
        if (replicaRequest != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] op [{}] completed on primary for request [{}]", (Object)primaryId, (Object)this.opType, this.request);
            }
            ClusterState clusterState = this.clusterStateSupplier.get();
            List<ShardRouting> shards = this.getShards(primaryId, clusterState);
            Set<String> inSyncAllocationIds = this.getInSyncAllocationIds(primaryId, clusterState);
            this.markUnavailableShardsAsStale(replicaRequest, inSyncAllocationIds, shards);
            this.performOnReplicas(replicaRequest, shards);
        }
        this.successfulShards.incrementAndGet();
        this.decPendingAndFinishIfNeeded();
    }

    private void markUnavailableShardsAsStale(ReplicaRequest replicaRequest, Set<String> inSyncAllocationIds, List<ShardRouting> shards) {
        if (!inSyncAllocationIds.isEmpty() && !shards.isEmpty()) {
            Set availableAllocationIds = shards.stream().map(ShardRouting::allocationId).filter(Objects::nonNull).map(AllocationId::getId).collect(Collectors.toSet());
            for (String allocationId : Sets.difference(inSyncAllocationIds, availableAllocationIds)) {
                this.pendingActions.incrementAndGet();
                this.replicasProxy.markShardCopyAsStale(((ReplicationRequest)replicaRequest).shardId(), allocationId, this::decPendingAndFinishIfNeeded, this::onPrimaryDemoted, throwable -> this.decPendingAndFinishIfNeeded());
            }
        }
    }

    private void performOnReplicas(ReplicaRequest replicaRequest, List<ShardRouting> shards) {
        String localNodeId = this.primary.routingEntry().currentNodeId();
        for (ShardRouting shard : shards) {
            if (!this.executeOnReplicas || shard.unassigned()) {
                if (shard.primary()) continue;
                this.totalShards.incrementAndGet();
                continue;
            }
            if (!shard.currentNodeId().equals(localNodeId)) {
                this.performOnReplica(shard, replicaRequest);
            }
            if (!shard.relocating() || shard.relocatingNodeId().equals(localNodeId)) continue;
            this.performOnReplica(shard.getTargetRelocatingShard(), replicaRequest);
        }
    }

    private void performOnReplica(final ShardRouting shard, final ReplicaRequest replicaRequest) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] sending op [{}] to replica {} for request [{}]", (Object)shard.shardId(), (Object)this.opType, (Object)shard, replicaRequest);
        }
        this.totalShards.incrementAndGet();
        this.pendingActions.incrementAndGet();
        this.replicasProxy.performOn(shard, replicaRequest, new ActionListener<TransportResponse.Empty>(){

            @Override
            public void onResponse(TransportResponse.Empty empty) {
                ReplicationOperation.this.successfulShards.incrementAndGet();
                ReplicationOperation.this.decPendingAndFinishIfNeeded();
            }

            @Override
            public void onFailure(Exception replicaException) {
                ReplicationOperation.this.logger.trace(() -> new ParameterizedMessage("[{}] failure while performing [{}] on replica {}, request [{}]", new Object[]{shard.shardId(), ReplicationOperation.this.opType, shard, replicaRequest}), (Throwable)replicaException);
                if (TransportActions.isShardNotAvailableException(replicaException)) {
                    ReplicationOperation.this.decPendingAndFinishIfNeeded();
                } else {
                    RestStatus restStatus = ExceptionsHelper.status(replicaException);
                    ReplicationOperation.this.shardReplicaFailures.add(new ReplicationResponse.ShardInfo.Failure(shard.shardId(), shard.currentNodeId(), replicaException, restStatus, false));
                    String message = String.format(Locale.ROOT, "failed to perform %s on replica %s", ReplicationOperation.this.opType, shard);
                    ReplicationOperation.this.logger.warn(() -> new ParameterizedMessage("[{}] {}", (Object)shard.shardId(), (Object)message), (Throwable)replicaException);
                    ReplicationOperation.this.replicasProxy.failShard(shard, message, replicaException, () -> ReplicationOperation.this.decPendingAndFinishIfNeeded(), x$0 -> ReplicationOperation.this.onPrimaryDemoted(x$0), throwable -> ReplicationOperation.this.decPendingAndFinishIfNeeded());
                }
            }
        });
    }

    private void onPrimaryDemoted(Exception demotionFailure) {
        String primaryFail = String.format(Locale.ROOT, "primary shard [%s] was demoted while failing replica shard", this.primary.routingEntry());
        this.primary.failShard(primaryFail, demotionFailure);
        this.finishAsFailed(new RetryOnPrimaryException(this.primary.routingEntry().shardId(), primaryFail, demotionFailure));
    }

    protected String checkActiveShardCount() {
        ShardId shardId = this.primary.routingEntry().shardId();
        String indexName = shardId.getIndexName();
        ClusterState state = this.clusterStateSupplier.get();
        assert (state != null) : "replication operation must have access to the cluster state";
        ActiveShardCount waitForActiveShards = ((ReplicationRequest)this.request).waitForActiveShards();
        if (waitForActiveShards == ActiveShardCount.NONE) {
            return null;
        }
        IndexRoutingTable indexRoutingTable = state.getRoutingTable().index(indexName);
        if (indexRoutingTable == null) {
            this.logger.trace("[{}] index not found in the routing table", (Object)shardId);
            return "Index " + indexName + " not found in the routing table";
        }
        IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shardId.getId());
        if (shardRoutingTable == null) {
            this.logger.trace("[{}] shard not found in the routing table", (Object)shardId);
            return "Shard " + shardId + " not found in the routing table";
        }
        if (waitForActiveShards.enoughShardsActive(shardRoutingTable)) {
            return null;
        }
        String resolvedShards = waitForActiveShards == ActiveShardCount.ALL ? Integer.toString(shardRoutingTable.shards().size()) : waitForActiveShards.toString();
        this.logger.trace("[{}] not enough active copies to meet shard count of [{}] (have {}, needed {}), scheduling a retry. op [{}], request [{}]", (Object)shardId, (Object)waitForActiveShards, (Object)shardRoutingTable.activeShards().size(), (Object)resolvedShards, (Object)this.opType, this.request);
        return "Not enough active copies to meet shard count of [" + waitForActiveShards + "] (have " + shardRoutingTable.activeShards().size() + ", needed " + resolvedShards + ").";
    }

    protected Set<String> getInSyncAllocationIds(ShardId shardId, ClusterState clusterState) {
        IndexMetaData indexMetaData = clusterState.metaData().index(shardId.getIndex());
        if (indexMetaData != null) {
            return indexMetaData.inSyncAllocationIds(shardId.id());
        }
        return Collections.emptySet();
    }

    protected List<ShardRouting> getShards(ShardId shardId, ClusterState state) {
        IndexShardRoutingTable shardRoutingTable = state.getRoutingTable().shardRoutingTableOrNull(shardId);
        List<ShardRouting> shards = shardRoutingTable == null ? Collections.emptyList() : shardRoutingTable.shards();
        return shards;
    }

    private void decPendingAndFinishIfNeeded() {
        assert (this.pendingActions.get() > 0);
        if (this.pendingActions.decrementAndGet() == 0) {
            this.finish();
        }
    }

    private void finish() {
        if (this.finished.compareAndSet(false, true)) {
            ReplicationResponse.ShardInfo.Failure[] failuresArray;
            if (this.shardReplicaFailures.isEmpty()) {
                failuresArray = ReplicationResponse.EMPTY;
            } else {
                failuresArray = new ReplicationResponse.ShardInfo.Failure[this.shardReplicaFailures.size()];
                this.shardReplicaFailures.toArray(failuresArray);
            }
            this.primaryResult.setShardInfo(new ReplicationResponse.ShardInfo(this.totalShards.get(), this.successfulShards.get(), failuresArray));
            this.resultListener.onResponse(this.primaryResult);
        }
    }

    private void finishAsFailed(Exception exception) {
        if (this.finished.compareAndSet(false, true)) {
            this.resultListener.onFailure(exception);
        }
    }

    public static interface PrimaryResult<R extends ReplicationRequest<R>> {
        @Nullable
        public R replicaRequest();

        public void setShardInfo(ReplicationResponse.ShardInfo var1);
    }

    public static class RetryOnPrimaryException
    extends ElasticsearchException {
        public RetryOnPrimaryException(ShardId shardId, String msg) {
            this(shardId, msg, null);
        }

        public RetryOnPrimaryException(ShardId shardId, String msg, Throwable cause) {
            super(msg, cause, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnPrimaryException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface Replicas<ReplicaRequest extends ReplicationRequest<ReplicaRequest>> {
        public void performOn(ShardRouting var1, ReplicaRequest var2, ActionListener<TransportResponse.Empty> var3);

        public void failShard(ShardRouting var1, String var2, Exception var3, Runnable var4, Consumer<Exception> var5, Consumer<Exception> var6);

        public void markShardCopyAsStale(ShardId var1, String var2, Runnable var3, Consumer<Exception> var4, Consumer<Exception> var5);
    }

    public static interface Primary<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, PrimaryResultT extends PrimaryResult<ReplicaRequest>> {
        public ShardRouting routingEntry();

        public void failShard(String var1, Exception var2);

        public PrimaryResultT perform(Request var1) throws Exception;
    }
}

