/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cli;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSpec;
import org.graylog.shaded.elasticsearch5.joptsimple.util.KeyValuePair;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Command;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.InternalSettingsPreparer;

public abstract class EnvironmentAwareCommand
extends Command {
    private final OptionSpec<KeyValuePair> settingOption;

    public EnvironmentAwareCommand(String description) {
        super(description);
        this.settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (KeyValuePair kvp : this.settingOption.values(options)) {
            if (kvp.value.isEmpty()) {
                throw new UserException(64, "setting [" + kvp.key + "] must not be empty");
            }
            if (settings.containsKey(kvp.key)) {
                String message = String.format(Locale.ROOT, "setting [%s] already set, saw [%s] and [%s]", kvp.key, settings.get(kvp.key), kvp.value);
                throw new UserException(64, message);
            }
            settings.put(kvp.key, kvp.value);
        }
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "default.path.conf", "es.default.path.conf");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "default.path.data", "es.default.path.data");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "default.path.logs", "es.default.path.logs");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.conf", "es.path.conf");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.data", "es.path.data");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.home", "es.path.home");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.logs", "es.path.logs");
        this.execute(terminal, options, this.createEnv(terminal, settings));
    }

    protected Environment createEnv(Terminal terminal, Map<String, String> settings) {
        return InternalSettingsPreparer.prepareEnvironment(Settings.EMPTY, terminal, settings);
    }

    protected static void putSystemPropertyIfSettingIsMissing(Map<String, String> settings, String setting, String key) {
        String value = System.getProperty(key);
        if (value != null) {
            if (settings.containsKey(setting)) {
                String message = String.format(Locale.ROOT, "duplicate setting [%s] found via command-line [%s] and system property [%s]", setting, settings.get(setting), value);
                throw new IllegalArgumentException(message);
            }
            settings.put(setting, value);
        }
    }

    protected abstract void execute(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

