/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.AbstractModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.AbstractProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Binder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Binding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.BoundProviderFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.ConstantFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.ExposedKeyFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.FactoryProxy;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Initializable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Initializer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Injector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.InjectorImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.InternalFactoryToProviderAdapter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Key;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.MembersInjector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Module;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Provider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Scope;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Scopes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.TypeLiteral;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Annotations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.BindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Errors;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.ErrorsException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.ExposedBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.InstanceBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.InternalFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.LinkedBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.LinkedProviderBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.ProviderInstanceBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.ProviderMethod;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Scoping;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.UntargettedBindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ConstructorBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ConvertedConstantBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ExposedBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.InjectionPoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.InstanceBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.LinkedKeyBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.PrivateElements;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ProviderBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ProviderInstanceBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.ProviderKeyBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.UntargettedBinding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.set.Sets;

class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = new ArrayList<CreationListener>();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = new ArrayList<Runnable>();
    private static final Set<Class<?>> FORBIDDEN_TYPES = Collections.unmodifiableSet(Sets.newHashSet(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class));

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getProviderInstance() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        final Key<T> key = command.getKey();
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        this.validateKey(command.getSource(), command.getKey());
        final Scoping scoping = Scopes.makeInjectable(((BindingImpl)command).getScoping(), this.injector, this.errors);
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){

            @Override
            public Void visit(InstanceBinding<? extends T> binding) {
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding) {
                Provider provider = binding.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, source, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(ProviderKeyBinding<? extends T> binding) {
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, source);
                BindingProcessor.this.creationListeners.add(boundProviderFactory);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, boundProviderFactory, scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, providerKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding) {
                Key linkedKey = binding.getLinkedKey();
                if (key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, key, linkedKey, source);
                BindingProcessor.this.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding;
                if (key.hasAnnotationType()) {
                    BindingProcessor.this.errors.missingImplementation(key);
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                try {
                    binding = BindingProcessor.this.injector.createUnitializedBinding(key, scoping, source, BindingProcessor.this.errors);
                    BindingProcessor.this.putBinding(binding);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                BindingProcessor.this.uninitializedBindings.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((InjectorImpl)binding.getInjector()).initializeBinding(binding, BindingProcessor.this.errors.withSource(source));
                        }
                        catch (ErrorsException e) {
                            BindingProcessor.this.errors.merge(e.getErrors());
                        }
                    }
                });
                return null;
            }

            @Override
            public Void visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConstructorBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.creationListeners.add(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>((Injector)this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }

    private <T> void validateKey(Object source, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getRawType(), source, this.errors);
    }

    <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key);
        if (original != null && !this.isOkayDuplicate(original, binding)) {
            this.errors.bindingAlreadySet(key, original.getSource());
            return;
        }
        this.injector.state.parent().blacklist(key);
        this.injector.state.putBinding(key, binding);
    }

    private boolean isOkayDuplicate(Binding<?> original, BindingImpl<?> binding) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding.getInjector();
        }
        return false;
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

