/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooNewException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooOldException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.LockObtainFailedException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch5.org.joda.time.DateTimeZone;
import org.graylog.shaded.elasticsearch5.org.joda.time.ReadableInstant;

public abstract class StreamOutput
extends OutputStream {
    private Version version = Version.CURRENT;
    private final BytesRefBuilder spare = new BytesRefBuilder();
    private byte[] convertStringBuffer = BytesRef.EMPTY_BYTES;
    private static byte ZERO = 0;
    private static byte ONE = 1;
    private static byte TWO = (byte)2;
    private static final Map<Class<?>, Writeable.Writer> WRITERS;

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeByteArray(byte[] b) throws IOException {
        this.writeVInt(b.length);
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeOptionalBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length() + 1);
        bytes.writeTo(this);
    }

    public void writeBytesRef(BytesRef bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length);
        this.write(bytes.bytes, bytes.offset, bytes.length);
    }

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalStateException("Negative longs unsupported, use writeLong or writeZLong for negative numbers [" + i + "]");
        }
        this.writeVLongNoCheck(i);
    }

    void writeVLongNoCheck(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeZLong(long i) throws IOException {
        long value = BitUtil.zigZagEncode(i);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        this.writeByte((byte)(value & 0x7FL));
    }

    public void writeOptionalLong(@Nullable Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeLong(l);
        }
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeOptionalVInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    public void writeOptionalFloat(@Nullable Float floatValue) throws IOException {
        if (floatValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloat(floatValue.floatValue());
        }
    }

    public void writeOptionalText(@Nullable Text text) throws IOException {
        if (text == null) {
            this.writeInt(-1);
        } else {
            this.writeText(text);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes()) {
            String string = text.string();
            this.spare.copyChars(string);
            this.writeInt(this.spare.length());
            this.write(this.spare.bytes(), 0, this.spare.length());
        } else {
            BytesReference bytes = text.bytes();
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        int bufferSize = Math.min(3 * charCount, 1024);
        if (this.convertStringBuffer.length < bufferSize) {
            this.convertStringBuffer = new byte[ArrayUtil.oversize(bufferSize, 1)];
        }
        byte[] buffer = this.convertStringBuffer;
        int offset = 0;
        this.writeVInt(charCount);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                buffer[offset++] = (byte)c;
            } else if (c > '\u07ff') {
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            if (offset <= buffer.length - 3) continue;
            this.writeBytes(buffer, offset);
            offset = 0;
        }
        this.writeBytes(buffer, offset);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeOptionalDouble(@Nullable Double v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeDouble(v);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    public void writeOptionalBoolean(@Nullable Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(TWO);
        } else {
            this.writeBoolean(b);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s : array) {
            this.writeString(s);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s : array) {
                this.writeString(s);
            }
        }
    }

    public void writeOptionalStringArray(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeStringArray(array);
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeMapWithConsistentOrder(@Nullable Map<String, ? extends Object> map) throws IOException {
        if (map == null) {
            this.writeByte((byte)-1);
            return;
        }
        assert (!(map instanceof LinkedHashMap));
        this.writeByte((byte)10);
        this.writeVInt(map.size());
        Iterator iterator = map.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            this.writeString((String)next.getKey());
            this.writeGenericValue(next.getValue());
        }
    }

    public final <K, V> void writeMapOfLists(Map<K, List<V>> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeMap(map, keyWriter, (stream, list) -> {
            this.writeVInt(list.size());
            for (Object value : list) {
                valueWriter.write(this, value);
            }
        });
    }

    public final <K, V> void writeMap(Map<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeVInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.write(this, entry.getKey());
            valueWriter.write(this, entry.getValue());
        }
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class type = value instanceof List ? List.class : (value instanceof Object[] ? Object[].class : (value instanceof Map ? Map.class : (value instanceof ReadableInstant ? ReadableInstant.class : (value instanceof BytesReference ? BytesReference.class : value.getClass()))));
        Writeable.Writer writer = WRITERS.get(type);
        if (writer == null) {
            throw new IOException("can not write type [" + type + "]");
        }
        writer.write(this, value);
    }

    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeInt(value);
        }
    }

    public void writeVIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeVInt(value);
        }
    }

    public void writeLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeLong(value);
        }
    }

    public void writeVLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeVLong(value);
        }
    }

    public void writeFloatArray(float[] values) throws IOException {
        this.writeVInt(values.length);
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    public void writeDoubleArray(double[] values) throws IOException {
        this.writeVInt(values.length);
        for (double value : values) {
            this.writeDouble(value);
        }
    }

    public <T extends Writeable> void writeArray(T[] array) throws IOException {
        this.writeVInt(array.length);
        for (T value : array) {
            value.writeTo(this);
        }
    }

    public <T extends Writeable> void writeOptionalArray(@Nullable T[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeArray((Writeable[])array);
        }
    }

    public void writeOptionalStreamable(@Nullable Streamable streamable) throws IOException {
        if (streamable != null) {
            this.writeBoolean(true);
            streamable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeOptionalWriteable(@Nullable Writeable writeable) throws IOException {
        if (writeable != null) {
            this.writeBoolean(true);
            writeable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeException(Throwable throwable) throws IOException {
        if (throwable == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            boolean writeCause = true;
            boolean writeMessage = true;
            if (throwable instanceof CorruptIndexException) {
                this.writeVInt(1);
                this.writeOptionalString(((CorruptIndexException)throwable).getOriginalMessage());
                this.writeOptionalString(((CorruptIndexException)throwable).getResourceDescription());
                writeMessage = false;
            } else if (throwable instanceof IndexFormatTooNewException) {
                this.writeVInt(2);
                this.writeOptionalString(((IndexFormatTooNewException)throwable).getResourceDescription());
                this.writeInt(((IndexFormatTooNewException)throwable).getVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMinVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMaxVersion());
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof IndexFormatTooOldException) {
                this.writeVInt(3);
                IndexFormatTooOldException t = (IndexFormatTooOldException)throwable;
                this.writeOptionalString(t.getResourceDescription());
                if (t.getVersion() == null) {
                    this.writeBoolean(false);
                    this.writeOptionalString(t.getReason());
                } else {
                    this.writeBoolean(true);
                    this.writeInt(t.getVersion());
                    this.writeInt(t.getMinVersion());
                    this.writeInt(t.getMaxVersion());
                }
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof NullPointerException) {
                this.writeVInt(4);
                writeCause = false;
            } else if (throwable instanceof NumberFormatException) {
                this.writeVInt(5);
                writeCause = false;
            } else if (throwable instanceof IllegalArgumentException) {
                this.writeVInt(6);
            } else if (throwable instanceof AlreadyClosedException) {
                this.writeVInt(7);
            } else if (throwable instanceof EOFException) {
                this.writeVInt(8);
                writeCause = false;
            } else if (throwable instanceof SecurityException) {
                this.writeVInt(9);
            } else if (throwable instanceof StringIndexOutOfBoundsException) {
                this.writeVInt(10);
                writeCause = false;
            } else if (throwable instanceof ArrayIndexOutOfBoundsException) {
                this.writeVInt(11);
                writeCause = false;
            } else if (throwable instanceof FileNotFoundException) {
                this.writeVInt(12);
                writeCause = false;
            } else if (throwable instanceof FileSystemException) {
                this.writeVInt(13);
                if (throwable instanceof NoSuchFileException) {
                    this.writeVInt(0);
                } else if (throwable instanceof NotDirectoryException) {
                    this.writeVInt(1);
                } else if (throwable instanceof DirectoryNotEmptyException) {
                    this.writeVInt(2);
                } else if (throwable instanceof AtomicMoveNotSupportedException) {
                    this.writeVInt(3);
                } else if (throwable instanceof FileAlreadyExistsException) {
                    this.writeVInt(4);
                } else if (throwable instanceof AccessDeniedException) {
                    this.writeVInt(5);
                } else if (throwable instanceof FileSystemLoopException) {
                    this.writeVInt(6);
                } else {
                    this.writeVInt(7);
                }
                this.writeOptionalString(((FileSystemException)throwable).getFile());
                this.writeOptionalString(((FileSystemException)throwable).getOtherFile());
                this.writeOptionalString(((FileSystemException)throwable).getReason());
                writeCause = false;
            } else if (throwable instanceof IllegalStateException) {
                this.writeVInt(14);
            } else if (throwable instanceof LockObtainFailedException) {
                this.writeVInt(15);
            } else if (throwable instanceof InterruptedException) {
                this.writeVInt(16);
                writeCause = false;
            } else if (throwable instanceof IOException) {
                this.writeVInt(17);
            } else {
                ElasticsearchException ex = throwable instanceof ElasticsearchException && ElasticsearchException.isRegistered(throwable.getClass(), this.version) ? (ElasticsearchException)throwable : new NotSerializableExceptionWrapper(throwable);
                this.writeVInt(0);
                this.writeVInt(ElasticsearchException.getId(ex.getClass()));
                ex.writeTo(this);
                return;
            }
            if (writeMessage) {
                this.writeOptionalString(throwable.getMessage());
            }
            if (writeCause) {
                this.writeException(throwable.getCause());
            }
            ElasticsearchException.writeStackTraces(throwable, this);
        }
    }

    public void writeNamedWriteable(NamedWriteable namedWriteable) throws IOException {
        this.writeString(namedWriteable.getWriteableName());
        namedWriteable.writeTo(this);
    }

    public void writeOptionalNamedWriteable(@Nullable NamedWriteable namedWriteable) throws IOException {
        if (namedWriteable == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeNamedWriteable(namedWriteable);
        }
    }

    public void writeGeoPoint(GeoPoint geoPoint) throws IOException {
        this.writeDouble(geoPoint.lat());
        this.writeDouble(geoPoint.lon());
    }

    public void writeTimeZone(DateTimeZone timeZone) throws IOException {
        this.writeString(timeZone.getID());
    }

    public void writeOptionalTimeZone(@Nullable DateTimeZone timeZone) throws IOException {
        if (timeZone == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeTimeZone(timeZone);
        }
    }

    public void writeStreamableList(List<? extends Streamable> list) throws IOException {
        this.writeVInt(list.size());
        for (Streamable streamable : list) {
            streamable.writeTo(this);
        }
    }

    public void writeList(List<? extends Writeable> list) throws IOException {
        this.writeVInt(list.size());
        for (Writeable writeable : list) {
            writeable.writeTo(this);
        }
    }

    public void writeStringList(List<String> list) throws IOException {
        this.writeVInt(list.size());
        for (String string : list) {
            this.writeString(string);
        }
    }

    public void writeNamedWriteableList(List<? extends NamedWriteable> list) throws IOException {
        this.writeVInt(list.size());
        for (NamedWriteable namedWriteable : list) {
            this.writeNamedWriteable(namedWriteable);
        }
    }

    public <E extends Enum<E>> void writeEnum(E enumValue) throws IOException {
        this.writeVInt(enumValue.ordinal());
    }

    static {
        HashMap<Class, Writeable.Writer<Object>> writers = new HashMap<Class, Writeable.Writer<Object>>();
        writers.put(String.class, (o, v) -> {
            o.writeByte((byte)0);
            o.writeString((String)v);
        });
        writers.put(Integer.class, (o, v) -> {
            o.writeByte((byte)1);
            o.writeInt((Integer)v);
        });
        writers.put(Long.class, (o, v) -> {
            o.writeByte((byte)2);
            o.writeLong((Long)v);
        });
        writers.put(Float.class, (o, v) -> {
            o.writeByte((byte)3);
            o.writeFloat(((Float)v).floatValue());
        });
        writers.put(Double.class, (o, v) -> {
            o.writeByte((byte)4);
            o.writeDouble((Double)v);
        });
        writers.put(Boolean.class, (o, v) -> {
            o.writeByte((byte)5);
            o.writeBoolean((Boolean)v);
        });
        writers.put(byte[].class, (o, v) -> {
            o.writeByte((byte)6);
            byte[] bytes = (byte[])v;
            o.writeVInt(bytes.length);
            o.writeBytes(bytes);
        });
        writers.put(List.class, (o, v) -> {
            o.writeByte((byte)7);
            List list = (List)v;
            o.writeVInt(list.size());
            for (Object item : list) {
                o.writeGenericValue(item);
            }
        });
        writers.put(Object[].class, (o, v) -> {
            o.writeByte((byte)8);
            Object[] list = (Object[])v;
            o.writeVInt(list.length);
            for (Object item : list) {
                o.writeGenericValue(item);
            }
        });
        writers.put(Map.class, (o, v) -> {
            if (v instanceof LinkedHashMap) {
                o.writeByte((byte)9);
            } else {
                o.writeByte((byte)10);
            }
            Map map = (Map)v;
            o.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                o.writeString((String)entry.getKey());
                o.writeGenericValue(entry.getValue());
            }
        });
        writers.put(Byte.class, (o, v) -> {
            o.writeByte((byte)11);
            o.writeByte((Byte)v);
        });
        writers.put(Date.class, (o, v) -> {
            o.writeByte((byte)12);
            o.writeLong(((Date)v).getTime());
        });
        writers.put(ReadableInstant.class, (o, v) -> {
            o.writeByte((byte)13);
            ReadableInstant instant = (ReadableInstant)v;
            o.writeString(instant.getZone().getID());
            o.writeLong(instant.getMillis());
        });
        writers.put(BytesReference.class, (o, v) -> {
            o.writeByte((byte)14);
            o.writeBytesReference((BytesReference)v);
        });
        writers.put(Text.class, (o, v) -> {
            o.writeByte((byte)15);
            o.writeText((Text)v);
        });
        writers.put(Short.class, (o, v) -> {
            o.writeByte((byte)16);
            o.writeShort((Short)v);
        });
        writers.put(int[].class, (o, v) -> {
            o.writeByte((byte)17);
            o.writeIntArray((int[])v);
        });
        writers.put(long[].class, (o, v) -> {
            o.writeByte((byte)18);
            o.writeLongArray((long[])v);
        });
        writers.put(float[].class, (o, v) -> {
            o.writeByte((byte)19);
            o.writeFloatArray((float[])v);
        });
        writers.put(double[].class, (o, v) -> {
            o.writeByte((byte)20);
            o.writeDoubleArray((double[])v);
        });
        writers.put(BytesRef.class, (o, v) -> {
            o.writeByte((byte)21);
            o.writeBytesRef((BytesRef)v);
        });
        writers.put(GeoPoint.class, (o, v) -> {
            o.writeByte((byte)22);
            o.writeGeoPoint((GeoPoint)v);
        });
        WRITERS = Collections.unmodifiableMap(writers);
    }
}

