/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.loader;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.loader.SettingsLoader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.loader.YamlSettingsLoader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;

public final class SettingsLoaderFactory {
    private SettingsLoaderFactory() {
    }

    public static SettingsLoader loaderFromResource(String resourceName) {
        if (resourceName.endsWith(".json")) {
            return new JsonSettingsLoader(false);
        }
        if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml")) {
            return new YamlSettingsLoader(false);
        }
        throw new IllegalArgumentException("unable to detect content type from resource name [" + resourceName + "]");
    }

    @Deprecated
    public static SettingsLoader loaderFromSource(String source) {
        if (source.indexOf(123) != -1 && source.indexOf(125) != -1) {
            return new JsonSettingsLoader(true);
        }
        if (source.indexOf(58) != -1) {
            return new YamlSettingsLoader(true);
        }
        throw new IllegalArgumentException("unable to detect content type from source [" + source + "]");
    }

    public static SettingsLoader loaderFromXContentType(XContentType xContentType) {
        if (xContentType == XContentType.JSON) {
            return new JsonSettingsLoader(true);
        }
        if (xContentType == XContentType.YAML) {
            return new YamlSettingsLoader(true);
        }
        throw new IllegalArgumentException("unsupported content type [" + xContentType + "]");
    }
}

