/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.json;

import java.io.IOException;
import java.nio.CharBuffer;
import org.graylog.shaded.elasticsearch5.com.fasterxml.jackson.core.JsonLocation;
import org.graylog.shaded.elasticsearch5.com.fasterxml.jackson.core.JsonParser;
import org.graylog.shaded.elasticsearch5.com.fasterxml.jackson.core.JsonToken;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentLocation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.support.AbstractXContentParser;

public class JsonXContentParser
extends AbstractXContentParser {
    final JsonParser parser;

    public JsonXContentParser(NamedXContentRegistry xContentRegistry, JsonParser parser) {
        super(xContentRegistry);
        this.parser = parser;
    }

    @Override
    public XContentType contentType() {
        return XContentType.JSON;
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        return this.convertToken(this.parser.nextToken());
    }

    @Override
    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    @Override
    public XContentParser.Token currentToken() {
        return this.convertToken(this.parser.getCurrentToken());
    }

    @Override
    public XContentParser.NumberType numberType() throws IOException {
        return this.convertNumberType(this.parser.getNumberType());
    }

    @Override
    public String currentName() throws IOException {
        return this.parser.getCurrentName();
    }

    @Override
    protected boolean doBooleanValue() throws IOException {
        return this.parser.getBooleanValue();
    }

    @Override
    public String text() throws IOException {
        if (this.currentToken().isValue()) {
            return this.parser.getText();
        }
        throw new IllegalStateException("Can't get text on a " + (Object)((Object)this.currentToken()) + " at " + this.getTokenLocation());
    }

    @Override
    public BytesRef utf8Bytes() throws IOException {
        return new BytesRef(CharBuffer.wrap(this.parser.getTextCharacters(), this.parser.getTextOffset(), this.parser.getTextLength()));
    }

    @Override
    public Object objectText() throws IOException {
        JsonToken currentToken = this.parser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return this.text();
        }
        if (currentToken == JsonToken.VALUE_NUMBER_INT || currentToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getNumberValue();
        }
        if (currentToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (currentToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public Object objectBytes() throws IOException {
        JsonToken currentToken = this.parser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return this.utf8Bytes();
        }
        if (currentToken == JsonToken.VALUE_NUMBER_INT || currentToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getNumberValue();
        }
        if (currentToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (currentToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        return this.utf8Bytes();
    }

    @Override
    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    @Override
    public char[] textCharacters() throws IOException {
        return this.parser.getTextCharacters();
    }

    @Override
    public int textLength() throws IOException {
        return this.parser.getTextLength();
    }

    @Override
    public int textOffset() throws IOException {
        return this.parser.getTextOffset();
    }

    @Override
    public Number numberValue() throws IOException {
        return this.parser.getNumberValue();
    }

    @Override
    public short doShortValue() throws IOException {
        return this.parser.getShortValue();
    }

    @Override
    public int doIntValue() throws IOException {
        return this.parser.getIntValue();
    }

    @Override
    public long doLongValue() throws IOException {
        return this.parser.getLongValue();
    }

    @Override
    public float doFloatValue() throws IOException {
        return this.parser.getFloatValue();
    }

    @Override
    public double doDoubleValue() throws IOException {
        return this.parser.getDoubleValue();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.parser.getBinaryValue();
    }

    @Override
    public XContentLocation getTokenLocation() {
        JsonLocation loc = this.parser.getTokenLocation();
        if (loc == null) {
            return null;
        }
        return new XContentLocation(loc.getLineNr(), loc.getColumnNr());
    }

    @Override
    public void close() {
        IOUtils.closeWhileHandlingException(this.parser);
    }

    private XContentParser.NumberType convertNumberType(JsonParser.NumberType numberType) {
        switch (numberType) {
            case INT: {
                return XContentParser.NumberType.INT;
            }
            case LONG: {
                return XContentParser.NumberType.LONG;
            }
            case FLOAT: {
                return XContentParser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return XContentParser.NumberType.DOUBLE;
            }
        }
        throw new IllegalStateException("No matching token for number_type [" + (Object)((Object)numberType) + "]");
    }

    private XContentParser.Token convertToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case FIELD_NAME: {
                return XContentParser.Token.FIELD_NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return XContentParser.Token.VALUE_BOOLEAN;
            }
            case VALUE_STRING: {
                return XContentParser.Token.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return XContentParser.Token.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return XContentParser.Token.VALUE_NULL;
            }
            case START_OBJECT: {
                return XContentParser.Token.START_OBJECT;
            }
            case END_OBJECT: {
                return XContentParser.Token.END_OBJECT;
            }
            case START_ARRAY: {
                return XContentParser.Token.START_ARRAY;
            }
            case END_ARRAY: {
                return XContentParser.Token.END_ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return XContentParser.Token.VALUE_EMBEDDED_OBJECT;
            }
        }
        throw new IllegalStateException("No matching token for json_token [" + (Object)((Object)token) + "]");
    }

    @Override
    public boolean isClosed() {
        return this.parser.isClosed();
    }
}

