/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network.NetworkService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.Discovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.NoneDiscovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.single.SingleNodeDiscovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen.ZenDiscovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.DiscoveryPlugin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<Optional<String>> DISCOVERY_HOSTS_PROVIDER_SETTING = new Setting<Optional>("discovery.zen.hosts_provider", (String)null, Optional::ofNullable, Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, ClusterService clusterService, List<DiscoveryPlugin> plugins) {
        UnicastHostsProvider hostsProvider;
        HashMap hostProviders = new HashMap();
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getZenHostsProviders(transportService, networkService).entrySet().forEach(entry -> {
                if (hostProviders.put(entry.getKey(), entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register zen hosts provider [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        Optional<String> hostsProviderName = DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        if (hostsProviderName.isPresent()) {
            Supplier hostsProviderSupplier = (Supplier)hostProviders.get(hostsProviderName.get());
            if (hostsProviderSupplier == null) {
                throw new IllegalArgumentException("Unknown zen hosts provider [" + hostsProviderName.get() + "]");
            }
            hostsProvider = (UnicastHostsProvider)Objects.requireNonNull(hostsProviderSupplier.get());
        } else {
            hostsProvider = Collections::emptyList;
        }
        HashMap<String, Supplier<Discovery>> discoveryTypes = new HashMap<String, Supplier<Discovery>>();
        discoveryTypes.put("zen", () -> new ZenDiscovery(settings, threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider));
        discoveryTypes.put("none", () -> new NoneDiscovery(settings, clusterService, clusterService.getClusterSettings()));
        discoveryTypes.put("single-node", () -> new SingleNodeDiscovery(settings, clusterService));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getDiscoveryTypes(threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider).entrySet().forEach(entry -> {
                if (discoveryTypes.put((String)entry.getKey(), (Supplier<Discovery>)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register discovery type [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        Supplier discoverySupplier = (Supplier)discoveryTypes.get(discoveryType);
        if (discoverySupplier == null) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        Loggers.getLogger(this.getClass(), settings, new String[0]).info("using discovery type [{}]", (Object)discoveryType);
        this.discovery = (Discovery)Objects.requireNonNull(discoverySupplier.get());
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

