/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.core.TypeTokenFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class KeepTypesFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<String> keepTypes;
    private static final String KEEP_TYPES_KEY = "types";

    public KeepTypesFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String[] arrayKeepTypes = settings.getAsArray(KEEP_TYPES_KEY, null);
        if (arrayKeepTypes == null) {
            throw new IllegalArgumentException("keep_types requires `types` to be configured");
        }
        this.keepTypes = new HashSet<String>(Arrays.asList(arrayKeepTypes));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new TypeTokenFilter(tokenStream, this.keepTypes, true);
    }
}

