/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.Analysis;

public class KeywordMarkerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keywordLookup;
    private final Pattern keywordPattern;

    public KeywordMarkerTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        boolean ignoreCase = settings.getAsBoolean("ignore_case", false);
        String patternString = settings.get("keywords_pattern");
        if (patternString != null) {
            if (settings.get("keywords") != null || settings.get("keywords_path") != null) {
                throw new IllegalArgumentException("cannot specify both `keywords_pattern` and `keywords` or `keywords_path`");
            }
            this.keywordPattern = Pattern.compile(patternString);
            this.keywordLookup = null;
        } else {
            CharArraySet rules = Analysis.getWordSet(env, settings, "keywords");
            if (rules == null) {
                throw new IllegalArgumentException("keyword filter requires either `keywords`, `keywords_path`, or `keywords_pattern` to be configured");
            }
            this.keywordLookup = new CharArraySet(rules, ignoreCase);
            this.keywordPattern = null;
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.keywordPattern != null) {
            return new PatternKeywordMarkerFilter(tokenStream, this.keywordPattern);
        }
        return new SetKeywordMarkerFilter(tokenStream, this.keywordLookup);
    }
}

