/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.ga.IrishLowerCaseFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.MultiTermAwareComponent;

public class LowerCaseTokenFilterFactory
extends AbstractTokenFilterFactory
implements MultiTermAwareComponent {
    private final String lang;

    public LowerCaseTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.lang = settings.get("language", null);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.lang == null) {
            return new LowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("greek")) {
            return new GreekLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("irish")) {
            return new IrishLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("turkish")) {
            return new TurkishLowerCaseFilter(tokenStream);
        }
        throw new IllegalArgumentException("language [" + this.lang + "] not support for lower case");
    }

    @Override
    public Object getMultiTermComponent() {
        return this;
    }
}

