/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class PathHierarchyTokenizerFactory
extends AbstractTokenizerFactory {
    private final int bufferSize;
    private final char delimiter;
    private final char replacement;
    private final int skip;
    private final boolean reverse;

    public PathHierarchyTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.bufferSize = settings.getAsInt("buffer_size", 1024);
        String delimiter = settings.get("delimiter");
        if (delimiter == null) {
            this.delimiter = (char)47;
        } else {
            if (delimiter.length() > 1) {
                throw new IllegalArgumentException("delimiter can only be a one char value");
            }
            this.delimiter = delimiter.charAt(0);
        }
        String replacement = settings.get("replacement");
        if (replacement == null) {
            this.replacement = this.delimiter;
        } else {
            if (replacement.length() > 1) {
                throw new IllegalArgumentException("replacement can only be a one char value");
            }
            this.replacement = replacement.charAt(0);
        }
        this.skip = settings.getAsInt("skip", 0);
        this.reverse = settings.getAsBoolean("reverse", false);
    }

    @Override
    public Tokenizer create() {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(this.bufferSize, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(this.bufferSize, this.delimiter, this.replacement, this.skip);
    }
}

