/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.VersionValue;

class LiveVersionMap
implements ReferenceManager.RefreshListener,
Accountable {
    private final Map<BytesRef, VersionValue> tombstones = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private volatile Maps maps = new Maps();
    private ReferenceManager<?> mgr;
    private static final long BASE_BYTES_PER_BYTESREF = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 3L;
    private static final long BASE_BYTES_PER_CHM_ENTRY;
    final AtomicLong ramBytesUsedCurrent = new AtomicLong();
    final AtomicLong ramBytesUsedTombstones = new AtomicLong();

    LiveVersionMap() {
    }

    synchronized void setManager(ReferenceManager<?> newMgr) {
        if (this.mgr != null) {
            this.mgr.removeListener(this);
        }
        this.mgr = newMgr;
        this.maps = new Maps();
        this.mgr.addListener(this);
    }

    @Override
    public void beforeRefresh() throws IOException {
        this.maps = new Maps(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(this.maps.current.size()), this.maps.current);
        this.ramBytesUsedCurrent.set(0L);
    }

    @Override
    public void afterRefresh(boolean didRefresh) throws IOException {
        this.maps = new Maps(this.maps.current, Collections.emptyMap());
    }

    VersionValue getUnderLock(BytesRef uid) {
        Maps currentMaps = this.maps;
        VersionValue value = currentMaps.current.get(uid);
        if (value != null) {
            return value;
        }
        value = currentMaps.old.get(uid);
        if (value != null) {
            return value;
        }
        return this.tombstones.get(uid);
    }

    void putUnderLock(BytesRef uid, VersionValue version) {
        VersionValue prevTombstone;
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = this.maps.current.put(uid, version);
        if (prev != null) {
            long prevBytes = BASE_BYTES_PER_CHM_ENTRY;
            if (!prev.isDelete()) {
                prevBytes += prev.ramBytesUsed() + uidRAMBytesUsed;
            }
            this.ramBytesUsedCurrent.addAndGet(-prevBytes);
        }
        long newBytes = BASE_BYTES_PER_CHM_ENTRY;
        if (!version.isDelete()) {
            newBytes += version.ramBytesUsed() + uidRAMBytesUsed;
        }
        this.ramBytesUsedCurrent.addAndGet(newBytes);
        if (version.isDelete()) {
            prevTombstone = this.tombstones.put(uid, version);
            this.ramBytesUsedTombstones.addAndGet(BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRAMBytesUsed);
            if (prevTombstone == null && prev != null && prev.isDelete()) {
                this.ramBytesUsedCurrent.addAndGet(-(prev.ramBytesUsed() + uidRAMBytesUsed));
            }
        } else {
            prevTombstone = this.tombstones.remove(uid);
        }
        if (prevTombstone != null) {
            long v = this.ramBytesUsedTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prevTombstone.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    void removeTombstoneUnderLock(BytesRef uid) {
        VersionValue curVersion;
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = this.tombstones.remove(uid);
        if (prev != null) {
            assert (prev.isDelete());
            long v = this.ramBytesUsedTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prev.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
        if ((curVersion = this.maps.current.get(uid)) != null && curVersion.isDelete()) {
            this.ramBytesUsedCurrent.addAndGet(curVersion.ramBytesUsed() + uidRAMBytesUsed);
        }
    }

    VersionValue getTombstoneUnderLock(BytesRef uid) {
        return this.tombstones.get(uid);
    }

    Iterable<Map.Entry<BytesRef, VersionValue>> getAllTombstones() {
        return this.tombstones.entrySet();
    }

    void clearTombstones() {
        this.tombstones.clear();
    }

    synchronized void clear() {
        this.maps = new Maps();
        this.tombstones.clear();
        this.ramBytesUsedCurrent.set(0L);
        if (this.mgr != null) {
            this.mgr.removeListener(this);
            this.mgr = null;
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsedCurrent.get() + this.ramBytesUsedTombstones.get();
    }

    long ramBytesUsedForRefresh() {
        return this.ramBytesUsedCurrent.get();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    Map<BytesRef, VersionValue> getAllCurrent() {
        return this.maps.current;
    }

    static {
        ConcurrentMap<Integer, Integer> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        map.put(0, 0);
        long chmEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_BYTES_PER_CHM_ENTRY = chmEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    private static class Maps {
        final Map<BytesRef, VersionValue> current;
        final Map<BytesRef, VersionValue> old;

        Maps(Map<BytesRef, VersionValue> current, Map<BytesRef, VersionValue> old) {
            this.current = current;
            this.old = old;
        }

        Maps() {
            this(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), Collections.emptyMap());
        }
    }
}

