/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LatLonDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.LatLonPointDVAtomicFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.MultiValueMode;

public abstract class AbstractLatLonPointDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexGeoPointFieldData {
    AbstractLatLonPointDVIndexFieldData(Index index, String fieldName) {
        super(index, fieldName);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new LatLonPointDVIndexFieldData(indexSettings.getIndex(), fieldType.name());
        }
    }

    public static class LatLonPointDVIndexFieldData
    extends AbstractLatLonPointDVIndexFieldData {
        public LatLonPointDVIndexFieldData(Index index, String fieldName) {
            super(index, fieldName);
        }

        @Override
        public AtomicGeoPointFieldData load(LeafReaderContext context) {
            try {
                LeafReader reader = context.reader();
                FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
                if (info != null) {
                    LatLonPointDVIndexFieldData.checkCompatible(info);
                }
                return new LatLonPointDVAtomicFieldData(DocValues.getSortedNumeric(reader, this.fieldName));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public AtomicGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        static void checkCompatible(FieldInfo fieldInfo) {
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != LatLonDocValuesField.TYPE.docValuesType()) {
                throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)LatLonDocValuesField.TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
            }
        }
    }
}

