/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountables;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BitSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.LongArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.FieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.GeoPointValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

public abstract class GeoPointArrayAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    @Override
    public void close() {
    }

    public static class Single
    extends GeoPointArrayAtomicFieldData {
        private final LongArray indexedPoint;
        private final BitSet set;

        public Single(LongArray indexedPoint, BitSet set) {
            this.indexedPoint = indexedPoint;
            this.set = set;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.indexedPoint.ramBytesUsed() + (this.set == null ? 0L : this.set.ramBytesUsed());
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("indexedPoints", this.indexedPoint));
            if (this.set != null) {
                resources.add(Accountables.namedAccountable("missing bitset", this.set));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final GeoPoint point = new GeoPoint();
            GeoPointValues values = new GeoPointValues(){

                @Override
                public GeoPoint get(int docID) {
                    if (set == null || set.get(docID)) {
                        return point.resetFromIndexHash(indexedPoint.get(docID));
                    }
                    return point.reset(Double.NaN, Double.NaN);
                }
            };
            return FieldData.singleton(values, (Bits)this.set);
        }
    }

    static class WithOrdinals
    extends GeoPointArrayAtomicFieldData {
        private final LongArray indexedPoints;
        private final Ordinals ordinals;
        private final int maxDoc;

        WithOrdinals(LongArray indexedPoints, Ordinals ordinals, int maxDoc) {
            this.indexedPoints = indexedPoints;
            this.ordinals = ordinals;
            this.maxDoc = maxDoc;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.indexedPoints.ramBytesUsed();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("indexedPoints", this.indexedPoints));
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final RandomAccessOrds ords = this.ordinals.ordinals();
            final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
            final GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
            if (singleOrds != null) {
                GeoPointValues values = new GeoPointValues(){

                    @Override
                    public GeoPoint get(int docID) {
                        int ord = singleOrds.getOrd(docID);
                        if (ord >= 0) {
                            return point.resetFromIndexHash(indexedPoints.get(ord));
                        }
                        return point.reset(Double.NaN, Double.NaN);
                    }
                };
                return FieldData.singleton(values, DocValues.docsWithValue(singleOrds, this.maxDoc));
            }
            return new MultiGeoPointValues(){

                @Override
                public GeoPoint valueAt(int index) {
                    return point.resetFromIndexHash(indexedPoints.get(ords.ordAt(index)));
                }

                @Override
                public void setDocument(int docId) {
                    ords.setDocument(docId);
                }

                @Override
                public int count() {
                    return ords.cardinality();
                }
            };
        }
    }
}

