/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query;

import java.util.function.LongSupplier;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.template.CompiledTemplate;

public class QueryRewriteContext {
    protected final MapperService mapperService;
    protected final ScriptService scriptService;
    protected final IndexSettings indexSettings;
    private final NamedXContentRegistry xContentRegistry;
    protected final Client client;
    protected final IndexReader reader;
    protected final LongSupplier nowInMillis;

    public QueryRewriteContext(IndexSettings indexSettings, MapperService mapperService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Client client, IndexReader reader, LongSupplier nowInMillis) {
        this.mapperService = mapperService;
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.reader = reader;
        this.nowInMillis = nowInMillis;
    }

    public Client getClient() {
        return this.client;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public QueryParseContext newParseContext(XContentParser parser) {
        return new QueryParseContext(parser);
    }

    public QueryParseContext newParseContextWithLegacyScriptLanguage(XContentParser parser) {
        String defaultScriptLanguage = ScriptSettings.getLegacyDefaultLang(this.indexSettings.getNodeSettings());
        return new QueryParseContext(defaultScriptLanguage, parser);
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public BytesReference getTemplateBytes(Script template) {
        CompiledTemplate compiledTemplate = this.scriptService.compileTemplate(template, ScriptContext.Standard.SEARCH);
        return compiledTemplate.run(template.getParams());
    }
}

