/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.Translog;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.TranslogCorruptedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.TranslogSnapshot;

public abstract class BaseTranslogReader
implements Comparable<BaseTranslogReader> {
    protected final long generation;
    protected final FileChannel channel;
    protected final Path path;
    protected final long firstOperationOffset;

    public BaseTranslogReader(long generation, FileChannel channel, Path path, long firstOperationOffset) {
        assert (Translog.parseIdFromFileName(path) == generation) : "generation mismatch. Path: " + Translog.parseIdFromFileName(path) + " but generation: " + generation;
        this.generation = generation;
        this.path = path;
        this.channel = channel;
        this.firstOperationOffset = firstOperationOffset;
    }

    public long getGeneration() {
        return this.generation;
    }

    public abstract long sizeInBytes();

    public abstract int totalOperations();

    public final long getFirstOperationOffset() {
        return this.firstOperationOffset;
    }

    protected final int readSize(ByteBuffer reusableBuffer, long position) throws IOException {
        assert (reusableBuffer.capacity() >= 4) : "reusable buffer must have capacity >=4 when reading opSize. got [" + reusableBuffer.capacity() + "]";
        reusableBuffer.clear();
        reusableBuffer.limit(4);
        this.readBytes(reusableBuffer, position);
        reusableBuffer.flip();
        int size = reusableBuffer.getInt() + 4;
        long maxSize = this.sizeInBytes() - position;
        if (size < 0 || (long)size > maxSize) {
            throw new TranslogCorruptedException("operation size is corrupted must be [0.." + maxSize + "] but was: " + size);
        }
        return size;
    }

    public Translog.Snapshot newSnapshot() {
        return new TranslogSnapshot(this.generation, this.channel, this.path, this.firstOperationOffset, this.sizeInBytes(), this.totalOperations());
    }

    protected final BufferedChecksumStreamInput checksummedStream(ByteBuffer reusableBuffer, long position, int opSize, BufferedChecksumStreamInput reuse) throws IOException {
        ByteBuffer buffer = reusableBuffer.capacity() >= opSize ? reusableBuffer : ByteBuffer.allocate(opSize);
        buffer.clear();
        buffer.limit(opSize);
        this.readBytes(buffer, position);
        buffer.flip();
        return new BufferedChecksumStreamInput(new ByteBufferStreamInput(buffer), reuse);
    }

    protected Translog.Operation read(BufferedChecksumStreamInput inStream) throws IOException {
        return Translog.readOperation(inStream);
    }

    protected abstract void readBytes(ByteBuffer var1, long var2) throws IOException;

    public String toString() {
        return "translog [" + this.generation + "][" + this.path + "]";
    }

    @Override
    public int compareTo(BaseTranslogReader o) {
        return Long.compare(this.getGeneration(), o.getGeneration());
    }

    public Path path() {
        return this.path;
    }
}

