/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.hunspell.Dictionary;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;

public class HunspellService
extends AbstractComponent {
    public static final Setting<Boolean> HUNSPELL_LAZY_LOAD = Setting.boolSetting("indices.analysis.hunspell.dictionary.lazy", Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Boolean> HUNSPELL_IGNORE_CASE = Setting.boolSetting("indices.analysis.hunspell.dictionary.ignore_case", Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Settings> HUNSPELL_DICTIONARY_OPTIONS = Setting.groupSetting("indices.analysis.hunspell.dictionary.", Setting.Property.NodeScope);
    private final ConcurrentHashMap<String, Dictionary> dictionaries = new ConcurrentHashMap();
    private final Map<String, Dictionary> knownDictionaries;
    private final boolean defaultIgnoreCase;
    private final Path hunspellDir;
    private final Function<String, Dictionary> loadingFunction;

    public HunspellService(Settings settings, Environment env, Map<String, Dictionary> knownDictionaries) throws IOException {
        super(settings);
        this.knownDictionaries = Collections.unmodifiableMap(knownDictionaries);
        this.hunspellDir = this.resolveHunspellDirectory(env);
        this.defaultIgnoreCase = HUNSPELL_IGNORE_CASE.get(settings);
        this.loadingFunction = locale -> {
            try {
                return this.loadDictionary((String)locale, settings, env);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to load hunspell dictionary for locale: " + locale, e);
            }
        };
        if (!HUNSPELL_LAZY_LOAD.get(settings).booleanValue()) {
            this.scanAndLoadDictionaries();
        }
    }

    public Dictionary getDictionary(String locale) {
        Dictionary dictionary = this.knownDictionaries.get(locale);
        if (dictionary == null) {
            dictionary = this.dictionaries.computeIfAbsent(locale, this.loadingFunction);
        }
        return dictionary;
    }

    private Path resolveHunspellDirectory(Environment env) {
        return env.configFile().resolve("hunspell");
    }

    private void scanAndLoadDictionaries() throws IOException {
        if (Files.isDirectory(this.hunspellDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.hunspellDir);){
                for (Path file : stream) {
                    if (!Files.isDirectory(file, new LinkOption[0])) continue;
                    DirectoryStream<Path> inner = Files.newDirectoryStream(this.hunspellDir.resolve(file), "*.dic");
                    Throwable throwable = null;
                    try {
                        if (!inner.iterator().hasNext()) continue;
                        try {
                            this.getDictionary(file.getFileName().toString());
                        }
                        catch (Exception e) {
                            this.logger.error(() -> new ParameterizedMessage("exception while loading dictionary {}", (Object)file.getFileName()), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inner == null) continue;
                        if (throwable != null) {
                            try {
                                inner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inner.close();
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Dictionary loadDictionary(String locale, Settings nodeSettings, Environment env) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Settings loadDictionarySettings(Path dir, Settings defaults) throws IOException {
        Path file = dir.resolve("settings.yml");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        file = dir.resolve("settings.json");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        return defaults;
    }

    private static /* synthetic */ Object lambda$loadDictionary$2(String locale) {
        return new ParameterizedMessage("Could not load hunspell dictionary [{}]", (Object)locale);
    }
}

