/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.jvm;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.jvm.JvmInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.jvm.JvmStats;

public class JvmService
extends AbstractComponent {
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final TimeValue refreshInterval;
    private JvmStats jvmStats = JvmStats.jvmStats();
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.jvm.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public JvmService(Settings settings) {
        super(settings);
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.logger.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
    }

    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        if (System.currentTimeMillis() - this.jvmStats.getTimestamp() > this.refreshInterval.millis()) {
            this.jvmStats = JvmStats.jvmStats();
        }
        return this.jvmStats;
    }
}

