/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestDeleteRepositoryAction
extends BaseRestHandler {
    public RestDeleteRepositoryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.DELETE, "/_snapshot/{repository}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteRepositoryRequest deleteRepositoryRequest = Requests.deleteRepositoryRequest(request.param("repository"));
        deleteRepositoryRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteRepositoryRequest.masterNodeTimeout()));
        deleteRepositoryRequest.timeout(request.paramAsTime("timeout", deleteRepositoryRequest.timeout()));
        deleteRepositoryRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteRepositoryRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().deleteRepository(deleteRepositoryRequest, new AcknowledgedRestListener<DeleteRepositoryResponse>((RestChannel)channel));
    }
}

