/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestCloseIndexAction
extends BaseRestHandler {
    public RestCloseIndexAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_close", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_close", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        closeIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", closeIndexRequest.masterNodeTimeout()));
        closeIndexRequest.timeout(request.paramAsTime("timeout", closeIndexRequest.timeout()));
        closeIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, closeIndexRequest.indicesOptions()));
        return channel -> client.admin().indices().close(closeIndexRequest, new AcknowledgedRestListener<CloseIndexResponse>((RestChannel)channel));
    }
}

