/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestPutMappingAction
extends BaseRestHandler {
    public RestPutMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mappings/{type}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        putMappingRequest.type(request.param("type"));
        putMappingRequest.source(request.requiredContent(), request.getXContentType());
        putMappingRequest.updateAllTypes(request.paramAsBoolean("update_all_types", false));
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new AcknowledgedRestListener<PutMappingResponse>((RestChannel)channel));
    }
}

