/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.script;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptType;

public final class ScriptContextRegistry {
    static final Set<String> RESERVED_SCRIPT_CONTEXTS = ScriptContextRegistry.reservedScriptContexts();
    private final Map<String, ScriptContext> scriptContexts;

    public ScriptContextRegistry(Collection<ScriptContext.Plugin> customScriptContexts) {
        HashMap<String, ScriptContext> scriptContexts = new HashMap<String, ScriptContext>();
        for (ScriptContext.Standard scriptContext : ScriptContext.Standard.values()) {
            scriptContexts.put(scriptContext.getKey(), scriptContext);
        }
        for (ScriptContext.Plugin customScriptContext : customScriptContexts) {
            this.validateScriptContext(customScriptContext);
            ScriptContext previousContext = scriptContexts.put(customScriptContext.getKey(), customScriptContext);
            if (previousContext == null) continue;
            throw new IllegalArgumentException("script context [" + customScriptContext.getKey() + "] cannot be registered twice");
        }
        this.scriptContexts = Collections.unmodifiableMap(scriptContexts);
    }

    Collection<ScriptContext> scriptContexts() {
        return this.scriptContexts.values();
    }

    boolean isSupportedContext(String scriptContext) {
        return this.scriptContexts.containsKey(scriptContext);
    }

    private void validateScriptContext(ScriptContext.Plugin scriptContext) {
        if (RESERVED_SCRIPT_CONTEXTS.contains(scriptContext.getPluginName())) {
            throw new IllegalArgumentException("[" + scriptContext.getPluginName() + "] is a reserved name, it cannot be registered as a custom script context");
        }
        if (RESERVED_SCRIPT_CONTEXTS.contains(scriptContext.getOperation())) {
            throw new IllegalArgumentException("[" + scriptContext.getOperation() + "] is a reserved name, it cannot be registered as a custom script context");
        }
    }

    private static Set<String> reservedScriptContexts() {
        HashSet<String> reserved = new HashSet<String>(ScriptType.values().length + ScriptContext.Standard.values().length);
        for (ScriptType scriptType : ScriptType.values()) {
            reserved.add(scriptType.toString());
        }
        for (Enum enum_ : ScriptContext.Standard.values()) {
            reserved.add(((ScriptContext.Standard)enum_).getKey());
        }
        reserved.add("script");
        reserved.add("engine");
        return Collections.unmodifiableSet(reserved);
    }
}

