/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalMultiBucketAggregation<A extends InternalMultiBucketAggregation, B extends InternalBucket>
extends InternalAggregation
implements MultiBucketsAggregation {
    public InternalMultiBucketAggregation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
    }

    protected InternalMultiBucketAggregation(StreamInput in) throws IOException {
        super(in);
    }

    public abstract A create(List<B> var1);

    public abstract B createBucket(InternalAggregations var1, B var2);

    public abstract List<? extends InternalBucket> getBuckets();

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.get(0).equals("_bucket_count")) {
            return this.getBuckets().size();
        }
        List<InternalBucket> buckets = this.getBuckets();
        Object[] propertyArray = new Object[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            propertyArray[i] = buckets.get(i).getProperty(this.getName(), path);
        }
        return propertyArray;
    }

    public static abstract class InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Writeable {
        public Object getProperty(String containingAggName, List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            Aggregations aggregations = this.getAggregations();
            String aggName = path.get(0);
            if (aggName.equals("_count")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_count must be the last element in the path");
                }
                return this.getDocCount();
            }
            if (aggName.equals("_key")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_key must be the last element in the path");
                }
                return this.getKey();
            }
            InternalAggregation aggregation = (InternalAggregation)aggregations.get(aggName);
            if (aggregation == null) {
                throw new InvalidAggregationPathException("Cannot find an aggregation named [" + aggName + "] in [" + containingAggName + "]");
            }
            return aggregation.getProperty(path.subList(1, path.size()));
        }
    }
}

