/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.NXYSignificanceHeuristic;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;

public class GND
extends NXYSignificanceHeuristic {
    public static final String NAME = "gnd";
    public static final SignificanceHeuristicParser PARSER = new NXYSignificanceHeuristic.NXYParser(){

        @Override
        protected SignificanceHeuristic newHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
            return new GND(backgroundIsSuperset);
        }

        @Override
        public SignificanceHeuristic parse(QueryParseContext context) throws IOException, QueryShardException {
            XContentParser parser = context.parser();
            String givenName = parser.currentName();
            boolean backgroundIsSuperset = true;
            XContentParser.Token token = parser.nextToken();
            while (!token.equals((Object)XContentParser.Token.END_OBJECT)) {
                if (!NXYSignificanceHeuristic.BACKGROUND_IS_SUPERSET.match(parser.currentName())) {
                    throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown field [{}]", givenName, parser.currentName());
                }
                parser.nextToken();
                backgroundIsSuperset = parser.booleanValue();
                token = parser.nextToken();
            }
            return this.newHeuristic(true, backgroundIsSuperset);
        }
    };

    public GND(boolean backgroundIsSuperset) {
        super(true, backgroundIsSuperset);
    }

    public GND(StreamInput in) throws IOException {
        super(true, in.readBoolean());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.backgroundIsSuperset);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GND)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = NAME.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "GND");
        double fx = frequencies.N1_;
        double fy = frequencies.N_1;
        double fxy = frequencies.N11;
        double N = frequencies.N;
        if (fxy == 0.0) {
            return 0.0;
        }
        if (fx == fy && fx == fxy) {
            return 1.0;
        }
        double score = (Math.max(Math.log(fx), Math.log(fy)) - Math.log(fxy)) / (Math.log(N) - Math.min(Math.log(fx), Math.log(fy)));
        score = Math.exp(-1.0 * score);
        return score;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
        builder.endObject();
        return builder;
    }

    public static class GNDBuilder
    extends NXYSignificanceHeuristic.NXYBuilder {
        public GNDBuilder(boolean backgroundIsSuperset) {
            super(true, backgroundIsSuperset);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GND.NAME);
            builder.field(NXYSignificanceHeuristic.BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
            builder.endObject();
            return builder;
        }
    }
}

