/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.max;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.DoubleArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.MultiValueMode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class MaxAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat formatter;
    DoubleArray maxes;

    public MaxAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(ctx);
        final NumericDoubleValues values = MultiValueMode.MAX.select(allValues, Double.NEGATIVE_INFINITY);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MaxAggregator.this.maxes.size()) {
                    long from = MaxAggregator.this.maxes.size();
                    MaxAggregator.this.maxes = bigArrays.grow(MaxAggregator.this.maxes, bucket + 1L);
                    MaxAggregator.this.maxes.fill(from, MaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                double value = values.get(doc);
                double max = MaxAggregator.this.maxes.get(bucket);
                max = Math.max(max, value);
                MaxAggregator.this.maxes.set(bucket, max);
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.maxes);
    }
}

