/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.CollectionUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ExecutableScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.LeafSearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.SearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricAggregator
extends MetricsAggregator {
    private final SearchScript mapScript;
    private final ExecutableScript combineScript;
    private final Script reduceScript;
    private Map<String, Object> params;

    protected ScriptedMetricAggregator(String name, SearchScript mapScript, ExecutableScript combineScript, Script reduceScript, Map<String, Object> params, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.params = params;
        this.mapScript = mapScript;
        this.combineScript = combineScript;
        this.reduceScript = reduceScript;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final LeafSearchScript leafMapScript = this.mapScript.getLeafSearchScript(ctx);
        return new LeafBucketCollectorBase(sub, leafMapScript){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : bucket;
                leafMapScript.setDocument(doc);
                leafMapScript.run();
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object aggregation;
        if (this.combineScript != null) {
            aggregation = this.combineScript.run();
            CollectionUtils.ensureNoSelfReferences(aggregation);
        } else {
            aggregation = this.params.get("_agg");
        }
        return new InternalScriptedMetric(this.name, aggregation, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, (Object)null, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }
}

