/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Uid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSearchResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public final class InnerHitsFetchSubPhase
implements FetchSubPhase {
    private final FetchPhase fetchPhase;

    public InnerHitsFetchSubPhase(FetchPhase fetchPhase) {
        this.fetchPhase = fetchPhase;
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) {
        if (!(context.innerHits() != null && context.innerHits().getInnerHits().size() > 0)) {
            return;
        }
        for (Map.Entry<String, InnerHitsContext.InnerHitSubContext> entry : context.innerHits().getInnerHits().entrySet()) {
            TopDocs[] topDocs;
            InnerHitsContext.InnerHitSubContext innerHits = entry.getValue();
            try {
                topDocs = innerHits.topDocs(hits);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
            for (int i = 0; i < hits.length; ++i) {
                SearchHit hit = hits[i];
                TopDocs topDoc = topDocs[i];
                Map<String, SearchHits> results = hit.getInnerHits();
                if (results == null) {
                    results = new HashMap<String, SearchHits>();
                    hit.setInnerHits(results);
                }
                innerHits.queryResult().topDocs(topDoc, innerHits.sort() == null ? null : innerHits.sort().formats);
                int[] docIdsToLoad = new int[topDoc.scoreDocs.length];
                for (int j = 0; j < topDoc.scoreDocs.length; ++j) {
                    docIdsToLoad[j] = topDoc.scoreDocs[j].doc;
                }
                innerHits.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
                innerHits.setUid(new Uid(hit.getType(), hit.getId()));
                this.fetchPhase.execute(innerHits);
                FetchSearchResult fetchResult = innerHits.fetchResult();
                SearchHit[] internalHits = fetchResult.fetchResult().hits().internalHits();
                for (int j = 0; j < internalHits.length; ++j) {
                    ScoreDoc scoreDoc = topDoc.scoreDocs[j];
                    SearchHit searchHitFields = internalHits[j];
                    searchHitFields.score(scoreDoc.score);
                    if (!(scoreDoc instanceof FieldDoc)) continue;
                    FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                    searchHitFields.sortValues(fieldDoc.fields, innerHits.sort().formats);
                }
                results.put(entry.getKey(), fetchResult.hits());
            }
        }
    }
}

