/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.LeafDocLookup;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.LeafFieldsLookup;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.LeafIndexLookup;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.SourceLookup;

public class LeafSearchLookup {
    final LeafReaderContext ctx;
    final LeafDocLookup docMap;
    final SourceLookup sourceLookup;
    final LeafFieldsLookup fieldsLookup;
    final LeafIndexLookup indexLookup;
    final Map<String, Object> asMap;

    public LeafSearchLookup(LeafReaderContext ctx, LeafDocLookup docMap, SourceLookup sourceLookup, LeafFieldsLookup fieldsLookup, LeafIndexLookup indexLookup, Map<String, Object> topLevelMap) {
        this.ctx = ctx;
        this.docMap = docMap;
        this.sourceLookup = sourceLookup;
        this.fieldsLookup = fieldsLookup;
        this.indexLookup = indexLookup;
        HashMap<String, Object> asMap = new HashMap<String, Object>(topLevelMap.size() + 5);
        asMap.putAll(topLevelMap);
        asMap.put("doc", docMap);
        asMap.put("_doc", docMap);
        asMap.put("_source", sourceLookup);
        asMap.put("_fields", fieldsLookup);
        asMap.put("_index", indexLookup);
        this.asMap = Collections.unmodifiableMap(asMap);
    }

    public Map<String, Object> asMap() {
        return this.asMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public LeafIndexLookup indexLookup() {
        return this.indexLookup;
    }

    public LeafFieldsLookup fields() {
        return this.fieldsLookup;
    }

    public LeafDocLookup doc() {
        return this.docMap;
    }

    public void setDocument(int docId) {
        this.docMap.setDocument(docId);
        this.sourceLookup.setSegmentAndDocument(this.ctx, docId);
        this.fieldsLookup.setDocument(docId);
        this.indexLookup.setDocument(docId);
    }
}

