/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParserUtils;

public final class ProfileResult
implements Writeable,
ToXContentObject {
    static final ParseField TYPE = new ParseField("type", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField NODE_TIME = new ParseField("time", new String[0]);
    static final ParseField NODE_TIME_NANOS = new ParseField("time_in_nanos", new String[0]);
    static final ParseField CHILDREN = new ParseField("children", new String[0]);
    static final ParseField BREAKDOWN = new ParseField("breakdown", new String[0]);
    private final String type;
    private final String description;
    private final Map<String, Long> timings;
    private final long nodeTime;
    private final List<ProfileResult> children;

    public ProfileResult(String type, String description, Map<String, Long> timings, List<ProfileResult> children) {
        this.type = type;
        this.description = description;
        this.timings = Objects.requireNonNull(timings, "required timings argument missing");
        this.children = children;
        this.nodeTime = ProfileResult.getTotalTime(timings);
    }

    public ProfileResult(StreamInput in) throws IOException {
        this.type = in.readString();
        this.description = in.readString();
        this.nodeTime = in.readLong();
        int timingsSize = in.readVInt();
        this.timings = new HashMap<String, Long>(timingsSize);
        for (int i = 0; i < timingsSize; ++i) {
            this.timings.put(in.readString(), in.readLong());
        }
        int size = in.readVInt();
        this.children = new ArrayList<ProfileResult>(size);
        for (int i = 0; i < size; ++i) {
            this.children.add(new ProfileResult(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.description);
        out.writeLong(this.nodeTime);
        out.writeVInt(this.timings.size());
        for (Map.Entry<String, Long> entry : this.timings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeLong(entry.getValue());
        }
        out.writeVInt(this.children.size());
        for (ProfileResult child : this.children) {
            child.writeTo(out);
        }
    }

    public String getLuceneDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.timings);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject().field(TYPE.getPreferredName(), this.type).field(DESCRIPTION.getPreferredName(), this.description).field(NODE_TIME.getPreferredName(), String.format(Locale.US, "%.10gms", (double)this.getTime() / 1000000.0)).field(NODE_TIME_NANOS.getPreferredName(), this.getTime()).field(BREAKDOWN.getPreferredName(), this.timings);
        if (!this.children.isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (ProfileResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }

    public static ProfileResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        String currentFieldName = null;
        String type = null;
        String description = null;
        HashMap<String, Long> timings = new HashMap<String, Long>();
        ArrayList<ProfileResult> children = new ArrayList<ProfileResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TYPE.match(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if (DESCRIPTION.match(currentFieldName)) {
                    description = parser.text();
                    continue;
                }
                if (NODE_TIME.match(currentFieldName)) {
                    parser.text();
                    continue;
                }
                if (NODE_TIME_NANOS.match(currentFieldName)) {
                    parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (BREAKDOWN.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        XContentParserUtils.ensureExpectedToken(parser.currentToken(), XContentParser.Token.FIELD_NAME, parser::getTokenLocation);
                        String name = parser.currentName();
                        XContentParserUtils.ensureExpectedToken(parser.nextToken(), XContentParser.Token.VALUE_NUMBER, parser::getTokenLocation);
                        long value = parser.longValue();
                        timings.put(name, value);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (CHILDREN.match(currentFieldName)) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    children.add(ProfileResult.fromXContent(parser));
                }
                continue;
            }
            parser.skipChildren();
        }
        return new ProfileResult(type, description, timings, children);
    }

    private static long getTotalTime(Map<String, Long> timings) {
        long nodeTime = 0L;
        for (long time : timings.values()) {
            nodeTime += time;
        }
        return nodeTime;
    }
}

