/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.Suggest;

public class PhraseSuggestion
extends Suggest.Suggestion<Entry> {
    public static final String NAME = "phrase";
    public static final int TYPE = 3;

    public PhraseSuggestion() {
    }

    public PhraseSuggestion(String name, int size) {
        super(name, size);
    }

    @Override
    public int getWriteableType() {
        return 3;
    }

    @Override
    protected String getType() {
        return NAME;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static PhraseSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        PhraseSuggestion suggestion = new PhraseSuggestion(name, -1);
        PhraseSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option> {
        protected double cutoffScore = Double.MIN_VALUE;
        private static ObjectParser<Entry, Void> PARSER = new ObjectParser("PhraseSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length, double cutoffScore) {
            super(text, offset, length);
            this.cutoffScore = cutoffScore;
        }

        Entry() {
        }

        public double getCutoffScore() {
            return this.cutoffScore;
        }

        @Override
        protected void merge(Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option> other) {
            super.merge(other);
            if (!(other instanceof Entry)) {
                return;
            }
            Entry otherSuggestionEntry = (Entry)other;
            this.cutoffScore = Math.max(this.cutoffScore, otherSuggestionEntry.cutoffScore);
        }

        @Override
        public void addOption(Suggest.Suggestion.Entry.Option option) {
            if ((double)option.getScore() > this.cutoffScore) {
                this.options.add(option);
            }
        }

        public static Entry fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.cutoffScore = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.cutoffScore);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray(Suggest.Suggestion.Entry::addOptions, (p, c) -> Suggest.Suggestion.Entry.Option.fromXContent(p), new ParseField("options", new String[0]));
        }
    }
}

