/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestOptions;

public final class ConnectionProfile {
    private final List<ConnectionTypeHandle> handles;
    private final int numConnections;
    private final TimeValue connectTimeout;
    private final TimeValue handshakeTimeout;

    public static ConnectionProfile buildSingleChannelProfile(TransportRequestOptions.Type channelType, @Nullable TimeValue connectTimeout, @Nullable TimeValue handshakeTimeout) {
        Builder builder = new Builder();
        builder.addConnections(1, channelType);
        EnumSet<TransportRequestOptions.Type> otherTypes = EnumSet.allOf(TransportRequestOptions.Type.class);
        otherTypes.remove((Object)channelType);
        builder.addConnections(0, (TransportRequestOptions.Type[])otherTypes.stream().toArray(TransportRequestOptions.Type[]::new));
        if (connectTimeout != null) {
            builder.setConnectTimeout(connectTimeout);
        }
        if (handshakeTimeout != null) {
            builder.setHandshakeTimeout(handshakeTimeout);
        }
        return builder.build();
    }

    private ConnectionProfile(List<ConnectionTypeHandle> handles, int numConnections, TimeValue connectTimeout, TimeValue handshakeTimeout) {
        this.handles = handles;
        this.numConnections = numConnections;
        this.connectTimeout = connectTimeout;
        this.handshakeTimeout = handshakeTimeout;
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public int getNumConnections() {
        return this.numConnections;
    }

    public int getNumConnectionsPerType(TransportRequestOptions.Type type) {
        for (ConnectionTypeHandle handle : this.handles) {
            if (!handle.getTypes().contains((Object)type)) continue;
            return handle.length;
        }
        throw new AssertionError((Object)("no handle found for type: " + (Object)((Object)type)));
    }

    List<ConnectionTypeHandle> getHandles() {
        return Collections.unmodifiableList(this.handles);
    }

    static final class ConnectionTypeHandle {
        public final int length;
        public final int offset;
        private final Set<TransportRequestOptions.Type> types;
        private final AtomicInteger counter = new AtomicInteger();

        private ConnectionTypeHandle(int offset, int length, Set<TransportRequestOptions.Type> types) {
            this.length = length;
            this.offset = offset;
            this.types = types;
        }

        <T> T getChannel(T[] channels) {
            if (this.length == 0) {
                throw new IllegalStateException("can't select channel size is 0 for types: " + this.types);
            }
            assert (channels.length >= this.offset + this.length) : "illegal size: " + channels.length + " expected >= " + (this.offset + this.length);
            return channels[this.offset + Math.floorMod(this.counter.incrementAndGet(), this.length)];
        }

        Set<TransportRequestOptions.Type> getTypes() {
            return this.types;
        }
    }

    public static class Builder {
        private final List<ConnectionTypeHandle> handles = new ArrayList<ConnectionTypeHandle>();
        private final Set<TransportRequestOptions.Type> addedTypes = EnumSet.noneOf(TransportRequestOptions.Type.class);
        private int offset = 0;
        private TimeValue connectTimeout;
        private TimeValue handshakeTimeout;

        public Builder() {
        }

        public Builder(ConnectionProfile source) {
            this.handles.addAll(source.getHandles());
            this.offset = source.getNumConnections();
            this.handles.forEach(th -> this.addedTypes.addAll(((ConnectionTypeHandle)th).types));
            this.connectTimeout = source.getConnectTimeout();
            this.handshakeTimeout = source.getHandshakeTimeout();
        }

        public Builder setConnectTimeout(TimeValue connectTimeout) {
            if (connectTimeout.millis() < 0L) {
                throw new IllegalArgumentException("connectTimeout must be non-negative but was: " + connectTimeout);
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setHandshakeTimeout(TimeValue handshakeTimeout) {
            if (handshakeTimeout.millis() < 0L) {
                throw new IllegalArgumentException("handshakeTimeout must be non-negative but was: " + handshakeTimeout);
            }
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        public Builder addConnections(int numConnections, TransportRequestOptions.Type ... types) {
            if (types == null || types.length == 0) {
                throw new IllegalArgumentException("types must not be null");
            }
            for (TransportRequestOptions.Type type : types) {
                if (!this.addedTypes.contains((Object)type)) continue;
                throw new IllegalArgumentException("type [" + (Object)((Object)type) + "] is already registered");
            }
            this.addedTypes.addAll(Arrays.asList(types));
            this.handles.add(new ConnectionTypeHandle(this.offset, numConnections, EnumSet.copyOf(Arrays.asList(types))));
            this.offset += numConnections;
            return this;
        }

        public ConnectionProfile build() {
            EnumSet<TransportRequestOptions.Type> types = EnumSet.allOf(TransportRequestOptions.Type.class);
            types.removeAll(this.addedTypes);
            if (!types.isEmpty()) {
                throw new IllegalStateException("not all types are added for this connection profile - missing types: " + types);
            }
            return new ConnectionProfile(Collections.unmodifiableList(this.handles), this.offset, this.connectTimeout, this.handshakeTimeout);
        }
    }
}

