/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.searchbox.client.JestClient;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.IndexToolsAdapter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class IndexToolsAdapterES6
implements IndexToolsAdapter {
    private static final String AGG_DATE_HISTOGRAM = "source_date_histogram";
    private static final String AGG_MESSAGE_FIELD = "message_field";
    private static final String AGG_FILTER = "message_filter";
    private final JestClient jestClient;

    @Inject
    public IndexToolsAdapterES6(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public Map<DateTime, Map<String, Long>> fieldHistogram(String fieldName, Set<String> indices, Optional<Set<String>> includedStreams, long interval) {
        BoolQueryBuilder queryBuilder = this.buildStreamIdFilter(includedStreams);
        FilterAggregationBuilder the_filter = (FilterAggregationBuilder)AggregationBuilders.filter(AGG_FILTER, queryBuilder).subAggregation(((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram(AGG_DATE_HISTOGRAM).field("timestamp")).subAggregation((AggregationBuilder)AggregationBuilders.terms(AGG_MESSAGE_FIELD).field(fieldName))).interval(interval).minDocCount(1L));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(QueryBuilders.matchAllQuery()).aggregation(the_filter);
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addIndex(indices)).addType("message");
        SearchResult searchResult = JestUtils.execute(this.jestClient, searchBuilder.build(), () -> "Unable to retrieve field histogram.");
        FilterAggregation filterAggregation = searchResult.getAggregations().getFilterAggregation(AGG_FILTER);
        DateHistogramAggregation dateHistogram = filterAggregation.getDateHistogramAggregation(AGG_DATE_HISTOGRAM);
        List<DateHistogramAggregation.DateHistogram> histogramBuckets = dateHistogram.getBuckets();
        HashMap result = Maps.newHashMapWithExpectedSize((int)histogramBuckets.size());
        for (HistogramAggregation.Histogram histogram : histogramBuckets) {
            DateTime date = new DateTime((Object)histogram.getKey()).toDateTime(DateTimeZone.UTC);
            TermsAggregation sourceFieldAgg = histogram.getTermsAggregation(AGG_MESSAGE_FIELD);
            List<TermsAggregation.Entry> termBuckets = sourceFieldAgg.getBuckets();
            HashMap termCounts = Maps.newHashMapWithExpectedSize((int)termBuckets.size());
            for (TermsAggregation.Entry termBucket : termBuckets) {
                termCounts.put(termBucket.getKeyAsString(), termBucket.getCount());
            }
            result.put(date, termCounts);
        }
        return ImmutableMap.copyOf((Map)result);
    }

    public long count(Set<String> indices, Optional<Set<String>> includedStreams) {
        SearchSourceBuilder queryBuilder = new SearchSourceBuilder().query(this.buildStreamIdFilter(includedStreams));
        Count.Builder builder = (Count.Builder)((Count.Builder)((Count.Builder)new Count.Builder().query(queryBuilder.toString()).addIndex(indices)).addType("message")).setParameter("ignore_unavailable", true);
        CountResult result = JestUtils.execute(this.jestClient, builder.build(), () -> "Unable to count documents of index.");
        return result.getCount().longValue();
    }

    private BoolQueryBuilder buildStreamIdFilter(Optional<Set<String>> includedStreams) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must(QueryBuilders.matchAllQuery());
        if (includedStreams.isPresent()) {
            Set<String> streams = includedStreams.get();
            BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
            if (streams.contains("000000000000000000000001")) {
                filterBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("streams")));
            }
            filterBuilder.should(QueryBuilders.termsQuery("streams", streams));
            queryBuilder.filter(filterBuilder);
        }
        return queryBuilder;
    }
}

