/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.FieldTypesLookup;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.util.UniqueNamer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.views.ElasticsearchBackend;

public class ESGeneratedQueryContext
implements GeneratedQueryContext {
    private final ElasticsearchBackend elasticsearchBackend;
    private final Map<String, SearchSourceBuilder> searchTypeQueries = Maps.newHashMap();
    private Map<Object, Object> contextMap = Maps.newHashMap();
    private final UniqueNamer uniqueNamer = new UniqueNamer("agg-");
    private Set<SearchError> errors = Sets.newHashSet();
    private final SearchSourceBuilder ssb;
    private final SearchJob job;
    private final Query query;
    private final Set<QueryResult> results;
    private final FieldTypesLookup fieldTypes;

    @AssistedInject
    public ESGeneratedQueryContext(@Assisted ElasticsearchBackend elasticsearchBackend, @Assisted SearchSourceBuilder ssb, @Assisted SearchJob job, @Assisted Query query, @Assisted Set<QueryResult> results, FieldTypesLookup fieldTypes) {
        this.elasticsearchBackend = elasticsearchBackend;
        this.ssb = ssb;
        this.job = job;
        this.query = query;
        this.results = results;
        this.fieldTypes = fieldTypes;
    }

    public SearchSourceBuilder searchSourceBuilder(SearchType searchType) {
        return this.searchTypeQueries.computeIfAbsent(searchType.id(), ignored -> {
            QueryBuilder queryBuilder = this.generateFilterClause(searchType.filter()).map(filterClause -> new BoolQueryBuilder().must(this.ssb.query()).must((QueryBuilder)filterClause)).orElse(this.ssb.query());
            return this.ssb.copyWithNewSlice(this.ssb.slice()).query(queryBuilder);
        });
    }

    Map<String, SearchSourceBuilder> searchTypeQueries() {
        return this.searchTypeQueries;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("elasticsearch query", (Object)this.ssb).toString();
    }

    public Map<Object, Object> contextMap() {
        return this.contextMap;
    }

    public String nextName() {
        return this.uniqueNamer.nextName();
    }

    private Optional<QueryBuilder> generateFilterClause(Filter filter) {
        return this.elasticsearchBackend.generateFilterClause(filter, this.job, this.query, this.results);
    }

    public String seriesName(SeriesSpec seriesSpec, Pivot pivot) {
        return pivot.id() + "-series-" + seriesSpec.literal();
    }

    public void addAggregation(AggregationBuilder builder, SearchType searchType) {
        this.searchTypeQueries().get(searchType.id()).aggregation(builder);
    }

    public void addAggregations(Collection<AggregationBuilder> builders, SearchType searchType) {
        builders.forEach(builder -> this.searchTypeQueries().get(searchType.id()).aggregation((AggregationBuilder)builder));
    }

    public Optional<String> fieldType(Set<String> streamIds, String field) {
        return this.fieldTypes.getType(streamIds, field);
    }

    public void addError(SearchError error) {
        this.errors.add(error);
    }

    public Collection<SearchError> errors() {
        return this.errors;
    }

    public static interface Factory {
        public ESGeneratedQueryContext create(ElasticsearchBackend var1, SearchSourceBuilder var2, SearchJob var3, Query var4, Set<QueryResult> var5);
    }
}

