/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.name.Named;
import io.searchbox.client.JestClient;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.errors.SearchTypeErrorParser;
import org.graylog.plugins.views.search.filter.QueryStringFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.TimeRangeQueryFactory;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog.storage.elasticsearch6.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch6.views.searchtypes.ESSearchTypeHandler;
import org.graylog2.indexer.ElasticsearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBackend
implements QueryBackend<ESGeneratedQueryContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchBackend.class);
    private final Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers;
    private final JestClient jestClient;
    private final IndexLookup indexLookup;
    private final QueryStringDecorators queryStringDecorators;
    private final ESGeneratedQueryContext.Factory queryContextFactory;
    private final boolean allowLeadingWildcard;

    @Inject
    public ElasticsearchBackend(Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers, JestClient jestClient, IndexLookup indexLookup, QueryStringDecorators queryStringDecorators, ESGeneratedQueryContext.Factory queryContextFactory, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.elasticsearchSearchTypeHandlers = elasticsearchSearchTypeHandlers;
        this.jestClient = jestClient;
        this.indexLookup = indexLookup;
        this.queryStringDecorators = queryStringDecorators;
        this.queryContextFactory = queryContextFactory;
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    private QueryBuilder normalizeQueryString(String queryString) {
        return queryString.isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
    }

    public ESGeneratedQueryContext generate(SearchJob job, Query query, Set<QueryResult> results) {
        ElasticsearchQueryString backendQuery = (ElasticsearchQueryString)query.query();
        ImmutableSet searchTypes = query.searchTypes();
        String queryString = this.queryStringDecorators.decorate(backendQuery.queryString(), job, query, results);
        QueryBuilder normalizedRootQuery = this.normalizeQueryString(queryString);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter(normalizedRootQuery);
        this.generateFilterClause(query.filter(), job, query, results).map(boolQuery::filter);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(boolQuery).from(0).size(0);
        ESGeneratedQueryContext queryContext = this.queryContextFactory.create(this, searchSourceBuilder, job, query, results);
        for (SearchType searchType : searchTypes) {
            SearchSourceBuilder searchTypeSourceBuilder = queryContext.searchSourceBuilder(searchType);
            Set effectiveStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
            BoolQueryBuilder searchTypeOverrides = QueryBuilders.boolQuery().must(searchTypeSourceBuilder.query()).must(Objects.requireNonNull(TimeRangeQueryFactory.create(query.effectiveTimeRange(searchType)), "Timerange for search type " + searchType.id() + " cannot be found in query or search type.")).must(QueryBuilders.termsQuery("streams", effectiveStreamIds));
            searchType.query().ifPresent(q -> {
                ElasticsearchQueryString searchTypeBackendQuery = (ElasticsearchQueryString)q;
                String searchTypeQueryString = this.queryStringDecorators.decorate(searchTypeBackendQuery.queryString(), job, query, results);
                QueryBuilder normalizedSearchTypeQuery = this.normalizeQueryString(searchTypeQueryString);
                searchTypeOverrides.must(normalizedSearchTypeQuery);
            });
            searchTypeSourceBuilder.query(searchTypeOverrides);
            String type = searchType.type();
            Provider<ESSearchTypeHandler<? extends SearchType>> searchTypeHandler = this.elasticsearchSearchTypeHandlers.get(type);
            if (searchTypeHandler == null) {
                LOG.error("Unknown search type {} for elasticsearch backend, cannot generate query part. Skipping this search type.", (Object)type);
                queryContext.addError((SearchError)new SearchTypeError(query, searchType.id(), "Unknown search type '" + type + "' for elasticsearch backend, cannot generate query"));
                continue;
            }
            ((ESSearchTypeHandler)searchTypeHandler.get()).generateQueryPart(job, query, searchType, queryContext);
        }
        return queryContext;
    }

    public Optional<QueryBuilder> generateFilterClause(Filter filter, SearchJob job, Query query, Set<QueryResult> results) {
        if (filter == null) {
            return Optional.empty();
        }
        switch (filter.type()) {
            case "and": {
                BoolQueryBuilder andBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(andBuilder::must));
                return Optional.of(andBuilder);
            }
            case "or": {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(orBuilder::should));
                return Optional.of(orBuilder);
            }
            case "stream": {
                return Optional.empty();
            }
            case "query_string": {
                return Optional.of(QueryBuilders.queryStringQuery(this.queryStringDecorators.decorate(((QueryStringFilter)filter).query(), job, query, results)));
            }
        }
        return Optional.empty();
    }

    public QueryResult doRun(SearchJob job, Query query, ESGeneratedQueryContext queryContext, Set<QueryResult> predecessorResults) {
        if (query.searchTypes().isEmpty()) {
            return QueryResult.builder().query(query).searchTypes(Collections.emptyMap()).errors(new HashSet<SearchError>(queryContext.errors())).build();
        }
        LOG.debug("Running query {} for job {}", (Object)query.id(), (Object)job.getId());
        HashMap resultsMap = Maps.newHashMap();
        Set affectedIndices = this.indexLookup.indexNamesForStreamsInTimeRange(query.usedStreamIds(), query.timerange());
        Map<String, SearchSourceBuilder> searchTypeQueries = queryContext.searchTypeQueries();
        ArrayList<String> searchTypeIds = new ArrayList<String>(searchTypeQueries.keySet());
        List searches = searchTypeIds.stream().map(searchTypeId -> {
            Set<String> affectedIndicesForSearchType = query.searchTypes().stream().filter(s -> s.id().equalsIgnoreCase((String)searchTypeId)).findFirst().flatMap(searchType -> {
                if (searchType.effectiveStreams().isEmpty() && !query.globalOverride().flatMap(GlobalOverride::timerange).isPresent() && !searchType.timerange().isPresent()) {
                    return Optional.empty();
                }
                Set usedStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
                return Optional.of(this.indexLookup.indexNamesForStreamsInTimeRange(usedStreamIds, query.effectiveTimeRange(searchType)));
            }).orElse(affectedIndices);
            return ((Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(((SearchSourceBuilder)searchTypeQueries.get(searchTypeId)).toString()).addType("message")).addIndex(affectedIndicesForSearchType.isEmpty() ? Collections.singleton("") : affectedIndicesForSearchType)).allowNoIndices(false)).ignoreUnavailable(false)).build();
        }).collect(Collectors.toList());
        MultiSearch.Builder multiSearchBuilder = new MultiSearch.Builder(searches);
        MultiSearchResult result = JestUtils.execute(this.jestClient, multiSearchBuilder.build(), () -> "Unable to perform search query: ");
        for (SearchType searchType : query.searchTypes()) {
            ElasticsearchException e;
            String searchTypeId2 = searchType.id();
            Provider<ESSearchTypeHandler<? extends SearchType>> handlerProvider = this.elasticsearchSearchTypeHandlers.get(searchType.type());
            if (handlerProvider == null) {
                LOG.error("Unknown search type '{}', cannot convert query result.", (Object)searchType.type());
                continue;
            }
            ESSearchTypeHandler handler = (ESSearchTypeHandler)handlerProvider.get();
            int searchTypeIndex = searchTypeIds.indexOf(searchTypeId2);
            MultiSearchResult.MultiSearchResponse multiSearchResponse = result.getResponses().get(searchTypeIndex);
            if (multiSearchResponse.isError) {
                e = JestUtils.specificException(() -> "Search type returned error: ", multiSearchResponse.error);
                queryContext.addError((SearchError)SearchTypeErrorParser.parse((Query)query, (String)searchTypeId2, (ElasticsearchException)e));
                continue;
            }
            if (JestUtils.checkForFailedShards(multiSearchResponse.searchResult).isPresent()) {
                e = JestUtils.checkForFailedShards(multiSearchResponse.searchResult).get();
                queryContext.addError((SearchError)SearchTypeErrorParser.parse((Query)query, (String)searchTypeId2, (ElasticsearchException)e));
                continue;
            }
            SearchType.Result searchTypeResult = handler.extractResult(job, query, searchType, multiSearchResponse.searchResult, queryContext);
            if (searchTypeResult == null) continue;
            resultsMap.put(searchTypeId2, searchTypeResult);
        }
        LOG.debug("Query {} ran for job {}", (Object)query.id(), (Object)job.getId());
        return QueryResult.builder().query(query).searchTypes((Map)resultsMap).errors(new HashSet<SearchError>(queryContext.errors())).build();
    }
}

