/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.searchtypes.pivot.series;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.PercentilesAggregation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Percentile;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.graylog.storage.elasticsearch6.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivotSeriesSpecHandler;

public class ESPercentilesHandler
extends ESPivotSeriesSpecHandler<Percentile, PercentilesAggregation> {
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Percentile percentileSpec, ESPivot searchTypeHandler, ESGeneratedQueryContext queryContext) {
        PercentilesAggregationBuilder percentiles = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles(name).field(percentileSpec.field())).percentiles(percentileSpec.percentile());
        this.record(queryContext, pivot, (PivotSpec)percentileSpec, name, PercentilesAggregation.class);
        return Optional.of(percentiles);
    }

    @Override
    public Stream<ESPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Percentile pivotSpec, SearchResult searchResult, PercentilesAggregation percentilesAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext queryContext) {
        Double percentile = percentilesAggregation.getPercentiles().getOrDefault(pivotSpec.percentile().toString(), null);
        return Stream.of(ESPivotSeriesSpecHandler.Value.create(pivotSpec.id(), "percentile", percentile));
    }
}

