/*
 * Decompiled with CFR 0.152.
 */
package net.davidashen.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import net.davidashen.util.ErrorHandler;
import net.davidashen.util.Hashtable;
import net.davidashen.util.List;

public class Hyphenator {
    private Hashtable exceptions;
    private List[] entrytab;
    private ErrorHandler eh = ErrorHandler.DEFAULT;

    public void setErrorHandler(ErrorHandler eh) {
        this.eh = eh;
    }

    public void loadTable(InputStream in) throws IOException {
        int[] codelist = new int[256];
        int i = 0;
        while (i != 256) {
            codelist[i] = i;
            ++i;
        }
        this.loadTable(in, codelist);
    }

    public void loadTable(InputStream in, int[] codelist) throws IOException {
        this.exceptions = new Hashtable();
        this.entrytab = new List[256];
        int i = 0;
        while (i != 256) {
            this.entrytab[i] = new List();
            ++i;
        }
        Scanner s = new Scanner(in, codelist, this.eh);
        boolean EXCEPTIONS = true;
        int PATTERNS = 2;
        boolean NONE = false;
        int state = 0;
        block11: while (true) {
            short sym = s.getSym();
            switch (sym) {
                case 0: {
                    break block11;
                }
                case 3: 
                case 4: {
                    if (s.getSym() != 1) {
                        s.error("'{' expected");
                    }
                    state = sym == 3 ? 2 : 1;
                    continue block11;
                }
                case 2: {
                    state = 0;
                    continue block11;
                }
                case 5: {
                    switch (state) {
                        case 2: {
                            this.readPattern(s);
                            break;
                        }
                        case 1: {
                            this.readException(s);
                            break;
                        }
                    }
                    continue block11;
                }
                default: {
                    s.error("problem parsing input");
                    continue block11;
                }
            }
            break;
        }
    }

    public String hyphenate(String phrase) {
        return this.hyphenate(phrase, 1, 1);
    }

    public String hyphenate(String phrase, int remain_count, int push_count) {
        if (remain_count < 1) {
            remain_count = 1;
        }
        if (push_count < 1) {
            push_count = 1;
        }
        if (phrase.length() >= push_count + remain_count) {
            int jch = Integer.MIN_VALUE;
            int ich = 0;
            int ihy = 0;
            char[] chars = new char[phrase.length() + 1];
            char[] hychars = new char[chars.length * 2 - 1];
            chars[chars.length - 1] = '\u0000';
            phrase.getChars(0, phrase.length(), chars, 0);
            boolean inword = false;
            while (true) {
                if (inword) {
                    int i;
                    int i2;
                    if (Character.isLetter(chars[ich])) {
                        ++ich;
                        continue;
                    }
                    int length = ich - jch;
                    String word = new String(chars, jch, length).toLowerCase();
                    int[] values = (int[])this.exceptions.get(word);
                    if (values == null) {
                        char[] echars = new char[length + 2];
                        values = new int[echars.length + 1];
                        echars[echars.length - 1] = 46;
                        echars[0] = 46;
                        i2 = 0;
                        while (i2 != length) {
                            echars[1 + i2] = Character.toLowerCase(chars[jch + i2]);
                            ++i2;
                        }
                        int istart = 0;
                        while (istart != length) {
                            int iet = echars[istart] % 256;
                            List entry = this.entrytab[iet];
                            int i3 = istart;
                            Enumeration eentry = entry.elements();
                            while (eentry.hasMoreElements()) {
                                entry = (List)eentry.nextElement();
                                if (((Character)entry.car()).charValue() != echars[i3]) continue;
                                entry = entry.cdr();
                                int[] nodevalues = (int[])entry.car();
                                int inv = 0;
                                while (inv != nodevalues.length) {
                                    if (nodevalues[inv] > values[istart + inv]) {
                                        values[istart + inv] = nodevalues[inv];
                                    }
                                    ++inv;
                                }
                                if (++i3 == echars.length) break;
                                eentry = entry.cdr().elements();
                            }
                            ++istart;
                        }
                        int[] newvalues = new int[length];
                        System.arraycopy(values, 2, newvalues, 0, length);
                        values = newvalues;
                    }
                    if (remain_count + push_count <= length) {
                        i = 0;
                        while (i != remain_count - 1) {
                            hychars[ihy++] = chars[jch++];
                            ++i;
                        }
                        i2 = remain_count - 1;
                        while (i2 != length - push_count) {
                            hychars[ihy++] = chars[jch++];
                            if (values[i2] % 2 == 1) {
                                hychars[ihy++] = 173;
                            }
                            ++i2;
                        }
                        int i4 = length - push_count;
                        while (i4 != length) {
                            hychars[ihy++] = chars[jch++];
                            ++i4;
                        }
                    } else {
                        i = 0;
                        while (i != length) {
                            hychars[ihy++] = chars[jch++];
                            ++i;
                        }
                    }
                    inword = false;
                    continue;
                }
                if (Character.isLetter(chars[ich])) {
                    jch = ich;
                    inword = true;
                } else {
                    if (chars[ich] == '\u0000') break;
                    hychars[ihy++] = chars[ich];
                    if (chars[ich] == '-' || chars[ich] == '\u2010') {
                        hychars[ihy++] = 8203;
                    }
                }
                ++ich;
            }
            return new String(hychars, 0, ihy);
        }
        return phrase;
    }

    void readPattern(Scanner s) {
        int inv;
        int[] nodevalues;
        List entry;
        block6: {
            entry = null;
            List level = this.entrytab[s.pattern[Character.isDigit(s.pattern[0]) ? 1 : 0] % 256];
            nodevalues = new int[s.patlen + 1];
            int ich = 0;
            inv = 0;
            Enumeration eentry = level.elements();
            block0: do {
                if (Character.isDigit(s.pattern[ich])) {
                    nodevalues[inv++] = s.pattern[ich++] - 48;
                    if (ich == s.patlen) {
                        break block6;
                    }
                } else {
                    nodevalues[inv++] = 0;
                }
                do {
                    if (eentry.hasMoreElements()) continue;
                    int[] newnodevalues = new int[inv + 1];
                    int jnv = 0;
                    while (jnv != newnodevalues.length) {
                        newnodevalues[jnv] = 0;
                        ++jnv;
                    }
                    entry = new List().snoc(new Character(s.pattern[ich])).snoc(newnodevalues);
                    level.snoc(entry);
                    level = entry;
                    eentry = level.elements();
                    eentry.nextElement();
                    eentry.nextElement();
                    continue block0;
                } while (((Character)(entry = (List)eentry.nextElement()).car()).charValue() != s.pattern[ich]);
                level = entry;
                eentry = level.elements();
                eentry.nextElement();
                eentry.nextElement();
            } while (++ich != s.patlen);
            nodevalues[inv++] = 0;
        }
        System.arraycopy(nodevalues, 0, (int[])entry.cdr().car(), 0, inv);
    }

    void readException(Scanner s) {
        int i0 = 0;
        int in = s.patlen;
        while (true) {
            if (in == i0) {
                return;
            }
            if (s.pattern[i0] == '-') {
                ++i0;
                continue;
            }
            if (s.pattern[in - 1] != '-') break;
            --in;
        }
        int[] values = new int[in - i0];
        int jch = 0;
        int ich = i0;
        while (ich != in) {
            if (s.pattern[ich] == '-') {
                values[jch - 1] = 1;
            } else {
                s.pattern[jch] = s.pattern[ich];
                values[jch] = 0;
                ++jch;
            }
            ++ich;
        }
        this.exceptions.put(new String(s.pattern, 0, jch), values);
    }

    public static void main(String[] args) {
        Hyphenator hyphenator = new Hyphenator();
        hyphenator.setErrorHandler(new ErrorHandler(){

            public void debug(String guard, String s) {
            }

            public void info(String s) {
                System.err.println(s);
            }

            public void warning(String s) {
                System.err.println("WARNING: " + s);
            }

            public void error(String s) {
                System.err.println("ERROR: " + s);
            }

            public void exception(String s, Exception e) {
                System.err.println("ERROR: " + s);
                e.printStackTrace();
            }

            public boolean isDebugged(String guard) {
                return false;
            }
        });
        if (args.length != 2 && args.length != 3) {
            System.err.println("call: java net.davidashen.text.Hyphenator word table.tex [codes.txt]");
            System.exit(1);
        }
        BufferedInputStream table = null;
        try {
            table = new BufferedInputStream(new FileInputStream(args[1]));
        }
        catch (IOException e) {
            System.err.println("cannot open hyphenation table " + args[1] + ": " + e.toString());
            System.exit(1);
        }
        int[] codelist = new int[256];
        int i = 0;
        while (i != 256) {
            codelist[i] = i;
            ++i;
        }
        if (args.length == 3) {
            BufferedReader codes = null;
            try {
                codes = new BufferedReader(new FileReader(args[2]));
            }
            catch (IOException e) {
                System.err.println("cannot open code list" + args[2] + ": " + e.toString());
                System.exit(1);
            }
            try {
                String line;
                while ((line = codes.readLine()) != null) {
                    int key;
                    String token;
                    StringTokenizer tokenizer = new StringTokenizer((String)e);
                    if (!tokenizer.hasMoreTokens() || (token = tokenizer.nextToken()).startsWith("%")) continue;
                    int value = key = Integer.decode(token).intValue();
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        value = Integer.decode(token);
                    }
                    codelist[key] = value;
                }
                codes.close();
            }
            catch (IOException e) {
                System.err.println("error reading code list: " + e.toString());
                System.exit(1);
            }
        }
        try {
            hyphenator.loadTable(table, codelist);
            ((InputStream)table).close();
        }
        catch (IOException e) {
            System.err.println("error loading hyphenation table: " + e.toString());
            System.exit(1);
        }
        System.out.println(args[0] + " -> " + hyphenator.hyphenate(args[0]));
    }

    private static class Scanner {
        static final short EOF = 0;
        static final short LBRAC = 1;
        static final short RBRAC = 2;
        static final short PATTERNS = 3;
        static final short EXCEPTIONS = 4;
        static final short PATTERN = 5;
        char[] pattern = new char[0];
        int patlen;
        private InputStream in;
        private int[] codelist;
        private ErrorHandler eh;
        private int cc = 10;
        private int cc1 = -1;
        private int prevlno = -1;
        private int lno = 0;
        private int cno = 0;
        private static final Hashtable acctab = new Hashtable();

        private static final int cp2i(int c0, int c1) {
            return (c0 << 8) + c1;
        }

        Scanner(InputStream in, int[] codelist, ErrorHandler eh) throws IOException {
            this.codelist = codelist;
            this.in = in;
            this.eh = eh;
            this.read();
        }

        short getSym() {
            block7: while (true) {
                if (this.isSpace()) {
                    this.read();
                    continue;
                }
                switch (this.cc) {
                    case 37: {
                        do {
                            this.read();
                        } while (!this.isNL() && this.cc != -1);
                        continue block7;
                    }
                    case 92: {
                        this.read();
                        if (this.isLetter()) {
                            this.patlen = 0;
                            do {
                                this.cc2pat();
                            } while (this.isLetter());
                            String kwd = new String(this.pattern, 0, this.patlen);
                            if (kwd.equals("patterns")) {
                                return 3;
                            }
                            if (kwd.equals("hyphenation")) {
                                return 4;
                            }
                            if (kwd.equals("endinput")) {
                                return 0;
                            }
                            this.warning("shamelessly skipping \\" + kwd);
                            continue block7;
                        }
                    }
                    case 123: {
                        this.read();
                        return 1;
                    }
                    case 125: {
                        this.read();
                        return 2;
                    }
                    case -1: {
                        return 0;
                    }
                }
                if (this.isPatChar()) {
                    this.patlen = 0;
                    do {
                        this.cc2pat();
                    } while (this.isPatChar());
                    if (this.patlen <= 1) continue;
                    return 5;
                }
                this.read();
            }
        }

        private void read() {
            if (this.cc != -1) {
                if (this.isNL()) {
                    ++this.lno;
                    this.cno = 0;
                }
                try {
                    if (this.cc1 != -1) {
                        this.cc = this.cc1;
                        this.cc1 = -1;
                    } else {
                        this.cc = this.in.read();
                    }
                    block1 : switch (this.cc) {
                        case 94: {
                            this.cc1 = this.in.read();
                            if (this.cc1 == 94) {
                                this.cc1 = -1;
                                int cc2 = this.in.read();
                                this.cc = this.hexval(cc2);
                                if (this.cc == -1) {
                                    this.cc = cc2 + 64 & 0x7F;
                                } else {
                                    this.cc1 = this.in.read();
                                    cc2 = this.hexval(this.cc1);
                                    if (cc2 != -1) {
                                        this.cc1 = -1;
                                        this.cc *= 16;
                                        this.cc += cc2;
                                    }
                                }
                            }
                            this.cc = this.codelist[this.cc];
                            break;
                        }
                        case 92: {
                            this.cc1 = this.in.read();
                            switch (this.cc1) {
                                case 34: 
                                case 39: 
                                case 46: 
                                case 61: 
                                case 72: 
                                case 94: 
                                case 96: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 105: 
                                case 107: 
                                case 108: 
                                case 111: 
                                case 114: 
                                case 115: 
                                case 117: 
                                case 118: 
                                case 126: {
                                    Object chrval;
                                    int key = this.cc1 << 8;
                                    int sep = -1;
                                    int cc0 = this.in.read();
                                    if (cc0 == 32 && this.cc1 != 108 && this.cc1 != 111 && this.cc1 != 105 || cc0 == 123 || cc0 == 92) {
                                        sep = cc0;
                                        cc0 = this.in.read();
                                        if (sep == 123 && cc0 == 125) {
                                            sep = -1;
                                        }
                                        cc0 = 32;
                                    }
                                    this.cc1 = -1;
                                    key += cc0;
                                    if (sep == 123) {
                                        this.in.read();
                                    }
                                    this.cc = (chrval = acctab.get(new Integer(key))) != null ? (Integer)chrval : cc0;
                                    break block1;
                                }
                            }
                            break;
                        }
                        default: {
                            if (this.cc != -1) {
                                this.cc = this.codelist[this.cc];
                            }
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    this.error(e.toString());
                    this.cc = -1;
                }
                ++this.cno;
            }
        }

        private int hexval(int cc) {
            switch (cc) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return cc - 48;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return cc - 97 + 10;
                }
            }
            return -1;
        }

        private void cc2pat() {
            if (this.patlen == this.pattern.length) {
                char[] newpattern = new char[this.patlen * 2 + 1];
                System.arraycopy(this.pattern, 0, newpattern, 0, this.patlen);
                this.pattern = newpattern;
            }
            this.pattern[this.patlen++] = Character.toLowerCase((char)this.cc);
            this.read();
        }

        private boolean isLetter() {
            if (this.cc == -1) {
                return false;
            }
            return Character.isLetter((char)this.cc);
        }

        private boolean isSpace() {
            if (this.cc == -1) {
                return false;
            }
            return Character.isSpaceChar((char)this.cc) || this.isNL();
        }

        private boolean isNL() {
            if (this.cc == 10) {
                return true;
            }
            if (this.cc == 13) {
                if (this.cc1 == -1) {
                    try {
                        this.cc = this.in.read();
                    }
                    catch (IOException e) {
                        this.error(e.toString());
                        this.cc = -1;
                    }
                } else {
                    this.cc = this.cc1;
                    this.cc1 = -1;
                }
                if (this.cc != 10) {
                    this.cc1 = this.cc;
                }
                return true;
            }
            return false;
        }

        private boolean isPatChar() {
            if (this.cc == -1) {
                return false;
            }
            char cc = (char)this.cc;
            return Character.isLetterOrDigit(cc) || cc == '.' || cc == '-';
        }

        private void error(String msg) {
            if (this.prevlno != this.lno) {
                this.prevlno = this.lno;
                this.eh.error("(" + this.lno + "," + this.cno + "): " + msg);
            }
        }

        private void warning(String msg) {
            if (this.prevlno != this.lno) {
                this.prevlno = this.lno;
                this.eh.warning("(" + this.lno + "," + this.cno + "): " + msg);
            }
        }

        static {
            acctab.put(new Integer(Scanner.cp2i(96, 97)), new Integer(224));
            acctab.put(new Integer(Scanner.cp2i(96, 101)), new Integer(232));
            acctab.put(new Integer(Scanner.cp2i(96, 105)), new Integer(236));
            acctab.put(new Integer(Scanner.cp2i(96, 111)), new Integer(242));
            acctab.put(new Integer(Scanner.cp2i(96, 117)), new Integer(249));
            acctab.put(new Integer(Scanner.cp2i(96, 119)), new Integer(7809));
            acctab.put(new Integer(Scanner.cp2i(96, 121)), new Integer(7923));
            acctab.put(new Integer(Scanner.cp2i(39, 97)), new Integer(225));
            acctab.put(new Integer(Scanner.cp2i(39, 99)), new Integer(263));
            acctab.put(new Integer(Scanner.cp2i(39, 101)), new Integer(233));
            acctab.put(new Integer(Scanner.cp2i(39, 103)), new Integer(501));
            acctab.put(new Integer(Scanner.cp2i(39, 105)), new Integer(237));
            acctab.put(new Integer(Scanner.cp2i(39, 107)), new Integer(7729));
            acctab.put(new Integer(Scanner.cp2i(39, 108)), new Integer(314));
            acctab.put(new Integer(Scanner.cp2i(39, 109)), new Integer(7743));
            acctab.put(new Integer(Scanner.cp2i(39, 110)), new Integer(324));
            acctab.put(new Integer(Scanner.cp2i(39, 111)), new Integer(243));
            acctab.put(new Integer(Scanner.cp2i(39, 112)), new Integer(7765));
            acctab.put(new Integer(Scanner.cp2i(39, 114)), new Integer(341));
            acctab.put(new Integer(Scanner.cp2i(39, 115)), new Integer(347));
            acctab.put(new Integer(Scanner.cp2i(39, 117)), new Integer(250));
            acctab.put(new Integer(Scanner.cp2i(39, 119)), new Integer(7811));
            acctab.put(new Integer(Scanner.cp2i(39, 121)), new Integer(253));
            acctab.put(new Integer(Scanner.cp2i(39, 122)), new Integer(378));
            acctab.put(new Integer(Scanner.cp2i(94, 97)), new Integer(226));
            acctab.put(new Integer(Scanner.cp2i(94, 99)), new Integer(265));
            acctab.put(new Integer(Scanner.cp2i(94, 101)), new Integer(234));
            acctab.put(new Integer(Scanner.cp2i(94, 103)), new Integer(285));
            acctab.put(new Integer(Scanner.cp2i(94, 104)), new Integer(293));
            acctab.put(new Integer(Scanner.cp2i(94, 105)), new Integer(238));
            acctab.put(new Integer(Scanner.cp2i(94, 106)), new Integer(309));
            acctab.put(new Integer(Scanner.cp2i(94, 111)), new Integer(244));
            acctab.put(new Integer(Scanner.cp2i(94, 115)), new Integer(349));
            acctab.put(new Integer(Scanner.cp2i(94, 117)), new Integer(251));
            acctab.put(new Integer(Scanner.cp2i(94, 119)), new Integer(373));
            acctab.put(new Integer(Scanner.cp2i(94, 121)), new Integer(375));
            acctab.put(new Integer(Scanner.cp2i(94, 122)), new Integer(7825));
            acctab.put(new Integer(Scanner.cp2i(34, 97)), new Integer(228));
            acctab.put(new Integer(Scanner.cp2i(34, 101)), new Integer(235));
            acctab.put(new Integer(Scanner.cp2i(34, 104)), new Integer(7719));
            acctab.put(new Integer(Scanner.cp2i(34, 105)), new Integer(239));
            acctab.put(new Integer(Scanner.cp2i(34, 111)), new Integer(246));
            acctab.put(new Integer(Scanner.cp2i(34, 116)), new Integer(7831));
            acctab.put(new Integer(Scanner.cp2i(34, 117)), new Integer(252));
            acctab.put(new Integer(Scanner.cp2i(34, 119)), new Integer(7813));
            acctab.put(new Integer(Scanner.cp2i(34, 120)), new Integer(7821));
            acctab.put(new Integer(Scanner.cp2i(34, 121)), new Integer(255));
            acctab.put(new Integer(Scanner.cp2i(72, 111)), new Integer(337));
            acctab.put(new Integer(Scanner.cp2i(72, 117)), new Integer(369));
            acctab.put(new Integer(Scanner.cp2i(126, 97)), new Integer(227));
            acctab.put(new Integer(Scanner.cp2i(126, 101)), new Integer(7869));
            acctab.put(new Integer(Scanner.cp2i(126, 105)), new Integer(297));
            acctab.put(new Integer(Scanner.cp2i(126, 110)), new Integer(241));
            acctab.put(new Integer(Scanner.cp2i(126, 111)), new Integer(245));
            acctab.put(new Integer(Scanner.cp2i(126, 117)), new Integer(361));
            acctab.put(new Integer(Scanner.cp2i(126, 118)), new Integer(7805));
            acctab.put(new Integer(Scanner.cp2i(126, 121)), new Integer(7929));
            acctab.put(new Integer(Scanner.cp2i(117, 97)), new Integer(259));
            acctab.put(new Integer(Scanner.cp2i(117, 101)), new Integer(277));
            acctab.put(new Integer(Scanner.cp2i(117, 103)), new Integer(287));
            acctab.put(new Integer(Scanner.cp2i(117, 105)), new Integer(301));
            acctab.put(new Integer(Scanner.cp2i(117, 111)), new Integer(335));
            acctab.put(new Integer(Scanner.cp2i(117, 117)), new Integer(365));
            acctab.put(new Integer(Scanner.cp2i(118, 97)), new Integer(462));
            acctab.put(new Integer(Scanner.cp2i(118, 32)), new Integer(711));
            acctab.put(new Integer(Scanner.cp2i(118, 99)), new Integer(269));
            acctab.put(new Integer(Scanner.cp2i(118, 100)), new Integer(271));
            acctab.put(new Integer(Scanner.cp2i(118, 101)), new Integer(283));
            acctab.put(new Integer(Scanner.cp2i(118, 103)), new Integer(487));
            acctab.put(new Integer(Scanner.cp2i(118, 105)), new Integer(464));
            acctab.put(new Integer(Scanner.cp2i(118, 106)), new Integer(496));
            acctab.put(new Integer(Scanner.cp2i(118, 107)), new Integer(489));
            acctab.put(new Integer(Scanner.cp2i(118, 108)), new Integer(318));
            acctab.put(new Integer(Scanner.cp2i(118, 110)), new Integer(328));
            acctab.put(new Integer(Scanner.cp2i(118, 111)), new Integer(466));
            acctab.put(new Integer(Scanner.cp2i(118, 114)), new Integer(345));
            acctab.put(new Integer(Scanner.cp2i(118, 115)), new Integer(353));
            acctab.put(new Integer(Scanner.cp2i(118, 116)), new Integer(357));
            acctab.put(new Integer(Scanner.cp2i(118, 117)), new Integer(468));
            acctab.put(new Integer(Scanner.cp2i(118, 122)), new Integer(382));
            acctab.put(new Integer(Scanner.cp2i(99, 99)), new Integer(231));
            acctab.put(new Integer(Scanner.cp2i(99, 100)), new Integer(7697));
            acctab.put(new Integer(Scanner.cp2i(99, 103)), new Integer(291));
            acctab.put(new Integer(Scanner.cp2i(99, 104)), new Integer(7721));
            acctab.put(new Integer(Scanner.cp2i(99, 107)), new Integer(311));
            acctab.put(new Integer(Scanner.cp2i(99, 108)), new Integer(316));
            acctab.put(new Integer(Scanner.cp2i(99, 110)), new Integer(326));
            acctab.put(new Integer(Scanner.cp2i(99, 114)), new Integer(343));
            acctab.put(new Integer(Scanner.cp2i(99, 115)), new Integer(351));
            acctab.put(new Integer(Scanner.cp2i(99, 116)), new Integer(355));
            acctab.put(new Integer(Scanner.cp2i(100, 97)), new Integer(7841));
            acctab.put(new Integer(Scanner.cp2i(100, 98)), new Integer(7685));
            acctab.put(new Integer(Scanner.cp2i(100, 100)), new Integer(7693));
            acctab.put(new Integer(Scanner.cp2i(100, 101)), new Integer(7865));
            acctab.put(new Integer(Scanner.cp2i(100, 104)), new Integer(7717));
            acctab.put(new Integer(Scanner.cp2i(100, 105)), new Integer(7883));
            acctab.put(new Integer(Scanner.cp2i(100, 107)), new Integer(7731));
            acctab.put(new Integer(Scanner.cp2i(100, 108)), new Integer(7735));
            acctab.put(new Integer(Scanner.cp2i(100, 109)), new Integer(7747));
            acctab.put(new Integer(Scanner.cp2i(100, 110)), new Integer(7751));
            acctab.put(new Integer(Scanner.cp2i(100, 111)), new Integer(7885));
            acctab.put(new Integer(Scanner.cp2i(100, 114)), new Integer(7771));
            acctab.put(new Integer(Scanner.cp2i(100, 115)), new Integer(7779));
            acctab.put(new Integer(Scanner.cp2i(100, 116)), new Integer(7789));
            acctab.put(new Integer(Scanner.cp2i(100, 117)), new Integer(7909));
            acctab.put(new Integer(Scanner.cp2i(100, 118)), new Integer(7807));
            acctab.put(new Integer(Scanner.cp2i(100, 119)), new Integer(7817));
            acctab.put(new Integer(Scanner.cp2i(100, 121)), new Integer(7925));
            acctab.put(new Integer(Scanner.cp2i(100, 122)), new Integer(7827));
            acctab.put(new Integer(Scanner.cp2i(46, 99)), new Integer(267));
            acctab.put(new Integer(Scanner.cp2i(46, 101)), new Integer(279));
            acctab.put(new Integer(Scanner.cp2i(46, 103)), new Integer(289));
            acctab.put(new Integer(Scanner.cp2i(46, 108)), new Integer(320));
            acctab.put(new Integer(Scanner.cp2i(46, 122)), new Integer(380));
            acctab.put(new Integer(Scanner.cp2i(114, 97)), new Integer(229));
            acctab.put(new Integer(Scanner.cp2i(114, 117)), new Integer(367));
            acctab.put(new Integer(Scanner.cp2i(114, 119)), new Integer(7832));
            acctab.put(new Integer(Scanner.cp2i(114, 121)), new Integer(7833));
            acctab.put(new Integer(Scanner.cp2i(107, 97)), new Integer(261));
            acctab.put(new Integer(Scanner.cp2i(107, 101)), new Integer(281));
            acctab.put(new Integer(Scanner.cp2i(107, 105)), new Integer(303));
            acctab.put(new Integer(Scanner.cp2i(107, 111)), new Integer(491));
            acctab.put(new Integer(Scanner.cp2i(107, 117)), new Integer(371));
            acctab.put(new Integer(Scanner.cp2i(97, 97)), new Integer(229));
            acctab.put(new Integer(Scanner.cp2i(97, 101)), new Integer(230));
            acctab.put(new Integer(Scanner.cp2i(105, 32)), new Integer(305));
            acctab.put(new Integer(Scanner.cp2i(108, 32)), new Integer(322));
            acctab.put(new Integer(Scanner.cp2i(111, 32)), new Integer(248));
            acctab.put(new Integer(Scanner.cp2i(111, 101)), new Integer(339));
            acctab.put(new Integer(Scanner.cp2i(115, 115)), new Integer(223));
        }
    }
}

