/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.Version;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.core.plugin.DefaultSettings;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.protocolhandler.ProtocolHandler;
import tvbrowser.core.settings.DeferredFontProperty;
import tvbrowser.core.settings.JGoodiesThemeProperty;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ChannelPanel;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableScrollPane;
import tvbrowser.ui.settings.BlockedPluginArrayProperty;
import tvbrowser.ui.waiting.dlgs.CopyWaitingDlg;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.io.stream.InputStreamProcessor;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.misc.OperatingSystem;
import util.misc.TextLineBreakerStringWidth;
import util.settings.BooleanProperty;
import util.settings.ByteProperty;
import util.settings.ChannelArrayProperty;
import util.settings.ChoiceProperty;
import util.settings.ColorProperty;
import util.settings.ContextMenuMouseActionArrayProperty;
import util.settings.ContextMenuMouseActionSetting;
import util.settings.DateProperty;
import util.settings.EncodedStringProperty;
import util.settings.FontProperty;
import util.settings.HiddenMessagesProperty;
import util.settings.IntArrayProperty;
import util.settings.IntProperty;
import util.settings.MinutesProperty;
import util.settings.ProgramFieldTypeArrayProperty;
import util.settings.Property;
import util.settings.PropertyManager;
import util.settings.ShortProperty;
import util.settings.StringArrayProperty;
import util.settings.StringMapProperty;
import util.settings.StringProperty;
import util.settings.VariableIntProperty;
import util.settings.VersionProperty;
import util.settings.WindowSetting;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.view.SplitViewProperty;

public class Settings {
    public static final String INFO_ID = "info.id";
    public static final String PICTURE_ID = "picture.id";
    private static final short INFO_DIALOG_WAITING_TIME = 1500;
    private static final HashMap<String, Boolean> RESTART_MAP = new HashMap();
    private static final ArrayList<ChangeListener> RESTART_LISTENERS = new ArrayList();
    private static final Logger mLog = Logger.getLogger(Settings.class.getName());
    private static DefaultSettings mDefaultSettings = new DefaultSettings();
    private static final long PROXY_PASSWORD_SEED = 6528587292713416704L;
    private static final String SETTINGS_FILE = "settings.prop";
    private static final String DEFAULT_USER_DIR = ".tvbrowser";
    private static final String WINDOW_SETTINGS_FILE = "window.settings.dat";
    private static String DEFAULT_FONT_NAME = "Dialog";
    private static Font DEFAULT_PROGRAMTITLEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static Font DEFAULT_PROGRAMINFOFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 0, -1);
    private static final Font DEFAULT_CHANNELNAMEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static Font DEFAULT_PROGRAMTIMEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static PropertyManager PROP = new PropertyManager();
    private static boolean mShowWaiting;
    private static boolean mShowSettingsCopyWaiting;
    private static HashMap<String, WindowSetting> mWindowSettings;
    private static boolean mCopyToSystem;
    private static ArrayList<ChangeListener> mListListenerFontChange;
    private static Color[] mHighlightingColors;
    @Deprecated(since="4.2.2")
    public static final ColorProperty propProgramPanelMarkedMinPriorityColor;
    @Deprecated(since="4.2.2")
    public static final ColorProperty propProgramPanelMarkedLowerMediumPriorityColor;
    @Deprecated(since="4.2.2")
    public static final ColorProperty propProgramPanelMarkedMediumPriorityColor;
    @Deprecated(since="4.2.2")
    public static final ColorProperty propProgramPanelMarkedHigherMediumPriorityColor;
    @Deprecated(since="4.2.2")
    public static final ColorProperty propProgramPanelMarkedMaxPriorityColor;

    public static void addRestartInfoListener(ChangeListener cl) {
        RESTART_LISTENERS.add(cl);
    }

    public static void removeRestartInfoListener(ChangeListener cl) {
        RESTART_LISTENERS.remove(cl);
    }

    public static void setRestartInfo(String source, boolean needsRestart) {
        if (needsRestart) {
            RESTART_MAP.put(source, true);
        } else {
            RESTART_MAP.remove(source);
        }
        for (ChangeListener cl : RESTART_LISTENERS) {
            cl.stateChanged(new ChangeEvent(source));
        }
    }

    public static boolean isRestartNeeded() {
        return !RESTART_MAP.isEmpty();
    }

    public static void addFontChangeListener(ChangeListener listener) {
        if (!mListListenerFontChange.contains(listener)) {
            mListListenerFontChange.add(listener);
        }
    }

    public static void removeFontChangeListener(ChangeListener listener) {
        mListListenerFontChange.remove(listener);
    }

    public static DefaultSettings getDefaultSettings() {
        return mDefaultSettings;
    }

    public static void copyToSystem() {
        final File currentSettingsDir = new File(Settings.getUserSettingsDirName());
        final File currentTvDataDir = new File(Settings.getDefaultTvDataDir());
        mCopyToSystem = MainFrame.getInstance().getUserRequestCopyToSystem();
        if (mCopyToSystem) {
            Properties prop = new Properties();
            if (OperatingSystem.isMacOs()) {
                prop.setProperty("userdir", "${user.home}/Library/Preferences/TV-Browser");
                prop.setProperty("tvdatadir", "${user.home}/Library/Application Support/TV-Browser/tvdata");
                prop.setProperty("pluginsdir", "${user.home}/Library/Application Support/TV-Browser/plugins");
            } else if (OperatingSystem.isLinux()) {
                prop.setProperty("userdir", "${user.home}/.config/tvbrowser");
                prop.setProperty("tvdatadir", "${user.home}/.config/tvbrowser/tvdata");
            } else if (OperatingSystem.isWindows()) {
                prop.setProperty("userdir", "${user.appdata}/TV-Browser");
                prop.setProperty("tvdatadir", "${user.appdata}/TV-Browser/tvdata");
            }
            mDefaultSettings = new DefaultSettings(prop);
            final File targetSettingsDir = new File(Settings.getUserSettingsDirName());
            final File targetTvDataDir = new File(Settings.getDefaultTvDataDir());
            if (new File(Settings.getUserSettingsDirName(), SETTINGS_FILE).isFile()) {
                Object[] options = new String[]{MainFrame.LOCALIZER.msg("continue", "Continue"), MainFrame.LOCALIZER.msg("stop", "Cancel copying now")};
                String title = MainFrame.LOCALIZER.msg("copyToSystemTitleWarning", "Settings already exists");
                String msg = MainFrame.LOCALIZER.msg("copyToSystemWarningMsg", "Settings already exist in the system settings directory!\nIf you continue the current settings will be overwritten!");
                mCopyToSystem = JOptionPane.showOptionDialog(MainFrame.getInstance(), msg, title, 0, 2, null, options, options[1]) == 0;
            } else if (!targetSettingsDir.isDirectory()) {
                mCopyToSystem = targetSettingsDir.mkdirs();
            }
            if (!targetTvDataDir.isDirectory()) {
                mCopyToSystem = targetTvDataDir.mkdirs();
            }
            if (mCopyToSystem) {
                try {
                    final JFrame f = new JFrame(IOUtilities.getGraphicsConfigurationForFrame());
                    final CopyWaitingDlg waiting = new CopyWaitingDlg((java.awt.Window)f, 4);
                    mLog.info("Copy settings and TV data from TV-Browser transportable to system");
                    mShowWaiting = true;
                    Thread copyDataThread = new Thread("Copy TV data directory"){

                        @Override
                        public void run() {
                            try {
                                IOUtilities.copy(currentSettingsDir.listFiles(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir, String name) {
                                        return !name.equalsIgnoreCase("tvdata") && !name.equals(targetSettingsDir.getName()) && !name.equalsIgnoreCase("backup") && !name.equalsIgnoreCase("lang") && !name.equals(".lock");
                                    }
                                }), targetSettingsDir);
                                1.sleep(5000L);
                                IOUtilities.copy(currentTvDataDir.listFiles(), targetTvDataDir, true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            mShowWaiting = false;
                            waiting.dispose();
                            f.dispose();
                        }
                    };
                    copyDataThread.start();
                    waiting.setVisible(mShowWaiting);
                }
                catch (Exception e) {
                    mCopyToSystem = false;
                }
            }
        }
    }

    public static String getUserDirectoryName() {
        String dir = System.getProperty("user.home") + File.separator + DEFAULT_USER_DIR;
        return TVBrowser.isTransportable() && !mCopyToSystem ? new File("settings").getAbsolutePath() : mDefaultSettings.getProperty("userdir", dir);
    }

    public static String getOSLibraryDirectoryName() {
        if (OperatingSystem.isMacOs()) {
            return "/Library/Application Support/TV-Browser/";
        }
        return "";
    }

    public static String getUserSettingsDirName() {
        String version = TVBrowser.getCurrentVersionString();
        if (version.toLowerCase().indexOf("nightly") != -1) {
            version = StringUtils.substringBefore((String)version, (String)"-");
        }
        return Settings.getUserDirectoryName() + File.separator + version;
    }

    public static void storeSettings(boolean log) throws TvBrowserException {
        File f = new File(Settings.getUserSettingsDirName());
        if (!f.exists()) {
            f.mkdirs();
        }
        File settingsFile = new File(Settings.getUserSettingsDirName(), SETTINGS_FILE);
        File firstSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup1");
        File secondSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup2");
        try {
            if (firstSettingsBackupFile.isFile()) {
                secondSettingsBackupFile.delete();
                firstSettingsBackupFile.renameTo(secondSettingsBackupFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PROP.writeToFile(settingsFile);
            try {
                if (settingsFile.isFile()) {
                    IOUtilities.copy(settingsFile, firstSettingsBackupFile);
                }
            }
            catch (Exception exception) {}
        }
        catch (IOException exc) {
            throw new TvBrowserException(Settings.class, "error.1", "Error when saving settings!\n({0})", (Object)settingsFile.getAbsolutePath(), (Throwable)exc);
        }
        Settings.storeWindowSettings(log);
    }

    private static void storeWindowSettings(boolean log) {
        if (log) {
            mLog.info("Storing window settings");
        }
        File windowSettingsFile = new File(Settings.getUserSettingsDirName(), WINDOW_SETTINGS_FILE);
        StreamUtilities.objectOutputStreamIgnoringExceptions(windowSettingsFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(1);
                out.writeInt(mWindowSettings.size());
                for (String key : mWindowSettings.keySet()) {
                    WindowSetting setting = mWindowSettings.get(key);
                    if (setting == null) continue;
                    out.writeUTF(key);
                    mWindowSettings.get(key).saveSettings(out);
                }
                out.close();
            }
        });
    }

    private static void startImportWaitingDlg() {
        mShowSettingsCopyWaiting = true;
        new Thread("settings import info thread"){

            @Override
            public void run() {
                try {
                    3.sleep(1500L);
                    if (mShowSettingsCopyWaiting) {
                        final CopyWaitingDlg waiting = new CopyWaitingDlg((java.awt.Window)new JFrame(), 3);
                        new Thread("settings import waiting thread"){

                            @Override
                            public void run() {
                                while (mShowSettingsCopyWaiting) {
                                    try {
                                        1.sleep(200L);
                                    }
                                    catch (InterruptedException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                waiting.setVisible(false);
                            }
                        }.start();
                        waiting.setVisible(mShowSettingsCopyWaiting);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void loadSettings() {
        String newDirectoryName;
        block85: {
            Settings.initializeAllSubClasses();
            String oldDirectoryName = System.getProperty("user.home", "") + File.separator + DEFAULT_USER_DIR;
            newDirectoryName = Settings.getUserSettingsDirName();
            File settingsFile = new File(newDirectoryName, SETTINGS_FILE);
            File firstSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup1");
            File secondSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup2");
            if (settingsFile.exists() || firstSettingsBackupFile.exists() || secondSettingsBackupFile.exists()) {
                try {
                    PROP.readFromFile(settingsFile);
                    if ((PROP.getProperty("subscribedchannels") == null || PROP.getProperty("subscribedchannels").trim().length() < 1) && PROP.getProperty("channelsWereConfigured") != null && PROP.getProperty("channelsWereConfigured").equals("true") && (firstSettingsBackupFile.isFile() || secondSettingsBackupFile.isFile())) {
                        throw new IOException();
                    }
                    mLog.info("Using settings from file " + settingsFile.getAbsolutePath());
                }
                catch (IOException evt) {
                    if (firstSettingsBackupFile.isFile() || secondSettingsBackupFile.isFile()) {
                        boolean loadSecondBackup;
                        Localizer localizer = Localizer.getLocalizerFor(Settings.class);
                        if (UiUtilities.showConfirmDialogOnMouseScreen(localizer.msg("settingBroken", "Settings file broken.\nWould you like to load the backup file?\n\n(If you select No, the\ndefault settings are used)"), Localizer.getLocalization("i18n_error"), 0, 3) != 0) break block85;
                        boolean bl = loadSecondBackup = !firstSettingsBackupFile.isFile();
                        if (firstSettingsBackupFile.isFile()) {
                            try {
                                PROP.readFromFile(firstSettingsBackupFile);
                                if ((PROP.getProperty("subscribedchannels") == null || PROP.getProperty("subscribedchannels").trim().length() < 1) && secondSettingsBackupFile.isFile()) {
                                    loadSecondBackup = true;
                                } else {
                                    mLog.info("Using settings from file " + firstSettingsBackupFile.getAbsolutePath());
                                    loadSecondBackup = false;
                                }
                            }
                            catch (Exception e) {
                                loadSecondBackup = true;
                            }
                        }
                        if (loadSecondBackup && secondSettingsBackupFile.isFile()) {
                            try {
                                PROP.readFromFile(secondSettingsBackupFile);
                                mLog.info("Using settings from file " + secondSettingsBackupFile.getAbsolutePath());
                                loadSecondBackup = false;
                            }
                            catch (Exception e) {
                                loadSecondBackup = true;
                            }
                        }
                        if (loadSecondBackup) {
                            mLog.info("Could not read settings - using default user settings");
                        } else {
                            try {
                                Settings.loadWindowSettings();
                                Settings.storeSettings(true);
                            }
                            catch (Exception e) {}
                        }
                        break block85;
                    }
                    mLog.info("Could not read settings - using default user settings");
                }
            } else if (!oldDirectoryName.equals(newDirectoryName)) {
                File oldDir = null;
                ArrayList<Object> directories = new ArrayList<Object>();
                directories.add(Settings.getUserDirectoryName());
                if (Launch.isOsWindowsNtBranch()) {
                    File test = new File(System.getenv("appdata"), "TV-Browser");
                    if (test.isDirectory()) {
                        directories.add(test.getAbsolutePath());
                    }
                    directories.add(System.getProperty("user.home") + "/TV-Browser");
                } else if (Launch.getOs() == 3) {
                    directories.add(System.getProperty("user.home") + File.separator + ".config" + File.separator + "tvbrowser");
                } else if (Launch.isMacOs()) {
                    directories.add(System.getProperty("user.home") + "/Library/Preferences/TV-Browser");
                }
                directories.add(System.getProperty("user.home") + File.separator + DEFAULT_USER_DIR);
                for (int j = 0; j < directories.size(); ++j) {
                    mLog.info("Search for settings import in: '" + (String)directories.get(j) + "'");
                    oldDir = Settings.findNewestOldVersionDir((String)directories.get(j), oldDirectoryName, j != 0, TVBrowser.isTransportable());
                    if (oldDir != null) break;
                }
                File pluginsDir = null;
                if (TVBrowser.isTransportable()) {
                    String msg;
                    String title;
                    Object[] options;
                    mLog.info("TV-Browser ist transportable version, show import dialog: '" + (oldDir != null && oldDir.isDirectory() && oldDir.exists() && !oldDir.getAbsolutePath().startsWith(new File("settings").getAbsolutePath())) + "', show import directory selection dialog: '" + (oldDir == null || !oldDir.isDirectory() || !oldDir.exists()) + "'");
                    if (oldDir != null && oldDir.isDirectory() && oldDir.exists() && !oldDir.getAbsolutePath().startsWith(new File("settings").getAbsolutePath())) {
                        try {
                            UIManager.setLookAndFeel(UiUtilities.getDefaultLookAndFeelClassName(false));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        options = new String[]{MainFrame.LOCALIZER.msg("import", "Import settings"), MainFrame.LOCALIZER.msg("importTransportable", "Select import directory"), MainFrame.LOCALIZER.msg("configureNew", "Create new configuration")};
                        title = MainFrame.LOCALIZER.msg("importInfoTitle", "Import settings?");
                        msg = MainFrame.LOCALIZER.msg("importInfoMsg", "TV-Browser has found settings for import.\nShould the settings be imported now?");
                        int answer = UiUtilities.showOptionDialogOnMouseScreen(msg, title, 1, 2, null, options, options[0]);
                        if (answer == 2) {
                            oldDir = null;
                        } else if (answer == 1) {
                            oldDir = Settings.loadExternalSettings();
                            if (oldDir != null) {
                                oldDir = Settings.findNewestOldVersionDir(oldDir.getAbsolutePath(), oldDirectoryName, true, false);
                            }
                        } else {
                            oldDir = Settings.findNewestOldVersionDir(oldDir.getParentFile().getAbsolutePath(), oldDirectoryName, true, false);
                            if (OperatingSystem.isMacOs()) {
                                pluginsDir = new File(System.getProperty("user.home"), "Library/Application Support/TV-Browser/plugins");
                            }
                        }
                    } else if (oldDir == null || !oldDir.isDirectory() || !oldDir.exists()) {
                        try {
                            UIManager.setLookAndFeel(UiUtilities.getDefaultLookAndFeelClassName(false));
                        }
                        catch (Exception options2) {
                            // empty catch block
                        }
                        options = new String[]{MainFrame.LOCALIZER.msg("importTransportable", "Select import directory"), MainFrame.LOCALIZER.msg("configureNew", "Create new configuration")};
                        title = MainFrame.LOCALIZER.msg("importInfoTitle", "Import settings?");
                        msg = MainFrame.LOCALIZER.msg("importInfoMsgTransportable", "No settings were found on the system.\nDo you want to select the directory of another\ntransportable version for import of settings?");
                        if (UiUtilities.showOptionDialogOnMouseScreen(msg, title, 0, 2, null, options, options[1]) == 0) {
                            oldDir = Settings.loadExternalSettings();
                            if (oldDir != null) {
                                oldDir = Settings.findNewestOldVersionDir(oldDir.getAbsolutePath(), oldDirectoryName, true, false);
                            }
                        } else {
                            oldDir = null;
                        }
                    }
                }
                if (oldDir != null && oldDir.isDirectory() && oldDir.exists()) {
                    boolean versionTest;
                    File testFile = new File(oldDir, SETTINGS_FILE);
                    Settings.startImportWaitingDlg();
                    mLog.info("Try to load settings from a previous version of TV-Browser: " + oldDir);
                    final File newDir = new File(Settings.getUserSettingsDirName());
                    File oldTvDataDir = null;
                    File oldIconsDir = null;
                    File oldInfoIconsDir = null;
                    final Properties prop = new Properties();
                    try {
                        StreamUtilities.inputStream(testFile, new InputStreamProcessor(){

                            @Override
                            public void process(InputStream input) throws IOException {
                                prop.load(input);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String versionString = prop.getProperty("version", null);
                    Version testVersion = null;
                    if (versionString != null && !versionString.contains(";")) {
                        try {
                            int asInt = Integer.parseInt(versionString);
                            int major = asInt / 100;
                            int minor = asInt % 100;
                            testVersion = new Version(major, minor);
                        }
                        catch (NumberFormatException asInt) {}
                    } else if (versionString != null && versionString.contains(";")) {
                        String[] parts = versionString.split(";");
                        testVersion = new Version(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), parts.length > 3 ? parts[3].equals("true") : true);
                    }
                    String temp = prop.getProperty("dir.tvdata", null);
                    boolean bl = versionTest = !TVBrowser.isTransportable() && Launch.isOsWindowsNtBranch() && testVersion != null && testVersion.isOlderThan(new Version(3, 0, true)) && (temp == null || temp.replace("/", "\\").equals(System.getProperty("user.home") + "\\TV-Browser\\tvdata"));
                    if ((TVBrowser.isTransportable() || versionTest || !oldDir.getParentFile().equals(newDir.getParentFile())) && !new File(Settings.getUserDirectoryName(), "tvdata").isDirectory()) {
                        try {
                            File test;
                            if (temp != null) {
                                oldTvDataDir = new File(temp);
                            } else if (new File(oldDir, "tvdata").isDirectory()) {
                                oldTvDataDir = new File(oldDir, "tvdata");
                            } else if (new File(oldDir.getParent(), "tvdata").isDirectory()) {
                                oldTvDataDir = new File(oldDir.getParent(), "tvdata");
                            } else if (OperatingSystem.isMacOs() && (test = new File(System.getProperty("user.home"), "Library/Application Support/TV-Browser/tvdata")).isDirectory()) {
                                oldTvDataDir = test;
                            }
                        }
                        catch (Exception test) {
                            // empty catch block
                        }
                    }
                    if (TVBrowser.isTransportable()) {
                        if (!new File(Settings.getUserDirectoryName(), "icons").isDirectory() && new File(oldDir.getParent(), "icons").isDirectory()) {
                            oldIconsDir = new File(oldDir.getParent(), "icons");
                        }
                        if (!new File(Settings.getUserDirectoryName(), "infothemes").isDirectory() && new File(oldDir.getParent(), "infothemes").isDirectory()) {
                            oldInfoIconsDir = new File(oldDir.getParent(), "infothemes");
                        }
                    }
                    if (newDir.mkdirs()) {
                        try {
                            File backupDir;
                            File targetDir;
                            IOUtilities.copy(oldDir.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return !name.equalsIgnoreCase("tvdata") && !name.equals(newDir.getName()) && !name.equalsIgnoreCase("backup") && !name.equalsIgnoreCase("lang");
                                }
                            }), newDir);
                            if (pluginsDir != null && pluginsDir.isDirectory()) {
                                File target = new File(newDir, "plugins");
                                if (!target.isDirectory()) {
                                    target.mkdirs();
                                }
                                IOUtilities.copy(pluginsDir.listFiles(new FileFilter(){

                                    @Override
                                    public boolean accept(File f) {
                                        return f.isFile() && f.getName().toLowerCase().endsWith(".jar");
                                    }
                                }), target);
                            }
                            mShowSettingsCopyWaiting = false;
                            mLog.info("settings from previous version copied successfully");
                            File newSettingsFile = new File(newDir, SETTINGS_FILE);
                            PROP.readFromFile(newSettingsFile);
                            mLog.info("settings from previous version read successfully");
                            if (oldDirectoryName.equals(oldDir.getAbsolutePath())) {
                                File[] settings = newDir.listFiles(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir, String name) {
                                        return name.toLowerCase().endsWith(".prop") && name.toLowerCase().indexOf("settings") == -1 || name.toLowerCase().endsWith(".dat") && name.toLowerCase().indexOf("tv-data-inventory") == -1;
                                    }
                                });
                                boolean version1 = false;
                                if (settings != null) {
                                    for (int i = 0; i < settings.length; ++i) {
                                        String name = "java." + settings[i].getName();
                                        if (settings[i].getName().toLowerCase().startsWith("java.")) continue;
                                        version1 = true;
                                        settings[i].renameTo(new File(settings[i].getParent(), name));
                                    }
                                }
                                if (version1 && !new File(oldDirectoryName, newDir.getName()).isDirectory()) {
                                    oldDir.renameTo(new File(System.getProperty("user.home", "") + File.separator + "tvbrowser_BACKUP"));
                                }
                            }
                            if (oldTvDataDir != null && oldTvDataDir.isDirectory() && !oldTvDataDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "tvdata"))) {
                                targetDir.mkdirs();
                                final CopyWaitingDlg waiting = new CopyWaitingDlg((java.awt.Window)new JFrame(), versionTest ? (byte)2 : 1);
                                mShowWaiting = true;
                                final File srcDir = oldTvDataDir;
                                Thread copyDataThread = new Thread("Copy TV data directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyDataThread.start();
                                waiting.setVisible(mShowWaiting);
                            }
                            if (oldIconsDir != null && oldIconsDir.isDirectory() && !oldIconsDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "icons"))) {
                                targetDir.mkdirs();
                                final CopyWaitingDlg waiting = new CopyWaitingDlg((java.awt.Window)new JFrame(), versionTest ? (byte)2 : 1);
                                mShowWaiting = true;
                                final File srcDir = oldIconsDir;
                                Thread copyIconsThread = new Thread("Copy icons directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyIconsThread.start();
                                waiting.setVisible(mShowWaiting);
                            }
                            if (oldInfoIconsDir != null && oldInfoIconsDir.isDirectory() && !oldInfoIconsDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "infothemes"))) {
                                targetDir.mkdirs();
                                final CopyWaitingDlg waiting = new CopyWaitingDlg((java.awt.Window)new JFrame(), versionTest ? (byte)2 : 1);
                                mShowWaiting = true;
                                final File srcDir = oldInfoIconsDir;
                                Thread copyInfoIconsThread = new Thread("Copy info icons directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyInfoIconsThread.start();
                                waiting.setVisible(mShowWaiting);
                            }
                            if (new File(Settings.getUserDirectoryName(), SETTINGS_FILE).isFile() && (backupDir = new File(Settings.getUserDirectoryName(), "BACKUP")).mkdirs()) {
                                mLog.info("moving the settings of old settings dir to backup");
                                File[] files = oldDir.listFiles(new FileFilter(){

                                    @Override
                                    public boolean accept(File pathname) {
                                        return pathname.compareTo(newDir) != 0 && pathname.getName().compareToIgnoreCase("tvdata") != 0 && pathname.compareTo(backupDir) != 0;
                                    }
                                });
                                if (files != null) {
                                    for (File file : files) {
                                        file.renameTo(new File(backupDir, file.getName()));
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            mLog.log(Level.WARNING, "Could not import user settings from '" + oldDir.getAbsolutePath() + "' to '" + newDir.getAbsolutePath() + "'", e);
                        }
                        if (testVersion != null && testVersion.isOlderThanOrEqualTo(new Version(4, 24))) {
                            File oldReminderDat = new File(newDir, "reminder.dat");
                            File newReminderDat = new File(newDir, "java.reminderplugin.ReminderPlugin.dat");
                            if (oldReminderDat.isFile() && !newReminderDat.isFile()) {
                                oldReminderDat.renameTo(newReminderDat);
                            }
                        }
                    } else {
                        mLog.info("Could not create directory '" + newDir.getAbsolutePath() + "' - using default user settings");
                    }
                } else {
                    mLog.info("No previous version of TV-Browser found - using default user settings");
                }
            }
        }
        mShowSettingsCopyWaiting = false;
        File settingsDir = new File(newDirectoryName);
        if (!settingsDir.exists()) {
            mLog.info("Creating " + newDirectoryName);
            settingsDir.mkdir();
        }
        Settings.loadWindowSettings();
        ((DeferredFontProperty)Fonts.PROGRAM_TITLE).resetDefault();
        ((DeferredFontProperty)Fonts.PROGRAM_INFO).resetDefault();
        ((DeferredFontProperty)Fonts.CHANNEL_NAME).resetDefault();
        ((DeferredFontProperty)Fonts.PROGRAM_TIME).resetDefault();
        if (ProgramTable.COLUMN_WIDTH.getInt() < 100) {
            ProgramTable.COLUMN_WIDTH.setInt(100);
        }
        Settings.updateColors();
    }

    private static void initializeAllSubClasses() {
        Other.initialize();
        Buttons.initialize();
        CenterPanels.initialize();
        IconAndNames.initialize();
        Channels.initialize();
        ContextMenu.initialize();
        DataPostProcessing.initialize();
        Directories.initialize();
        Fonts.initialize();
        General.initialize();
        Locales.initialize();
        LookAndFeel.initialize();
        Markings.initialize();
        Mouse.initialize();
        Network.initialize();
        Pictures.initialize();
        Plugins.initialize();
        ProgramPanel.initialize();
        ProgramTable.initialize();
        Proxy.initialize();
        ToolBar.initialize();
        Tray.initialize();
        WebBrowser.initialize();
        Window.initialize();
        Data.initialize();
    }

    public static void updateColors() {
        int[] colors = Markings.HIGHLIGHTING_COLORS.getIntArray();
        mHighlightingColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            Settings.mHighlightingColors[i] = new Color(colors[i], true);
        }
    }

    public static int getHighlightingPriorityMaximum() {
        return mHighlightingColors.length - 1;
    }

    public static Color getHighlightingColorForPriority(int priority) throws IndexOutOfBoundsException {
        return mHighlightingColors[priority];
    }

    public static void updateContextMenuSettings() {
        ArrayList<ContextMenuMouseActionSetting> leftSingleList = new ArrayList<ContextMenuMouseActionSetting>(2);
        if (PROP.getProperty("leftSingleClickIf") != null) {
            StringProperty propLeftSingleClickIf = new StringProperty(PROP, "leftSingleClickIf", ProgramInfo.getProgramInfoPluginId());
            leftSingleList.add(new ContextMenuMouseActionSetting(0, propLeftSingleClickIf.getString(), -1));
            propLeftSingleClickIf.setString(propLeftSingleClickIf.getDefault());
        }
        if (PROP.getProperty("contextmenudefaultplugin") != null) {
            StringProperty propDoubleClickIf = new StringProperty(PROP, "contextmenudefaultplugin", ProgramInfo.getProgramInfoPluginId());
            Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propDoubleClickIf.getString(), -1)});
            propDoubleClickIf.setString(propDoubleClickIf.getDefault());
        }
        if (PROP.getProperty("middleclickplugin") != null) {
            StringProperty propMiddleClickIf = new StringProperty(PROP, "middleclickplugin", ReminderPlugin.getReminderPluginId());
            Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propMiddleClickIf.getString(), -1)});
            propMiddleClickIf.setString(propMiddleClickIf.getDefault());
        }
        if (PROP.getProperty("middledoubleclickplugin") != null) {
            StringProperty propMiddleDoubleClickIf = new StringProperty(PROP, "middledoubleclickplugin", FavoritesPlugin.getFavoritesPluginId());
            Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propMiddleDoubleClickIf.getString(), -1)});
            propMiddleDoubleClickIf.setString(propMiddleDoubleClickIf.getDefault());
        }
        if (PROP.getProperty("leftSingleCtrlClickIf") != null) {
            StringProperty propLeftSingleCtrlClickIf = new StringProperty(PROP, "leftSingleCtrlClickIf", null);
            leftSingleList.add(new ContextMenuMouseActionSetting(128, propLeftSingleCtrlClickIf.getString(), -1));
            propLeftSingleCtrlClickIf.setString(propLeftSingleCtrlClickIf.getDefault());
        }
        if (!leftSingleList.isEmpty()) {
            Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(leftSingleList.toArray(new ContextMenuMouseActionSetting[leftSingleList.size()]));
        }
        try {
            Settings.storeSettings(true);
        }
        catch (TvBrowserException e) {
            e.printStackTrace();
        }
        ContextMenuManager.getInstance().init();
    }

    private static File findNewestOldVersionDir(String directory, String oldDirectoryName, boolean includeCurrent, boolean quiet) {
        int i;
        File oldDir = null;
        File testFile = null;
        String[] allVersions = TVBrowser.getAllVersionStrings();
        ArrayList<File> directories = new ArrayList<File>();
        int n = i = includeCurrent ? 0 : 1;
        while (i < allVersions.length) {
            testFile = new File(directory + File.separator + allVersions[i], SETTINGS_FILE);
            if (testFile.isFile()) {
                oldDir = testFile;
                directories.add(oldDir);
            }
            ++i;
        }
        if (oldDir == null) {
            testFile = new File(directory, SETTINGS_FILE);
            if (testFile.isFile()) {
                oldDir = new File(directory);
            } else {
                testFile = new File(oldDirectoryName, SETTINGS_FILE);
                if (testFile.isFile()) {
                    oldDir = new File(oldDirectoryName);
                }
            }
        } else if (!directories.isEmpty()) {
            Collections.sort(directories, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    int result = 0;
                    if (o1.lastModified() > o2.lastModified()) {
                        result = -1;
                    } else if (o1.lastModified() < o2.lastModified()) {
                        result = 1;
                    }
                    return result;
                }
            });
            long threeMonthsBefore = System.currentTimeMillis() - 7776000000L;
            for (int i2 = directories.size() - 1; i2 >= 1; --i2) {
                if (((File)directories.get(i2)).lastModified() >= threeMonthsBefore) continue;
                directories.remove(i2);
            }
            if (directories.size() > 1 && !quiet) {
                int i3;
                Localizer localizer = Localizer.getLocalizerFor(Settings.class);
                ButtonGroup bg = new ButtonGroup();
                JRadioButton[] versions = new JRadioButton[directories.size()];
                DateFormat dateFormat = DateFormat.getDateInstance(2);
                Object[] message = new Object[versions.length + 1];
                message[0] = localizer.msg("selectImportDirectoryMessage", "Settings were found of different recently used versions of TV-Browser.\nPlease select the version to import the settings from.\n(If you are unsure, just accept the preselection with OK.)\n\n");
                for (i3 = 0; i3 < versions.length; ++i3) {
                    File dir = (File)directories.get(i3);
                    versions[i3] = new JRadioButton(localizer.msg("selectImportDirectoryInfo", "{0} (last used: {1})", dir.getParentFile().getName(), dateFormat.format(new Date(dir.lastModified()))));
                    bg.add(versions[i3]);
                    message[i3 + 1] = versions[i3];
                }
                versions[0].setSelected(true);
                UiUtilities.showMessageDialogOnMouseScreen(message, localizer.msg("selectImportDirectoryTitle", "TV-Browser - Select settings to import"), 3);
                for (i3 = 0; i3 < versions.length; ++i3) {
                    if (!versions[i3].isSelected()) continue;
                    oldDir = ((File)directories.get(i3)).getParentFile();
                    break;
                }
            } else if (!directories.isEmpty()) {
                oldDir = ((File)directories.get(0)).getParentFile();
            }
        }
        return oldDir;
    }

    private static File loadExternalSettings() {
        String msg = MainFrame.LOCALIZER.msg("importTransportableInfo", "To import settings of another transportable version select the program\ndirectory of that other transportable version in the next setp.");
        String title = MainFrame.LOCALIZER.msg("importTransportableTitle", "Import settings from transportable version");
        UiUtilities.showMessageDialogOnMouseScreen(msg, title, 1);
        JFileChooser chooseDir = new JFileChooser(System.getProperty("user.home"));
        chooseDir.setFileSelectionMode(1);
        chooseDir.setDialogTitle(title);
        chooseDir.setMultiSelectionEnabled(false);
        int selection = 1;
        do {
            String title2;
            String msg2;
            if (selection != 0 || UiUtilities.showConfirmDialogOnMouseScreen(msg2 = MainFrame.LOCALIZER.msg("importTransportableError", "You've selected a directory that don't contains a transportable TV-Browser.\nWould you like to try again?"), title2 = MainFrame.LOCALIZER.msg("importTransportableErrorTitle", "Wrong directory selected"), 0, 3) != 1) continue;
            selection = 1;
            break;
        } while ((selection = chooseDir.showDialog(null, Localizer.getLocalization("i18n_select"))) != 1 && (chooseDir.getSelectedFile() == null || !chooseDir.getSelectedFile().isDirectory() || !new File(chooseDir.getSelectedFile(), "settings").isDirectory() || !new File(chooseDir.getSelectedFile(), "tvbrowser.jar").isFile()));
        if (selection == 0 && chooseDir.getSelectedFile() != null) {
            return new File(chooseDir.getSelectedFile(), "settings");
        }
        return null;
    }

    private static void loadWindowSettings() {
        File windowSettingsFile = new File(Settings.getUserSettingsDirName(), WINDOW_SETTINGS_FILE);
        if (windowSettingsFile.isFile() && windowSettingsFile.canRead()) {
            try {
                StreamUtilities.objectInputStream(windowSettingsFile, new ObjectInputStreamProcessor(){

                    @Override
                    public void process(ObjectInputStream in) throws IOException {
                        if (in.available() > 0) {
                            in.readInt();
                            int n = in.readInt();
                            mWindowSettings = new HashMap(n);
                            for (int i = 0; i < n; ++i) {
                                mWindowSettings.put(in.readUTF(), new WindowSetting(in));
                            }
                        }
                        in.close();
                    }
                });
            }
            catch (Exception e) {
                mWindowSettings = null;
            }
        }
        if (mWindowSettings == null) {
            mWindowSettings = new HashMap(1);
        }
    }

    public static void handleChangedSettings() {
        DefaultProgramTableModel model;
        ProgramTableScrollPane scrollPane;
        Settings.updateColors();
        MainFrame mainFrame = MainFrame.getInstance();
        Property[] propArr = new Property[]{ProgramPanel.BORDER_ON_AIR_PROGRAMS_SHOW, Markings.USES_EXTRA_SPACE_FOR_MARK_ICONS, Markings.WITH_MARKINGS_SHOWING_BORDER, Markings.MARK_PRIORITY_DEFAULT, ProgramPanel.COLOR_ON_AIR_LIGHT, ProgramPanel.COLOR_ON_AIR_DARK, ProgramPanel.COLOR_FOREGROUND, ProgramTable.COLOR_BACKGROUND_SINGLE, ProgramPanel.TRANSPARENCY_ALLOW, CenterPanels.ALWAYS_SHOW_TAB_BAR_FOR_CENTER_PANEL, ProgramPanel.ORIGINIAL_TITLES_SHOW, Markings.HIGHLIGHTING_COLORS};
        mainFrame.updateCenterPanels();
        Property[] propArrFont = new Property[]{Fonts.PROGRAM_TITLE, Fonts.PROGRAM_INFO, Fonts.PROGRAM_TIME, Fonts.CHANNEL_NAME, Fonts.USE_DEFAULT, Fonts.ANTIALIASING_ENABLED, Fonts.PROGRAM_TEX_TLINE_GAP};
        boolean fontChanged = PROP.hasChanged(propArrFont);
        if (fontChanged) {
            for (ChangeListener listener : mListListenerFontChange) {
                listener.stateChanged(new ChangeEvent(Settings.class));
            }
        }
        if (fontChanged || PROP.hasChanged(propArr)) {
            util.ui.ProgramPanel.updateFonts();
            ChannelPanel.fontChanged();
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.forceRepaintAll();
        }
        if (PROP.hasChanged(propArr = new Property[]{Pictures.TYPE, Pictures.TIME_START, Pictures.TIME_END, Pictures.DESCRIPTION_SHOW, Pictures.PLUGIN_IDS, Pictures.DURATION, ProgramPanel.TITLE_CUT_LINES, ProgramPanel.TITLE_CUT, Pictures.DESCRIPTION_LINES, ProgramPanel.MAX_LINES, ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION, ProgramPanel.DESCRIPTION_LIMIT_BY_DURATION_MINUTES, Pictures.BORDER_SHOW})) {
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (PROP.hasChanged(ProgramPanel.HYPHENATION)) {
            TextLineBreakerStringWidth.resetHyphenator();
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (PROP.hasChanged(ProgramTable.COLUMN_WIDTH)) {
            util.ui.ProgramPanel.updateColumnWidth();
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.setColumnWidth(ProgramTable.COLUMN_WIDTH.getInt());
            scrollPane.forceRepaintAll();
        }
        if (PROP.hasChanged(ProgramTable.LAYOUT)) {
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.getProgramTable().setProgramTableLayout(null);
            scrollPane.getProgramTable().updateBackground();
            scrollPane.forceRepaintAll();
        }
        if (PROP.hasChanged(Plugins.DEACTIVATED)) {
            mainFrame.updatePluginsMenu();
            mainFrame.updateToolbar();
        }
        if (PROP.hasChanged(propArr = new Property[]{ProgramTable.STYLE_BACKGROUND, ProgramTable.ONE_IMAGE_BACKGROUND, ProgramTable.TIME_BLOCK_SIZE, ProgramTable.TIME_BLOCK_BACKGROUND1, ProgramTable.TIME_BLOCK_BACKGROUND2, ProgramTable.TIME_BLOCK_SHOW_WEST, ProgramTable.TIME_BLOCK_WEST_IMAGE1, ProgramTable.TIME_BLOCK_WEST_IMAGE2, ProgramTable.TIME_OF_DAY_BACKGROUND_EDGE, ProgramTable.TIME_OF_DAY_BACKGROUND_EARLY, ProgramTable.TIME_OF_DAY_BACKGROUND_MIDDAY, ProgramTable.TIME_OF_DAY_BACKGROUND_AFTERNOON, ProgramTable.TIME_OF_DAY_BACKGROUND_EVENING})) {
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.getProgramTable().updateBackground();
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (PROP.hasChanged(ProgramTable.TIME_BLOCK_SIZE)) {
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (PROP.hasChanged(propArr = new Property[]{ToolBar.BUTTON_STYLE, ToolBar.BUTTONS, ToolBar.LOCATION, ToolBar.IS_VISIBLE, ToolBar.BIG_ICONS_USE})) {
            mainFrame.updateToolbar();
        }
        if (PROP.hasChanged(Buttons.TIME_BUTTONS)) {
            mainFrame.updateTimeButtons();
        }
        if (PROP.hasChanged(Channels.SUBSCRIBED)) {
            ChannelList.reload();
            model = mainFrame.getProgramTableModel();
            model.setChannels(ChannelList.getSubscribedChannels());
            mainFrame.updateChannellist();
        }
        if (PROP.hasChanged(LookAndFeel.PERSONA_RANDOM) && !PROP.hasChanged(LookAndFeel.PERSONA_SELECTED)) {
            Persona.getInstance().applyPersona();
        }
        if (PROP.hasChanged(LookAndFeel.PERSONA_SELECTED)) {
            Persona.getInstance().applyPersona();
        }
        if (PROP.hasChanged(propArr = new Property[]{ProgramTable.START_OF_DAY, ProgramTable.END_OF_DAY})) {
            model = mainFrame.getProgramTableModel();
            int startOfDay = ProgramTable.START_OF_DAY.getInt();
            int endOfDay = ProgramTable.END_OF_DAY.getInt();
            model.setTimeRange(startOfDay, endOfDay);
            model.setDate(mainFrame.getCurrentSelectedDate(), null, null);
        }
        if (PROP.hasChanged(propArr = new Property[]{ProgramPanel.ICON_PLUGINS, ProgramPanel.INFO_FIELDS, ProgramPanel.INFO_FIELDS_SEPARATORS, ProgramPanel.ICON_PLUGINS_ALTERNATIVE, ProgramPanel.INFO_FIELDS_ALTERNATIVE, ProgramPanel.INFO_FIELDS_SEPARATORS_ALTERNATIVE})) {
            model = mainFrame.getProgramTableModel();
            model.setDate(mainFrame.getCurrentSelectedDate(), null, null);
        }
        if (PROP.hasChanged(propArr = new Property[]{IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE, IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST, IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE, IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST, IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_TABLE, IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_LISTS})) {
            mainFrame.getProgramTableScrollPane().updateChannelPanel();
            mainFrame.updateChannelChooser();
        }
        if (PROP.hasChanged(Directories.TV_DATA)) {
            TvDataServiceProxyManager.getInstance().setTvDataDir(new File(Directories.TV_DATA.getString()));
            TvDataBase.getInstance().updateTvDataBase();
            TvDataBase.getInstance().checkTvDataInventory(1);
            MainFrame.getInstance().handleChangedTvDataDir();
        }
        if (PROP.hasChanged(LookAndFeel.VIEW_DATE_LAYOUT)) {
            MainFrame.getInstance().createDateSelector();
            MainFrame.getInstance().setShowDatelist(true, true);
        }
        if (PROP.hasChanged(General.CAN_RECEIVE_PROTOCOL_MESSAGE)) {
            ProtocolHandler.getInstance().handleSettingsChanged();
        }
        PROP.clearChanges();
        try {
            Settings.storeSettings(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PluginProxyManager.getInstance().fireTvBrowserSettingsChanged();
    }

    public static String getTimePattern() {
        if (Locales.TWELVE_HOUR_FORMAT.getBoolean()) {
            return "hh:mm a";
        }
        return "HH:mm";
    }

    private static String getDefaultTvDataDir() {
        return TVBrowser.isTransportable() && !mCopyToSystem ? "./settings/tvdata" : Settings.getUserDirectoryName() + File.separator + "tvdata";
    }

    private static String getDefaultPluginsDir() {
        return Settings.getUserSettingsDirName() + "/plugins";
    }

    public static final String getCountry() {
        String country = Locale.getDefault().getCountry();
        String result = Locale.getDefault().getLanguage();
        if (country.equals(new Locale("de_AT", "AT").getCountry()) || result.toLowerCase().equals(new Locale("de_AT", "AT").getLanguage().toLowerCase())) {
            result = "at";
        } else if (country.equals(new Locale("de_CH", "CH").getCountry()) || result.toLowerCase().equals(new Locale("de_CH", "CH").getLanguage().toLowerCase())) {
            result = "ch";
        } else if (country.equals(new Locale("de_DE", "DE").getCountry()) || result.toLowerCase().equals(new Locale("de_DE", "DE").getLanguage().toLowerCase())) {
            result = "de";
        }
        return result.toLowerCase();
    }

    public static final void layoutWindow(String windowId, java.awt.Window window) {
        Settings.layoutWindow(windowId, window, null);
    }

    public static final void layoutWindow(String windowId, java.awt.Window window, Dimension defaultSize) {
        Settings.layoutWindow(windowId, window, defaultSize, null);
    }

    public static final void layoutWindow(String windowId, java.awt.Window window, Dimension defaultSize, java.awt.Window parent) {
        Settings.layoutWindow(windowId, window, defaultSize, parent, false);
    }

    public static final void layoutWindow(String windowId, java.awt.Window window, Dimension defaultSize, java.awt.Window parent, boolean ignoreAndMinSizeLocation) {
        WindowSetting setting = mWindowSettings.get(windowId);
        if (setting == null) {
            setting = new WindowSetting(defaultSize);
            mWindowSettings.put(windowId, setting);
        }
        setting.setIgnoreAndMinSizeLocation(ignoreAndMinSizeLocation);
        setting.layout(window, parent);
    }

    public static final void updateWindowSettings(String windowId, Dimension defaultSize, boolean ignoreAndMinSizeLocation) {
        WindowSetting setting = mWindowSettings.get(windowId);
        if (setting == null) {
            setting = new WindowSetting(defaultSize);
            mWindowSettings.put(windowId, setting);
        }
        setting.setIgnoreAndMinSizeLocation(ignoreAndMinSizeLocation);
    }

    public static void updateChannelFilters(Channel[] channelArr) {
        Settings.updateChannelFilters(channelArr, true);
    }

    public static void updateChannelFilters(Channel[] channelArr, boolean updateAll) {
        ArrayList<SingleChannelFilterComponent> channelNameUpdateList = FilterComponentList.getInstance().updateChannels(channelArr);
        if (!channelNameUpdateList.isEmpty()) {
            ProgramFilter[] filters = FilterList.getInstance().getFilterArr();
            for (SingleChannelFilterComponent scFilter : channelNameUpdateList) {
                for (ProgramFilter filter : filters) {
                    if (!(filter instanceof UserFilter)) continue;
                    String rule = ((UserFilter)filter).getRule();
                    try {
                        ((UserFilter)filter).setRule(rule.replace(scFilter.getLoadName(), scFilter.getName()));
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                }
                scFilter.updateName();
            }
        }
        if (!channelNameUpdateList.isEmpty() || updateAll) {
            FilterComponentList.getInstance().store();
            FilterList.getInstance().updateAvailableChannels(channelArr);
            FilterList.getInstance().store();
        }
        MainFrame.updateFilterPanelLabel();
    }

    public static final void openSettingsDir() {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(new File(Settings.getUserSettingsDirName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        mCopyToSystem = false;
        mListListenerFontChange = new ArrayList();
        propProgramPanelMarkedMinPriorityColor = new ColorProperty(PROP, "programpanel.ColorMarked", new Color(140, 255, 0, 60));
        propProgramPanelMarkedLowerMediumPriorityColor = new ColorProperty(PROP, "programpanel.ColorMarkedLowerMedium", new Color(0, 255, 255, 50));
        propProgramPanelMarkedMediumPriorityColor = new ColorProperty(PROP, "programpanel.ColorMarkedMedium", new Color(255, 255, 0, 60));
        propProgramPanelMarkedHigherMediumPriorityColor = new ColorProperty(PROP, "programpanel.ColorMarkedHigherMedium", new Color(255, 180, 0, 110));
        propProgramPanelMarkedMaxPriorityColor = new ColorProperty(PROP, "programpanel.ColorMarkedMax", new Color(255, 0, 0, 30));
    }

    public static final class Data {
        public static final IntProperty DOWNLOAD_PERIOD = new IntProperty(PROP, "downloadperiod", 1);
        public static final BooleanProperty SAVE_DEFAULT_DATA_UPDATE_VALUES_DEFAULT = new BooleanProperty(PROP, "saveDefaultDataUpdateValuesDefault", true);
        public static final DateProperty DOWNLOAD_DATE_LAST = new DateProperty(PROP, "lastdownload", devplugin.Date.getCurrentDate().addDays(-100));
        public static final StringArrayProperty DATA_SERVICES_FOR_UPDATE = new StringArrayProperty(PROP, "tvdataservices.update", null);
        public static final IntProperty DOWNLOAD_TIME_LAST = new IntProperty(PROP, "lastdownloadTime", 0);
        public static final StringArrayProperty ACCEPTED_LICENSES = new StringArrayProperty(PROP, "licnseIds", new String[0]);
        public static final IntProperty DATA_SERVICE_AUTO_UPDATE_TIME = new IntProperty(PROP, "dataServiceAutoUpdateTime", 30);

        private static final void initialize() {
        }

        private Data() {
        }
    }

    public static final class Window {
        public static final BooleanProperty MAXIMIZED = new BooleanProperty(PROP, "window.isMaximized", false);
        public static final BooleanProperty MAC_OS_FULL_SCREEN = new BooleanProperty(PROP, "window.isInMacOSFullScreen", false);
        public static final IntProperty WIDTH = new IntProperty(PROP, "window.width", 770);
        public static final IntProperty HEIGHT = new IntProperty(PROP, "window.height", 550);
        public static final IntProperty X = new IntProperty(PROP, "window.x", -1);
        public static final IntProperty Y = new IntProperty(PROP, "window.y", -1);
        public static final BooleanProperty MENU_BAR_VISIBLE = new BooleanProperty(PROP, "isMenubarVisible", true);
        public static final BooleanProperty STATUS_BAR_VISIBLE = new BooleanProperty(PROP, "isStatusbarVisible", true);
        public static final BooleanProperty PLUGIN_VIEW_SHOW = new BooleanProperty(PROP, "show.pluginview", false);
        public static final BooleanProperty TIME_BUTTONS_SHOW = new BooleanProperty(PROP, "show.timebuttons", true);
        public static final BooleanProperty CHANNEL_SELECTION_SHOW = new BooleanProperty(PROP, "show.channels", true);
        public static final BooleanProperty DATE_SELECTION_SHOW = new BooleanProperty(PROP, "show.datelist", true);
        public static final BooleanProperty FILTER_BAR_SHOW = new BooleanProperty(PROP, "show.filterbar", true);
        public static final BooleanProperty ASSISTANT_SHOW = new BooleanProperty(PROP, "showassistant", true);
        public static final StringProperty FILTER_LAST_USED = new StringProperty(PROP, "lastusedfilter", null);
        public static final SplitViewProperty VIEW_ROOT = new SplitViewProperty(PROP, "view.root", false, true, 200);
        public static final SplitViewProperty VIEW_MAIN_FRAME = new SplitViewProperty(PROP, "view.mainframe", false, false, 150);
        public static final SplitViewProperty VIEW_NAVIGATION = new SplitViewProperty(PROP, "view.navigation", true, true, 150);
        public static final SplitViewProperty VIEW_DATE_CHANNEL = new SplitViewProperty(PROP, "view.date_channel", true, true, 150);
        public static final IntProperty SCREEN_NUMBER = new IntProperty(PROP, "screenNumber", -1);

        private static final void initialize() {
        }

        private Window() {
        }
    }

    public static final class WebBrowser {
        public static final String ID = "#webbrowser";
        public static final StringProperty USER_DEFINED = new StringProperty(PROP, "webbrowser", null);
        public static final StringProperty USER_DEFINED_PARAMS = new StringProperty(PROP, "webbrowserParams", "{0}");
        public static final BooleanProperty OPEN_BROWSER_DIALOG_SHOW = new BooleanProperty(PROP, "showBrowserOpenDialog", true);

        private static final void initialize() {
        }

        private WebBrowser() {
        }
    }

    public static final class Tray {
        public static final String ID = "#tray";
        public static final BooleanProperty ENABLED = new BooleanProperty(PROP, "trayIsEnabled", true);
        public static final BooleanProperty MINIMIZE_TO = new BooleanProperty(PROP, "MinimizeToTray", false);
        public static final BooleanProperty NOW_ON_RESTORE = new BooleanProperty(PROP, "jumpNowOnRestore", true);
        public static final BooleanProperty ANTIALIASING = new BooleanProperty(PROP, "trayIsAntialiasing", true);
        public static final BooleanProperty FILTER_NOT_MARKED = new BooleanProperty(PROP, "trayFilterNotMarked", false);
        public static final BooleanProperty FILTER_NOT = new BooleanProperty(PROP, "trayFilterAll", false);

        private static final void initialize() {
            Channels.initialize();
            Important.initialize();
            Now.initialize();
            OnTime.initialize();
            Soon.initialize();
        }

        private Tray() {
        }

        public static final class Soon {
            public static final String ID = "#traySoon";
            public static final BooleanProperty ENABLED = new BooleanProperty(PROP, "traySoonProgramsEnabled", true);
            public static final BooleanProperty CONTAINS_NAME = new BooleanProperty(PROP, "traySoonProgramsContainsName", true);
            public static final BooleanProperty CONTAINS_ICON = new BooleanProperty(PROP, "traySoonProgramsContainsIcon", true);
            public static final BooleanProperty CONTAINS_TIME = new BooleanProperty(PROP, "traySoonProgramsContainsTime", true);
            public static final BooleanProperty CONTAINS_TOOL_TIP = new BooleanProperty(PROP, "traySoonProgramsContainsToolTip", true);
            public static final BooleanProperty SORT_NUMBER_SHOW = new BooleanProperty(PROP, "traySoonProgramsShowingSortNumber", true);

            private static final void initialize() {
            }

            private Soon() {
            }
        }

        public static final class Channels {
            public static final String ID = "#trayChannels";
            public static final BooleanProperty SPECIAL_USE = new BooleanProperty(PROP, "trayUseSpecialChannels", false);
            public static final ChannelArrayProperty SPECIAL = new ChannelArrayProperty(PROP, "traySpecialChannels", new Channel[0]);
            public static final IntProperty WIDTH = new IntProperty(PROP, "trayChannelWidth", 78);

            private static final void initialize() {
            }

            private Channels() {
            }
        }

        public static final class OnTime {
            public static final String ID = "#trayOnTime";
            public static final BooleanProperty ENABLED = new BooleanProperty(PROP, "trayOnTimeProgramsEnabled", true);
            public static final BooleanProperty IN_SUB_MENU = new BooleanProperty(PROP, "trayOnTimeProgramsInSubMenus", true);
            public static final BooleanProperty CONTAINS_NAME = new BooleanProperty(PROP, "trayOnTimeProgramsContainsName", true);
            public static final BooleanProperty CONTAINS_ICON = new BooleanProperty(PROP, "trayOnTimeProgramsContainsIcon", true);
            public static final BooleanProperty CONTAINS_TIME = new BooleanProperty(PROP, "trayOnTimeProgramsContainsTime", false);
            public static final BooleanProperty CONTAINS_TOOL_TIP = new BooleanProperty(PROP, "trayOnTimeProgramsContainsToolTip", true);
            public static final BooleanProperty SORT_NUMBER_SHOW = new BooleanProperty(PROP, "trayOnTimeProgramsShowingSortNumber", true);
            public static final BooleanProperty PROGRESS_SHOW = new BooleanProperty(PROP, "trayOnTimeProgramsShowProgress", true);
            public static final ColorProperty COLOR_PROGRESS_BACKGROUND_LIGHT = new ColorProperty(PROP, "trayOnTimeProgramsLightBackground", new Color(255, 150, 0, 40));
            public static final ColorProperty COLOR_PROGRESS_BACKGROUND_DARK = new ColorProperty(PROP, "trayOnTimeProgramsDarkBackground", new Color(255, 150, 0, 80));

            private static final void initialize() {
            }

            private OnTime() {
            }
        }

        public static final class Now {
            public static final String ID = "#trayNow";
            public static final BooleanProperty ENABLED = new BooleanProperty(PROP, "trayNowProgramsEnabled", true);
            public static final BooleanProperty IN_SUB_MENU = new BooleanProperty(PROP, "trayNowProgramsInSubMenus", false);
            public static final BooleanProperty CONTAINS_NAME = new BooleanProperty(PROP, "trayNowProgramsContainsName", true);
            public static final BooleanProperty CONTAINS_ICON = new BooleanProperty(PROP, "trayNowProgramsContainsIcon", true);
            public static final BooleanProperty CONTAINS_TIME = new BooleanProperty(PROP, "trayNowProgramsContainsTime", false);
            public static final BooleanProperty CONTAINS_TOOL_TIP = new BooleanProperty(PROP, "trayNowProgramsContainsToolTip", true);
            public static final BooleanProperty SORT_NUMBER_SHOW = new BooleanProperty(PROP, "trayNowProgramsShowingSortNumber", true);

            private static final void initialize() {
            }

            private Now() {
            }
        }

        public static final class Important {
            public static final String ID = "#trayImportant";
            public static final BooleanProperty ENABLED = new BooleanProperty(PROP, "trayImportantProgramsEnabled", true);
            public static final BooleanProperty IN_SUB_MENU = new BooleanProperty(PROP, "trayImportantProgramsInSubMenu", false);
            public static final IntProperty SIZE = new IntProperty(PROP, "trayImportantProgramsSize", 5);
            public static final BooleanProperty CONTAINS_NAME = new BooleanProperty(PROP, "trayImportantProgramsContainsName", true);
            public static final BooleanProperty CONTAINS_ICON = new BooleanProperty(PROP, "trayImportantProgramsContainsIcon", true);
            public static final BooleanProperty CONTAINS_DATE = new BooleanProperty(PROP, "trayImportantProgramsContainsDate", true);
            public static final BooleanProperty CONTAINS_TIME = new BooleanProperty(PROP, "trayImportantProgramsContainsTime", true);
            public static final BooleanProperty CONTAINS_TOOL_TIP = new BooleanProperty(PROP, "trayImportantProgramsContainsToolTip", true);
            public static final IntProperty PRIORITY = new IntProperty(PROP, "trayImportantProgramsPriority", 0);
            public static final BooleanProperty SORT_NUMBER_SHOW = new BooleanProperty(PROP, "trayImportantProgramsShowingSortNumber", true);

            private static final void initialize() {
            }

            private Important() {
            }
        }
    }

    public static final class ToolBar {
        public static final String ID = "#toolbar";
        public static final BooleanProperty IS_VISIBLE = new BooleanProperty(PROP, "isToolbarVisible", true);
        public static final BooleanProperty IS_SEARCH_FIELD_VISIBLE = new BooleanProperty(PROP, "isSearchFieldVisible", true);
        public static final StringProperty LOCATION = new StringProperty(PROP, "toolbarLocation", "north");
        public static final ChoiceProperty BUTTON_STYLE = new ChoiceProperty(PROP, "buttontype", "icon", new String[]{"text&icon", "text", "icon"});
        public static final BooleanProperty BIG_ICONS_USE = new BooleanProperty(PROP, "toolbarUseBigIcons", true);
        public static final StringArrayProperty BUTTONS = new StringArrayProperty(PROP, "toolbarButtons_2.0", null);
        public static final BooleanProperty ADDITIONAL_TOP_SPACE = new BooleanProperty(PROP, "isToolbarAdditonalTopSpace", false);
        public static final BooleanProperty ADDITIONAL_BOTTOM_SPACE = new BooleanProperty(PROP, "isToolbarAddtionalBottomSpace", false);
        public static final BooleanProperty PLUGIN_FUNCTIONS_IN_MENU_SHOW = new BooleanProperty(PROP, "showPluginFunctionsInToolbarMenu", true);

        private static final void initialize() {
        }

        private ToolBar() {
        }
    }

    public static final class Proxy {
        public static final String ID = "#proxy";
        public static final BooleanProperty USE = new BooleanProperty(PROP, "proxy.http.useProxy", false);
        public static final StringProperty HOST = new StringProperty(PROP, "proxy.http.host", "");
        public static final StringProperty PORT = new StringProperty(PROP, "proxy.http.port", "");
        public static final BooleanProperty AUTHENTIFY_AT_PROXY = new BooleanProperty(PROP, "proxy.http.authentifyAtProxy", false);
        public static final StringProperty USER = new StringProperty(PROP, "proxy.http.user", "");
        public static final EncodedStringProperty PASSWORD = new EncodedStringProperty(PROP, "proxy.http.password", "", 6528587292713416704L);

        private static final void initialize() {
        }

        private Proxy() {
        }
    }

    public static final class ProgramTable {
        public static final String ID = "#programtablelook";
        public static final int COLUMN_WIDTH_MAX = 2000;
        public static final int COLUMN_WIDTH_MIN = 100;
        public static final String VALUE_LAYOUT_COMPACT = "compact";
        public static final String VALUE_LAYOUT_REAL_COMPACT = "realCompact";
        public static final String VALUE_LAYOUT_TIME_SYNCHRONOUS = "timeSynchronous";
        public static final String VALUE_LAYOUT_TIME_BLOCK = "timeBlock";
        public static final String VALUE_LAYOUT_COMPACT_TIME_BLOCK = "compactTimeBlock";
        public static final String VALUE_LAYOUT_OPTIMIZED_COMPACT_TIME_BLOCK = "optimizedCompactTimeBlock";
        public static final String VALUE_LAYOUT_REAL_SYNCHRONOUS = "realSynchronous";
        public static final ChoiceProperty STYLE_BACKGROUND = new ChoiceProperty(PROP, "tablebackground.style", "uiTimeBlock", new String[]{"singleColor", "oneImage", "timeBlock", "timeOfDay", "uiColor", "uiTimeBlock"});
        public static final ChoiceProperty LAYOUT = new ChoiceProperty(PROP, "table.layout", "optimizedCompactTimeBlock", new String[]{"timeSynchronous", "compact", "realSynchronous", "realCompact", "timeBlock", "compactTimeBlock", "optimizedCompactTimeBlock"});
        public static final IntProperty COLUMN_WIDTH = new VariableIntProperty(PROP, "columnwidth", 200);
        public static final MinutesProperty START_OF_DAY = new MinutesProperty(PROP, "programtable.startofday", 0);
        public static final MinutesProperty END_OF_DAY = new MinutesProperty(PROP, "programtable.endofday", 300);
        public static final BooleanProperty MOUSE_OVER = new BooleanProperty(PROP, "programpanel.MouseOver", true);
        public static final ColorProperty COLOR_MOUSE_OVER = new ColorProperty(PROP, "programpanel.MouseOverColor", new Color(200, 200, 0, 60));
        public static final BooleanProperty SCROLL_HORIZONTAL = new BooleanProperty(PROP, "programpanel.scrollHorizontal", false);
        public static final BooleanProperty AUTO_CHANGE_DATE = new BooleanProperty(PROP, "autoScrollToNextDay", true);
        public static final BooleanProperty MOUSE_AUTO_SCROLL = new BooleanProperty(PROP, "programTableMouseAutoScroll", true);
        public static final BooleanProperty SCROLL_TO_TIME_MARKING = new BooleanProperty(PROP, "scrollToTimeMarkingActivated", true);
        public static final ColorProperty COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_LIGHT = new ColorProperty(PROP, "scrollToTimeProgramsLightBackground", new Color(255, 150, 0, 40));
        public static final ColorProperty COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_DARK = new ColorProperty(PROP, "scrollToTimeProgramsDarkBackground", new Color(255, 150, 0, 80));
        public static final BooleanProperty HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING = new BooleanProperty(PROP, "scrollToChannelMarkingActivated", true);
        public static final BooleanProperty HIGHLIGHT_CHANNEL_COLUMN_BY_MOUSE = new BooleanProperty(PROP, "highlightChannelColumnByMouse", true);
        public static final ColorProperty COLOR_HIGHLIGHT_CHANNEL_PROGRAMS_BACKGROUND = new ColorProperty(PROP, "scrollToChannelProgramsBackground", new Color(255, 150, 0, 40));
        public static final BooleanProperty FIND_AS_YOU_TYPE = new BooleanProperty(PROP, "typeAsYouFindEnabled", true);
        public static final StringProperty TIME_OF_DAY_BACKGROUND_EDGE = new StringProperty(PROP, "tablebackground.timeofday.edge", "imgs/columns_edge.jpg");
        public static final StringProperty TIME_OF_DAY_BACKGROUND_EARLY = new StringProperty(PROP, "tablebackground.timeofday.early", "imgs/columns_early.jpg");
        public static final StringProperty TIME_OF_DAY_BACKGROUND_MIDDAY = new StringProperty(PROP, "tablebackground.timeofday.midday", "imgs/columns_midday.jpg");
        public static final StringProperty TIME_OF_DAY_BACKGROUND_AFTERNOON = new StringProperty(PROP, "tablebackground.timeofday.afternoon", "imgs/columns_afternoon.jpg");
        public static final StringProperty TIME_OF_DAY_BACKGROUND_EVENING = new StringProperty(PROP, "tablebackground.timeofday.evening", "imgs/columns_evening.jpg");
        public static final ColorProperty COLOR_BACKGROUND_SINGLE = new ColorProperty(PROP, "backgroundSingleColor", Color.white);
        public static final StringProperty ONE_IMAGE_BACKGROUND = new StringProperty(PROP, "tablebackground.oneImage.image", "imgs/columns_evening.jpg");
        public static final IntProperty TIME_BLOCK_SIZE = new IntProperty(PROP, "tablebackground.timeBlock.size", 2);
        public static final StringProperty TIME_BLOCK_BACKGROUND1 = new StringProperty(PROP, "tablebackground.timeBlock.image1", "imgs/time_block_white.png");
        public static final StringProperty TIME_BLOCK_BACKGROUND2 = new StringProperty(PROP, "tablebackground.timeBlock.image2", "imgs/time_block_gray.png");
        public static final BooleanProperty TIME_BLOCK_SHOW_WEST = new BooleanProperty(PROP, "tablebackground.timeBlock.showWest", true);
        public static final StringProperty TIME_BLOCK_WEST_IMAGE1 = new StringProperty(PROP, "tablebackground.timeBlock.west1", "imgs/time_block_white.png");
        public static final StringProperty TIME_BLOCK_WEST_IMAGE2 = new StringProperty(PROP, "tablebackground.timeBlock.west2", "imgs/time_block_gray.png");

        private static final void initialize() {
        }

        private ProgramTable() {
        }
    }

    public static final class ProgramPanel {
        public static final String ID = "#programpanellook";
        public static final StringArrayProperty ICON_PLUGINS = new StringArrayProperty(PROP, "programpanel.iconPlugins", new String[]{"picture.id", "info.id", "tvraterplugin.TVRaterPlugin"});
        public static final StringArrayProperty ICON_PLUGINS_ALTERNATIVE = new StringArrayProperty(PROP, "programpanel.iconPluginsAlternative", new String[]{"picture.id", "info.id", "tvraterplugin.TVRaterPlugin"});
        public static final ProgramFieldTypeArrayProperty INFO_FIELDS = new ProgramFieldTypeArrayProperty(PROP, "programpanel.infoFields", new ProgramFieldType[]{ProgramFieldType.GENRE_TYPE, ProgramFieldType.EPISODE_TYPE, ProgramFieldType.ORIGIN_TYPE, ProgramFieldType.PRODUCTION_YEAR_TYPE, ProgramFieldType.SHORT_DESCRIPTION_TYPE});
        public static final StringArrayProperty INFO_FIELDS_SEPARATORS = new StringArrayProperty(PROP, "programpanel.infoFieldsSeparators", new String[]{" - ", " - ", " - ", " - "});
        public static final ProgramFieldTypeArrayProperty INFO_FIELDS_ALTERNATIVE = new ProgramFieldTypeArrayProperty(PROP, "programpanel.infoFieldsAlternative", new ProgramFieldType[]{ProgramFieldType.GENRE_TYPE, ProgramFieldType.EPISODE_TYPE, ProgramFieldType.ORIGIN_TYPE, ProgramFieldType.PRODUCTION_YEAR_TYPE, ProgramFieldType.SHORT_DESCRIPTION_TYPE});
        public static final StringArrayProperty INFO_FIELDS_SEPARATORS_ALTERNATIVE = new StringArrayProperty(PROP, "programpanel.infoFieldsSeparatorsAlternative", new String[]{" - ", " - ", " - ", " - "});
        public static final BooleanProperty ORIGINIAL_TITLES_SHOW = new BooleanProperty(PROP, "programpanel.ShowOriginalTitles", false);
        public static final BooleanProperty BORDER_ON_AIR_PROGRAMS_SHOW = new BooleanProperty(PROP, "programpanel.onAirProgramsShowingBorder", false);
        public static final BooleanProperty HIGHLIGHTING_COLOR_GRADIENT = new BooleanProperty(PROP, "programpanel.programPanelGradientColorHighlighting", true);
        public static final ColorProperty COLOR_ON_AIR_DARK = new ColorProperty(PROP, "programpanel.ColorOnAirDark", new Color(0, 0, 255, 60));
        public static final ColorProperty COLOR_ON_AIR_LIGHT = new ColorProperty(PROP, "programpanel.ColorOnAirLight", new Color(0, 0, 255, 30));
        public static final ColorProperty COLOR_KEYBOARD_SELECTED = new ColorProperty(PROP, "programpanel.KeyboardSelectedColor", new Color(130, 255, 0, 120));
        public static final BooleanProperty TRANSPARENCY_ALLOW = new BooleanProperty(PROP, "programpanel.AllowTransparency", true);
        public static final BooleanProperty HYPHENATION = new BooleanProperty(PROP, "programpanel.Hyphenation", false);
        public static final BooleanProperty SMOOTHER_SCROLLING = new BooleanProperty(PROP, "smootherScrolling", true);
        public static final BooleanProperty TITLE_CUT = new BooleanProperty(PROP, "programTableCutTitle", true);
        public static final IntProperty TITLE_CUT_LINES = new IntProperty(PROP, "programTableCutTitleLines", 2);
        public static final IntProperty MAX_LINES = new IntProperty(PROP, "programpanel.MaxLines", 3);
        public static final BooleanProperty DESCRIPTION_LIMIT_BY_DURATION = new BooleanProperty(PROP, "programpanel.ShortActive", true);
        public static final IntProperty DESCRIPTION_LIMIT_BY_DURATION_MINUTES = new IntProperty(PROP, "programpanel.ShortMinutes", 10);
        public static final ColorProperty COLOR_FOREGROUND = new ColorProperty(PROP, "programpanel.ColorForeground", Color.black);

        private static final void initialize() {
        }

        private ProgramPanel() {
        }
    }

    public static final class Plugins {
        public static final String ID = "#plugins";
        public static final BlockedPluginArrayProperty BLOCKED_ARRAY = new BlockedPluginArrayProperty(PROP, "blockedPlugins");
        private static final String[] DEFAULT_DISABLED_PLUGINS;
        public static final StringArrayProperty DEACTIVATED;
        public static final BooleanProperty AUTO_UPDATE_ENABLED;
        public static final StringArrayProperty RESET_IDS;
        public static final StringArrayProperty PLUGIN_ORDER;
        public static final StringArrayProperty DELETE_FILES_AT_START;
        public static final DateProperty UPDATE_LAST;
        public static final StringProperty RECEIVE_PLUGIN_USED_LAST;
        public static final StringProperty RECEIVE_TARGET_USED_LAST;
        public static final BooleanProperty BETA_WARNING;
        public static final BooleanProperty BETA_UPDATE_NO;
        public static final StringArrayProperty ACCESS_CONTROL;
        public static final BooleanProperty INFO_DIALOG_WAS_SHOWN;

        private static final void initialize() {
        }

        private Plugins() {
        }

        static {
            ArrayList<String> plugins = new ArrayList<String>();
            plugins.add("java.showviewplugin.ShowviewPlugin");
            plugins.add("java.i18nplugin.I18NPlugin");
            if (!OperatingSystem.isMacOs()) {
                plugins.add("java.growlplugin.GrowlPlugin");
            }
            plugins.add("java.blogthisplugin.BlogThisPlugin");
            DEFAULT_DISABLED_PLUGINS = plugins.toArray(new String[plugins.size()]);
            DEACTIVATED = new StringArrayProperty(PROP, "deactivatedPlugins", DEFAULT_DISABLED_PLUGINS);
            AUTO_UPDATE_ENABLED = new BooleanProperty(PROP, "autoUpdatePlugins", true);
            RESET_IDS = new StringArrayProperty(PROP, "propPluginReset", null);
            PLUGIN_ORDER = new StringArrayProperty(PROP, "plugins", null);
            DELETE_FILES_AT_START = new StringArrayProperty(PROP, "deleteFilesAtStart", new String[0]);
            UPDATE_LAST = new DateProperty(PROP, "lastPluginsUpdate", null);
            RECEIVE_PLUGIN_USED_LAST = new StringProperty(PROP, "lastusedreceiveplugin", null);
            RECEIVE_TARGET_USED_LAST = new StringProperty(PROP, "lastusedreceivetarget", null);
            BETA_WARNING = new BooleanProperty(PROP, "pluginBetaWarning", true);
            BETA_UPDATE_NO = new BooleanProperty(PROP, "pluginNoBetaUpdate", false);
            ACCESS_CONTROL = new StringArrayProperty(PROP, "accessControl", new String[0]);
            INFO_DIALOG_WAS_SHOWN = new BooleanProperty(PROP, "pluginInfoDialogWasShown", false);
        }
    }

    public static final class Pictures {
        public static final String ID = "#pictures";
        public static final IntProperty TYPE = new IntProperty(PROP, "pictures.type", 4);
        public static final MinutesProperty TIME_START = new MinutesProperty(PROP, "pictures.startTime", 1080);
        public static final MinutesProperty TIME_END = new MinutesProperty(PROP, "pictures.endTime", 1380);
        public static final IntProperty DURATION = new IntProperty(PROP, "pictures.duration", 90);
        public static final BooleanProperty DESCRIPTION_SHOW = new BooleanProperty(PROP, "pictures.showDescription", true);
        public static final BooleanProperty BORDER_SHOW = new BooleanProperty(PROP, "showPictureBorder", true);
        public static final StringArrayProperty PLUGIN_IDS = new StringArrayProperty(PROP, "pictures.pluginIds", new String[0]);
        public static final IntProperty PLUGINS_SETTING = new IntProperty(PROP, "pluginsPictureSetting", 1);
        public static final IntProperty DESCRIPTION_LINES = new IntProperty(PROP, "pictures.lines", 6);

        private static final void initialize() {
        }

        private Pictures() {
        }
    }

    public static final class Network {
        public static final String ID = "#network";
        public static final BooleanProperty INTERNET_CONNECTION_CHECK = new BooleanProperty(PROP, "internetConnectionCheck", true);
        public static final IntProperty DEFAULT_CONNECTION_TIMEOUT = new IntProperty(PROP, "network.defaultConnectionTimeout", 60000);
        public static final IntProperty CHECK_TIMEOUT = new IntProperty(PROP, "network.checkTimeout", 10000);

        private static final void initialize() {
        }

        private Network() {
        }
    }

    public static final class Mouse {
        public static final String ID = "#mouse";
        public static final ContextMenuMouseActionArrayProperty LEFT_SINGLE_CLICK_IF_ARRAY = new ContextMenuMouseActionArrayProperty(PROP, "leftSingleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ProgramInfo.getProgramInfoPluginId(), -1)});
        public static final ContextMenuMouseActionArrayProperty LEFT_DOUBLE_CLICK_IF_ARRAY = new ContextMenuMouseActionArrayProperty(PROP, "leftDoubleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ProgramInfo.getProgramInfoPluginId(), -1)});
        public static final ContextMenuMouseActionArrayProperty MIDDLE_SINGLE_CLICK_IF_ARRAY = new ContextMenuMouseActionArrayProperty(PROP, "middleSingleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ReminderPlugin.getReminderPluginId(), -1)});
        public static final ContextMenuMouseActionArrayProperty MIDDLE_DOUBLE_CLICK_IF_ARRAY = new ContextMenuMouseActionArrayProperty(PROP, "middleDoubleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, FavoritesPlugin.getFavoritesPluginId(), 1)});

        private static final void initialize() {
        }

        private Mouse() {
        }
    }

    public static final class Markings {
        public static final String ID = "#programpanelmarking";
        public static final BooleanProperty USES_EXTRA_SPACE_FOR_MARK_ICONS = new BooleanProperty(PROP, "programpanel.usesExtraSpaceForMarkIcons", true);
        public static final BooleanProperty WITH_MARKINGS_SHOWING_BORDER = new BooleanProperty(PROP, "programpanel.markingsShowingBorder", false);
        public static final IntProperty MARK_PRIORITY_DEFAULT = new IntProperty(PROP, "programpanel.defaultMarkPriority", 0);
        public static final IntProperty MARK_PRIORITY_FILTERS = new IntProperty(PROP, "programpanel.filtersMarkPriority", 0);
        public static final IntArrayProperty HIGHLIGHTING_COLORS = new IntArrayProperty(PROP, "programpanel.HighlightingColors", new int[]{new Color(140, 255, 0, 60).getRGB(), new Color(0, 255, 255, 50).getRGB(), new Color(255, 255, 0, 60).getRGB(), new Color(255, 180, 0, 110).getRGB(), new Color(255, 0, 0, 30).getRGB()});
        public static final StringMapProperty HIGHLIGHTING_FILTERS = new StringMapProperty(PROP, "highlightingFilters");

        private static final void initialize() {
        }

        private Markings() {
        }
    }

    public static final class LookAndFeel {
        public static final String ID = "#lookandfeel";
        public static final BooleanProperty PLUGIN_VIEW_IS_LEFT = new BooleanProperty(PROP, "pluginViewIsLeft", true);
        public static final IntProperty VIEW_DATE_LAYOUT = new IntProperty(PROP, "propViewDateLayout", 1);
        public static final BooleanProperty PERSONA_RANDOM = new BooleanProperty(PROP, "randomPersona", false);
        public static final StringProperty PERSONA_SELECTED = new StringProperty(PROP, "persona", "51b73c81-7d61-4626-b230-89627c9f5ce7");
        public static final StringProperty JGOODIES_THEME = new JGoodiesThemeProperty(PROP, "jgoodies.theme");
        public static final BooleanProperty JGOODIES_SHADOW = new BooleanProperty(PROP, "jgoodies.dropshadow", false);
        public static final StringProperty SELECTED = new StringProperty(PROP, "lookandfeel1_1", mDefaultSettings.getProperty("lookandfeel", UiUtilities.getDefaultLookAndFeelClassName(false)));
        public static final StringProperty INFO_ICON_THEME_ID = new StringProperty(PROP, "infoIconThemeName", "tvb_default.zip");
        public static final StringProperty ICON_THEME = new StringProperty(PROP, "icontheme", mDefaultSettings.getProperty("icontheme", null));

        private static final void initialize() {
        }

        private LookAndFeel() {
        }
    }

    public static final class Locales {
        public static final String ID = "#local";
        public static final BooleanProperty TWELVE_HOUR_FORMAT = new BooleanProperty(PROP, "uswTwelveHourFormat", false);
        public static final IntProperty FIRST_DAY_OF_WEEK = new IntProperty(PROP, "firstDayOfWeek", Calendar.getInstance().getFirstDayOfWeek());
        public static final StringProperty LANGUAGE = new StringProperty(PROP, "language", System.getProperty("user.language"));
        public static final StringProperty COUNTRY = new StringProperty(PROP, "country", System.getProperty("user.country", ""));
        public static final StringProperty VARIANT = new StringProperty(PROP, "variant", System.getProperty("user.variant", ""));
        public static final StringProperty TIMEZONE = new StringProperty(PROP, "timeZone", null);

        private static final void initialize() {
        }

        private Locales() {
        }
    }

    public static final class General {
        public static final String ID = "#startup";
        public static final BooleanProperty MINIMIZE_AFTER_STARTUP = new BooleanProperty(PROP, "minimizeAfterStartup", false);
        public static final BooleanProperty START_SCREEN_SHOW = new BooleanProperty(PROP, "splash.show", true);
        public static final BooleanProperty IS_USING_FULLSCREEN = new BooleanProperty(PROP, "isUsingFullscreen", false);
        public static final BooleanProperty SERVER_RESTORE_ENABLED = new BooleanProperty(PROP, "serverRestoreEnabled", true);
        public static final BooleanProperty CAN_RECEIVE_PROTOCOL_MESSAGE = new BooleanProperty(PROP, "canReceiveProtocolMessages", true);
        public static final BooleanProperty ONLY_MINIMIZE_WHEN_WINDOW_CLOSING = new BooleanProperty(PROP, "onlyMinimizeWhenWindowClosing", false);
        public static final HiddenMessagesProperty ASK_FOR_EXIT_CONFIRMATION = new HiddenMessagesProperty("MainFrame.askForExitConfirm", true);
        public static final IntProperty AUTO_CHANNEL_UPDATE_PERIOD = new IntProperty(PROP, "autoChannelUpdatePeriod", 14);
        public static final BooleanProperty AUTO_UPDATE_PRIME_TIME = new BooleanProperty(PROP, "autoUpdatePrimeTime", false);
        public static final ChoiceProperty AUTO_DOWNLOAD_TYPE = new ChoiceProperty(PROP, "autodownload", "daily", new String[]{"startup", "daily", "every3days", "weekly", "never"});
        public static final HiddenMessagesProperty DOWNLOAD_DONE = new HiddenMessagesProperty("downloadDone", true);
        public static final BooleanProperty AUTO_DATA_DOWNLOAD_ENABLED = new BooleanProperty(PROP, "autoDataDownloadEnabled", true);
        public static final BooleanProperty ASK_FOR_AUTO_DOWNLOAD = new BooleanProperty(PROP, "askForAutoDownload", false);
        public static final IntProperty AUTO_DOWNLOAD_PERIOD = new IntProperty(PROP, "autodownloadperiod", 0);
        public static final ShortProperty AUTO_DOWNLOAD_WAITING_TIME = new ShortProperty(PROP, "autoDownloadWaitingTime", 5);
        public static final BooleanProperty AUTO_DOWNLOAD_WAITING_ENABLED = new BooleanProperty(PROP, "autoDownloadWaitingEnabled", true);
        public static final BooleanProperty NTP_TIME_CHECK = new BooleanProperty(PROP, "ntpTimeCheckEnabled", true);
        public static final StringProperty JRE_UPDATE = new StringProperty(PROP, "jreUpdate", "");
        public static final DateProperty JRE_UPDATE_DATE_LAST = new DateProperty(PROP, "jreUpdateDateLast", null);
        public static final BooleanProperty JRE_UPDATE_ENABLED = new BooleanProperty(PROP, "jreUpdateEnabled", true);
        public static final VersionProperty TV_BROWSER_VERSION_USED_LAST = new VersionProperty(PROP, "version", null);
        public static final BooleanProperty TV_BROWSER_VERSION_USED_LAST_IS_STABLE = new BooleanProperty(PROP, "versionIsStable", false);
        public static final DateProperty DATE_FIRST_START = new DateProperty(PROP, "firstStartDate", null);
        public static final DateProperty NTP_CHECK_LAST = new DateProperty(PROP, "lastNTPCheck", null);
        public static final BooleanProperty LOGGING_VERBOSE = new BooleanProperty(PROP, "verboseLogging", false);
        public static final DateProperty DATE_OLD_SETTINGS_CHECKED_LAST = new DateProperty(PROP, "dateOldSettingsCheckedLast", null);
        public static final StringProperty FILTER_DEFAULT = new StringProperty(PROP, "defaultFilter", "");
        public static final VersionProperty VERSION_AVAILABLE = new VersionProperty(PROP, "versionAvailable", TVBrowser.VERSION);
        public static final VersionProperty TEST_VERSION_AVAILABLE = new VersionProperty(PROP, "testVersionAvailable", TVBrowser.VERSION);
        public static final HiddenMessagesProperty INFORM_TEST_VERSIONS = new HiddenMessagesProperty("informTestVersions", false);

        private static final void initialize() {
        }

        private General() {
        }
    }

    public static final class Fonts {
        public static final String ID = "#fonts";
        public static final BooleanProperty ANTIALIASING_ENABLED = new BooleanProperty(PROP, "enableantialiasing", true);
        public static final BooleanProperty USE_DEFAULT = new BooleanProperty(PROP, "usedefaultfonts", true);
        public static final FontProperty CHANNEL_NAME = new DeferredFontProperty(PROP, "font.channelname", DEFAULT_CHANNELNAMEFONT);
        public static final FontProperty PROGRAM_TITLE = new DeferredFontProperty(PROP, "font.programtitle", DEFAULT_PROGRAMTITLEFONT);
        public static final FontProperty PROGRAM_INFO = new DeferredFontProperty(PROP, "font.programinfo", DEFAULT_PROGRAMINFOFONT);
        public static final FontProperty PROGRAM_TIME = new DeferredFontProperty(PROP, "font.programtime", DEFAULT_PROGRAMTIMEFONT);
        public static final IntProperty PROGRAM_TEX_TLINE_GAP = new IntProperty(PROP, "font.lineGap", 0);

        private static final void initialize() {
        }

        private Fonts() {
        }
    }

    public static final class Directories {
        public static final String ID = "#directories";
        public static final StringProperty TV_DATA = new StringProperty(PROP, "dir.tvdata", mDefaultSettings.getProperty("tvdatadir", Settings.getDefaultTvDataDir()));
        public static final StringProperty PLUGINS = new StringProperty(PROP, "dir.plugins", mDefaultSettings.getProperty("pluginsdir", Settings.getDefaultPluginsDir()));
        public static final StringProperty LOG = new StringProperty(PROP, "logdirectory", mDefaultSettings.getProperty("logdirectory", null));

        private static final void initialize() {
        }

        private Directories() {
        }
    }

    public static final class DataPostProcessing {
        public static final String ID = "#dataPluginPostProcessing";
        public static final StringArrayProperty ORDER = new StringArrayProperty(PROP, "dataPluginPostProcessingOrder", new String[0]);

        private static final void initialize() {
        }

        private DataPostProcessing() {
        }
    }

    public static final class ContextMenu {
        public static final String ID = "#contextmenu";
        public static final StringArrayProperty DISABLED_SUB_ITEMS = new StringArrayProperty(PROP, "propContextMenuDisabledSubItems", null);
        public static final StringArrayProperty MENU_ORDER = new StringArrayProperty(PROP, "contextMenuOrder", new String[]{"programinfo.ProgramInfo", "searchplugin.SearchPlugin", "reminderplugin.ReminderPlugin", "favoritesplugin.FavoritesPlugin", "######SEPARATOR######", "java.webplugin.WebPlugin", "java.simplemarkerplugin.SimpleMarkerPlugin", "java.captureplugin.CapturePlugin"});
        public static final StringArrayProperty DISABLED_ITEMS = new StringArrayProperty(PROP, "contextMenuDisabledItems", null);
        public static final StringArrayProperty PLUGINS_KNOWN = new StringArrayProperty(PROP, "knownContextMenuPlugins", new String[0]);

        private static final void initialize() {
        }

        private ContextMenu() {
        }
    }

    public static final class Channels {
        public static final String ID = "#channels";
        public static final ChannelArrayProperty SUBSCRIBED = new ChannelArrayProperty(PROP, "subscribedchannels", new Channel[0]);
        public static final StringProperty GROUP_LAST_USED = new StringProperty(PROP, "lastchannelgroup", null);
        public static final StringArrayProperty SUBSCRIBED_SEPARATORS = new StringArrayProperty(PROP, "subscribedChannelsSeparators", new String[0]);
        public static final ByteProperty SELECTED_CATEGORY_INDEX = new ByteProperty(PROP, "selectedChannelCategoryIndex", 1);
        public static final StringProperty SELECTED_COUNTRY = new StringProperty(PROP, "selectedChannelCountry", "");
        public static final StringProperty LAST_EXPORT_FILE = new StringProperty(PROP, "lastChannelExportFile", System.getProperty("user.home") + "/TVB-channel-export.txt");
        public static final StringProperty SELECTED_PLUGIN = new StringProperty(PROP, "selectedChannelPlugin", "");
        public static final StringArrayProperty USED_CHANNEL_GROUPS = new StringArrayProperty(PROP, "usedChannelGroups", null);
        public static final BooleanProperty WERE_CONFIGURED = new BooleanProperty(PROP, "channelsWereConfigured", false);
        public static final DateProperty UPDATE_LAST = new DateProperty(PROP, "lastChannelUpdate", null);
        public static final StringArrayProperty DATA_SERVICE_IDS_USED_CURRENTLY = new StringArrayProperty(PROP, "currentDataServices", new String[0]);

        private static final void initialize() {
        }

        private Channels() {
        }
    }

    public static final class IconAndNames {
        public static final int VALUE_NAME_ONLY = 0;
        public static final int VALUE_ICON_ONLY = 1;
        public static final int VALUE_NAME_AND_ICON = 2;
        public static final String ID = "#channelIconName";
        public static final BooleanProperty SHOW_ICONS_IN_PROGRAM_TABLE = new BooleanProperty(PROP, "showChannelIconsInProgramtable", true);
        public static final BooleanProperty SHOW_NAMES_IN_PROGRAM_TABLE = new BooleanProperty(PROP, "showChannelNamesInProgramtable", true);
        public static final IntProperty SHOW_LOGO_FOR_PROGRAM_PANEL = new IntProperty(PROP, "showChannelLogoForProgramPanel", 0);
        public static final BooleanProperty SHOW_ICONS_IN_CHANNEL_LIST = new BooleanProperty(PROP, "showChannelIconsInChannellist", true);
        public static final BooleanProperty SHOW_NAMES_IN_CHANNEL_LIST = new BooleanProperty(PROP, "showChannelNamesInChannellist", true);
        public static final BooleanProperty SHOW_SORT_NUMBER_IN_PROGRAM_TABLE = new BooleanProperty(PROP, "showSortNumberInProgramTable", true);
        public static final BooleanProperty SHOW_CHANNEL_TOOLTIP_IN_PROGRAM_TABLE = new BooleanProperty(PROP, "showChannelTooltipInProgramtable", true);
        public static final BooleanProperty SHOW_SORT_NUMBER_IN_PROGRAM_LISTS = new BooleanProperty(PROP, "showSortNumberInProgramLists", true);

        private static final void initialize() {
        }

        private IconAndNames() {
        }
    }

    public static final class CenterPanels {
        public static final String ID = "#centerpanelsetup";
        public static final StringArrayProperty CENTER_PANEL_ARR = new StringArrayProperty(PROP, "centerPanelArr", new String[]{"tvbrowser.ui.programtable.ProgramTableScrollPaneWrapper"});
        public static final StringArrayProperty DISABLED_CENTER_PANEL_ARR = new StringArrayProperty(PROP, "disabledCenterPanelArr", new String[0]);
        public static final BooleanProperty ALWAYS_SHOW_TAB_BAR_FOR_CENTER_PANEL = new BooleanProperty(PROP, "alwaysShowTabBarForCenterPanel", true);
        public static final IntProperty TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG = new IntProperty(PROP, "pbBarCenterPanelNameIconConfig", 2);
        public static final BooleanProperty PLUGIN_FUNCTIONS_IN_MENU_SHOW = new BooleanProperty(PROP, "showPluginFunctionsInTabpaneMenu", true);

        private static final void initialize() {
        }
    }

    public static final class Buttons {
        public static final String ID = "#timebuttons";
        public static final IntArrayProperty TIME_BUTTONS = new IntArrayProperty(PROP, "timeButtons", new int[]{360, 720, 1080, 1215});

        private static final void initialize() {
        }

        private Buttons() {
        }
    }

    public static final class Other {
        public static final IntProperty SETTINGS_DIALOG_DIVIDER_LOCATION = new IntProperty(PROP, "settingsDialogDividerLocation", 200);
        public static final StringProperty SETTINGS_LAST_USED_PATH = new StringProperty(PROP, "lastUsedSettingsTabClassName", "#channels");
        public static final StringArrayProperty MESSAGE_BOXES_HIDDEN = new StringArrayProperty(PROP, "hideMessageBox", new String[0]);
        public static final StringArrayProperty FAVORITE_BLOCKED_FILTER_COMPONENTS = new StringArrayProperty(PROP, "favoriteBlockedFilterComponents", new String[]{"tvbrowser.core.filters.filtercomponents.BeanShellFilterComponent", "tvbrowser.core.filters.filtercomponents.ProgramMarkingPriorityFilterComponent", "tvbrowser.core.filters.filtercomponents.ReminderFilterComponent", "tvbrowser.core.filters.filtercomponents.PluginFilterComponent"});

        private static final void initialize() {
        }

        private Other() {
        }
    }

    private static final class VariableFontSizeFont
    extends Font {
        private int mOffset;

        public VariableFontSizeFont(String name, int style, int offset) {
            super(name, style, UIManager.getFont("MenuItem.font").getSize() + offset);
            this.mOffset = offset;
        }

        @Override
        public int getSize() {
            return UIManager.getFont("MenuItem.font").getSize() + this.mOffset;
        }
    }
}

