/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.contextmenu;

import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Program;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;

public class SelectProgramContextMenuItem
implements ContextMenuIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SelectProgramContextMenuItem.class);
    private static SelectProgramContextMenuItem mInstance;
    protected static final String SELECTPROGRAM = "######SELECTPROGRAM######";

    private SelectProgramContextMenuItem() {
        mInstance = this;
    }

    public static SelectProgramContextMenuItem getInstance() {
        if (mInstance == null) {
            new SelectProgramContextMenuItem();
        }
        return mInstance;
    }

    @Override
    public ActionMenu getContextMenuActions(final Program program) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> MainFrame.getInstance().selectProgram(program, false));
            }
        };
        action.putValue("Name", this.toString());
        return new ActionMenu(action);
    }

    @Override
    public String getId() {
        return SELECTPROGRAM;
    }

    public String toString() {
        return mLocalizer.msg("selectProgram", "Select programs");
    }
}

