/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.ActionMenu;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginsProgramFilter;
import devplugin.Program;
import devplugin.Version;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataBaseListener;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.plugin.AbstractPluginProxy;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginStateListener;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MarkedProgramsMap;
import tvdataservice.MutableChannelDayProgram;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;

public class PluginProxyManager {
    private static final Logger mLog = Logger.getLogger(PluginProxyManager.class.getName());
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginProxyManager.class);
    private static PluginProxyManager mSingleton;
    public static final String PLUGIN_DIRECTORY = "plugins";
    private static final int SHUT_DOWN_STATE = 1;
    private static final int LOADED_STATE = 2;
    private static final int ACTIVATED_STATE = 3;
    private ArrayList<PluginListItem> mPluginList;
    private HashMap<String, PluginListItem> mPluginMap;
    private ArrayList<PluginStateListener> mPluginStateListenerList;
    private PluginProxy[] mActivatedPluginCache;
    private PluginProxy[] mAllPluginCache;
    private ArrayList<PluginProxy> mStartFinishedPlugins = new ArrayList();
    private ArrayList<ThreadPoolMethod> mPoolMethods = new ArrayList();
    private ExecutorService mThreadPool;

    private PluginProxyManager() {
        this.mPluginList = new ArrayList();
        this.mPluginMap = new HashMap();
        this.mPluginStateListenerList = new ArrayList();
        TvDataBase.getInstance().addTvDataListener(new TvDataBaseListener(){

            @Override
            public void dayProgramAdded(ChannelDayProgram prog) {
                PluginProxyManager.this.fireTvDataAdded(prog);
            }

            @Override
            public void dayProgramDeleted(ChannelDayProgram prog) {
                PluginProxyManager.this.fireTvDataDeleted(prog);
            }

            @Override
            public void dayProgramAdded(MutableChannelDayProgram prog) {
                PluginProxyManager.this.fireTvDataAdded(prog);
            }

            @Override
            public void dayProgramTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
                PluginProxyManager.this.fireTvDataTouched(removedDayProgram, addedDayProgram);
            }
        });
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateStarted(Date until) {
                PluginProxyManager.this.fireTvDataUpdateStarted(until);
            }

            @Override
            public void tvDataUpdateFinished() {
                PluginProxyManager.this.fireTvDataUpdateFinished();
            }
        });
        Plugin.setPluginManager(PluginManagerImpl.getInstance());
    }

    public static PluginProxyManager getInstance() {
        if (mSingleton == null) {
            mSingleton = new PluginProxyManager();
        }
        return mSingleton;
    }

    public void registerPlugin(AbstractPluginProxy plugin) {
        PluginListItem pluginListItem = new PluginListItem(plugin);
        PluginListItem remove = null;
        for (PluginListItem listItem : this.mPluginList) {
            if (!listItem.getPlugin().getId().equals(plugin.getId())) continue;
            remove = listItem;
            break;
        }
        if (remove != null) {
            this.mPluginList.remove(remove);
        }
        this.mPluginList.add(pluginListItem);
        this.mPluginMap.put(plugin.getId(), pluginListItem);
        this.firePluginLoaded(plugin);
        this.mAllPluginCache = null;
    }

    public void init() throws TvBrowserException {
        String[] pluginOrderArr = Settings.Plugins.PLUGIN_ORDER.getStringArray();
        String[] deactivatedPluginArr = Settings.Plugins.DEACTIVATED.getStringArray();
        if (pluginOrderArr != null && pluginOrderArr.length > 0) {
            String className = pluginOrderArr[0];
            String asId = "java." + className;
            if (this.getPluginForId(className) == null && this.getPluginForId(asId) != null) {
                deactivatedPluginArr = this.installedClassNamesToDeactivatedIds(pluginOrderArr);
                Settings.Plugins.DEACTIVATED.setStringArray(deactivatedPluginArr);
                for (int i = 0; i < pluginOrderArr.length; ++i) {
                    pluginOrderArr[i] = "java." + pluginOrderArr[i];
                }
                Settings.Plugins.PLUGIN_ORDER.setStringArray(pluginOrderArr);
            }
        }
        this.setPluginOrder(pluginOrderArr);
        this.activateAllPluginsExcept(deactivatedPluginArr);
        ContextMenuManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentFrame(Frame parent) {
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                item.getPlugin().setParentFrame(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] installedClassNamesToDeactivatedIds(String[] installedPluginClassNameArr) {
        ArrayList<String> deactivatedPluginList = new ArrayList<String>();
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                String pluginId = item.getPlugin().getId();
                boolean activated = false;
                for (String className : installedPluginClassNameArr) {
                    String asId = "java." + className;
                    if (!pluginId.equals(asId)) continue;
                    activated = true;
                    break;
                }
                if (activated) continue;
                deactivatedPluginList.add(pluginId);
            }
        }
        String[] deactivatedPluginIdArr = new String[deactivatedPluginList.size()];
        deactivatedPluginList.toArray(deactivatedPluginIdArr);
        return deactivatedPluginIdArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginOrder(String[] pluginOrderArr) {
        if (pluginOrderArr == null || pluginOrderArr.length == 0) {
            return;
        }
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            ArrayList<PluginListItem> tempList = new ArrayList<PluginListItem>(this.mPluginList.size());
            tempList.addAll(this.mPluginList);
            this.mPluginList.clear();
            block3: for (String id : pluginOrderArr) {
                for (int i = 0; i < tempList.size(); ++i) {
                    PluginListItem item = (PluginListItem)tempList.get(i);
                    if (!id.equals(item.getPlugin().getId())) continue;
                    tempList.remove(i);
                    this.mPluginList.add(item);
                    continue block3;
                }
            }
            this.mPluginList.addAll(tempList);
        }
        this.mActivatedPluginCache = null;
        this.mAllPluginCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAllPluginsExcept(String[] deactivatedPluginIdArr) {
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                String pluginId = item.getPlugin().getId();
                boolean activated = true;
                if (deactivatedPluginIdArr != null) {
                    for (String deactivatedId : deactivatedPluginIdArr) {
                        if (!pluginId.equals(deactivatedId)) continue;
                        activated = false;
                        break;
                    }
                }
                if (!activated) continue;
                try {
                    if (Settings.Plugins.BLOCKED_ARRAY.isBlocked(item.getPlugin())) continue;
                    this.activatePlugin(item, true);
                }
                catch (TvBrowserException exc) {
                    ErrorHandler.handle(exc);
                }
            }
        }
    }

    public void activatePlugin(PluginProxy plugin) throws TvBrowserException {
        this.activatePlugin(plugin, true);
    }

    public void activatePlugin(PluginProxy plugin, boolean setParentFrame) throws TvBrowserException {
        boolean activated;
        PluginListItem item = this.getItemForPlugin(plugin);
        if (item != null && (activated = this.activatePlugin(item, false))) {
            PluginsProgramFilter[] filters;
            if (setParentFrame) {
                item.getPlugin().setParentFrame(MainFrame.getInstance());
            }
            if ((filters = item.getPlugin().getAvailableFilter()) != null) {
                for (PluginsProgramFilter filter : filters) {
                    FilterManagerImpl.getInstance().addFilter(filter);
                }
            }
        }
        MainFrame.getInstance().updateFilterMenu();
        MainFrame.updateFilterPanelLabel();
    }

    public void firePluginBlockListRenewed() {
        for (PluginListItem item : this.mPluginList) {
            if (!Settings.Plugins.BLOCKED_ARRAY.isBlocked(item.mPlugin) || this.getActivatedPluginForId(item.getPlugin().getId()) == null) continue;
            try {
                this.deactivatePlugin(item.getPlugin());
            }
            catch (TvBrowserException e) {
                mLog.severe("Blocked Plugin '" + item.getPlugin().getInfo().getName() + "' could not be deactivated!");
            }
        }
    }

    private boolean activatePlugin(PluginListItem item, boolean start) throws TvBrowserException {
        if (Settings.Plugins.BLOCKED_ARRAY.isBlocked(item.getPlugin())) {
            mLog.info("It was tried to actiavte blocked plugin '" + item.getPlugin().getInfo().getName() + "'. FORBIDDEN!");
            return false;
        }
        this.checkStateChange(item, 2, 3);
        AbstractPluginProxy plugin = item.getPlugin();
        mLog.info("Activating plugin " + plugin.getId());
        item.setState(3);
        plugin.onActivation();
        plugin.loadSettings();
        this.mActivatedPluginCache = null;
        if (!start) {
            plugin.handleTvBrowserStartFinished();
        }
        this.firePluginActivated(plugin);
        return true;
    }

    public void deactivatePlugin(PluginProxy plugin) throws TvBrowserException {
        PluginListItem item = this.getItemForPlugin(plugin);
        if (item != null) {
            PluginsProgramFilter[] filters;
            for (PluginsProgramFilter filter : filters = FilterList.getInstance().getPluginsProgramFiltersForPlugin(plugin)) {
                if (FilterManagerImpl.getInstance().getCurrentFilter() == filter) {
                    FilterManagerImpl.getInstance().setCurrentFilter(FilterManagerImpl.getInstance().getDefaultFilter());
                }
                FilterList.getInstance().remove(filter, true);
            }
            FilterList.getInstance().store();
            MainFrame.getInstance().updateFilterMenu();
            this.deactivatePlugin(item, true);
            String[] deactivatedPlugins = this.getDeactivatedPluginIds();
            Settings.Plugins.DEACTIVATED.setStringArray(deactivatedPlugins);
            MainFrame.getInstance().getToolbar().updatePluginButtons();
        }
    }

    private void deactivatePlugin(PluginListItem item, boolean log) throws TvBrowserException {
        this.checkStateChange(item, 3, 2);
        if (log) {
            mLog.info("Deactivating plugin " + item.getPlugin().getId());
        }
        try {
            this.saveSettings(item);
        }
        catch (TvBrowserException e) {
            ErrorHandler.handle(e);
        }
        final AbstractPluginProxy plugin = item.getPlugin();
        item.getPlugin().onDeactivation();
        item.setState(2);
        this.mActivatedPluginCache = null;
        this.firePluginDeactivated(item.getPlugin(), log);
        if (plugin != null && !MainFrame.isShuttingDown()) {
            new Thread("Unmark all programs of plugin"){

                @Override
                public void run() {
                    Program[] programs;
                    this.setPriority(1);
                    for (Program program : programs = MarkedProgramsMap.getInstance().getMarkedPrograms()) {
                        if (program == null) continue;
                        program.unmark(plugin);
                    }
                }
            }.start();
        }
        MainFrame.getInstance().updateFilterMenu();
        MainFrame.updateFilterPanelLabel();
    }

    public void removePlugin(PluginProxy plugin) throws TvBrowserException {
        PluginListItem item = this.getItemForPlugin(plugin);
        if (item != null) {
            if (item.getState() == 3) {
                this.deactivatePlugin(item, true);
            }
            this.mPluginList.remove(item);
            this.mPluginMap.remove(plugin.getId());
            this.mActivatedPluginCache = null;
            this.mAllPluginCache = null;
        }
    }

    public boolean saveSettings(PluginProxy plugin) {
        try {
            this.saveSettings(this.getItemForPlugin(plugin));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void saveSettings(PluginListItem item) throws TvBrowserException {
        item.getPlugin().saveSettings(!MainFrame.isShuttingDown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAllPlugins(boolean log) {
        if (log) {
            mLog.info("Finishing plugins");
        }
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                if (!item.getPlugin().isActivated()) continue;
                try {
                    this.deactivatePlugin(item, log);
                }
                catch (TvBrowserException exc) {
                    ErrorHandler.handle(exc);
                }
            }
            for (PluginListItem item : this.mPluginList) {
                if (log) {
                    mLog.info("Shutting down plugin " + item.getPlugin().getId());
                }
                item.setState(1);
                this.firePluginUnloaded(item.getPlugin());
            }
        }
    }

    private void checkStateChange(PluginListItem item, int requiredState, int newState) throws TvBrowserException {
        if (item.getState() == newState) {
            throw new TvBrowserException(PluginProxyManager.class, "error.1", "The plugin {0} can not be set to {1}, because it already is {1}.", (Object)item.getPlugin().getInfo().getName(), PluginProxyManager.getLocalizedStateName(newState));
        }
        if (item.getState() != requiredState) {
            Object[] params = new String[]{item.getPlugin().getInfo().getName(), PluginProxyManager.getLocalizedStateName(newState), PluginProxyManager.getLocalizedStateName(item.getState()), PluginProxyManager.getLocalizedStateName(requiredState)};
            throw new TvBrowserException(PluginProxyManager.class, "error.2", "The plugin {0} can not be set to {1}, because is currently {2} and not {3}.", params);
        }
    }

    public static String getLocalizedStateName(int state) {
        if (state == 1) {
            return mLocalizer.msg("state.shutDown", "shut down");
        }
        if (state == 2) {
            return mLocalizer.msg("state.loaded", "loaded");
        }
        if (state == 3) {
            return mLocalizer.msg("state.activated", "activated");
        }
        return mLocalizer.msg("state.unknown", "unknown ({0})", state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginProxy[] getAllPlugins() {
        PluginProxy[] allPluginArr = this.mAllPluginCache;
        if (allPluginArr == null) {
            ArrayList<PluginListItem> arrayList = this.mPluginList;
            synchronized (arrayList) {
                allPluginArr = new PluginProxy[this.mPluginList.size()];
                for (int i = 0; i < this.mPluginList.size(); ++i) {
                    PluginListItem item = this.mPluginList.get(i);
                    allPluginArr[i] = item.getPlugin();
                }
            }
            this.mAllPluginCache = allPluginArr;
        }
        return (PluginProxy[])allPluginArr.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginProxy[] getActivatedPlugins() {
        PluginProxy[] activatedPluginArr = this.mActivatedPluginCache;
        if (activatedPluginArr == null) {
            ArrayList<AbstractPluginProxy> activatedPluginList = new ArrayList<AbstractPluginProxy>();
            ArrayList<PluginListItem> arrayList = this.mPluginList;
            synchronized (arrayList) {
                for (PluginListItem item : this.mPluginList) {
                    if (!item.getPlugin().isActivated()) continue;
                    activatedPluginList.add(item.getPlugin());
                }
            }
            activatedPluginArr = new PluginProxy[activatedPluginList.size()];
            activatedPluginList.toArray(activatedPluginArr);
            this.mActivatedPluginCache = activatedPluginArr;
        }
        return (PluginProxy[])activatedPluginArr.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDeactivatedPluginIds() {
        ArrayList<String> deactivatedPluginIdList = new ArrayList<String>();
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                if (item.getPlugin().isActivated()) continue;
                deactivatedPluginIdList.add(item.getPlugin().getId());
            }
        }
        return deactivatedPluginIdList.toArray(new String[deactivatedPluginIdList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginProxy getPluginForId(String pluginId, int state) {
        if (pluginId == null) {
            return null;
        }
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            PluginListItem item = this.mPluginMap.get(pluginId);
            if (item != null) {
                if (state == -1 || item.getState() == state) {
                    return item.getPlugin();
                }
                return null;
            }
            return null;
        }
    }

    public PluginProxy getPluginForId(String pluginId) {
        return this.getPluginForId(pluginId, -1);
    }

    public PluginProxy getActivatedPluginForId(String pluginId) {
        return this.getPluginForId(pluginId, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginListItem getItemForPlugin(PluginProxy plugin) {
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            for (PluginListItem item : this.mPluginList) {
                if (item.getPlugin() != plugin) continue;
                return item;
            }
        }
        mLog.warning("Unknown plugin: " + plugin.getId());
        return null;
    }

    public static JPopupMenu createPluginContextMenu(Program program) {
        return PluginProxyManager.createPluginContextMenu(program, null);
    }

    public static JPopupMenu createPluginContextMenu(Program program, ContextMenuIf menuIf) {
        return PluginProxyManager.createPluginContextMenu(program, menuIf, null);
    }

    public static JPopupMenu createPluginContextMenu(Program program, ContextMenuIf menuIf, ActionMenu callerMenu) {
        Component[] comps;
        JPopupMenu menu = new JPopupMenu();
        JMenu menus = ContextMenuManager.getInstance().createContextMenuItems(menuIf, program, callerMenu);
        for (Component component : comps = menus.getMenuComponents()) {
            menu.add(component);
        }
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginStateListener(PluginStateListener listener) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            this.mPluginStateListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginStateListener(PluginStateListener listener) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            this.mPluginStateListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginLoaded(PluginProxy plugin) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            for (PluginStateListener listener : this.mPluginStateListenerList) {
                try {
                    listener.pluginLoaded(plugin);
                }
                catch (Throwable thr) {
                    mLog.log(Level.WARNING, "Fireing event 'plugin loaded' failed", thr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginUnloaded(PluginProxy plugin) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            for (PluginStateListener listener : this.mPluginStateListenerList) {
                try {
                    listener.pluginUnloaded(plugin);
                }
                catch (Throwable thr) {
                    mLog.log(Level.WARNING, "Fireing event 'plugin unloaded' failed", thr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginActivated(PluginProxy plugin) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            for (PluginStateListener listener : this.mPluginStateListenerList) {
                try {
                    listener.pluginActivated(plugin);
                }
                catch (Throwable thr) {
                    mLog.log(Level.WARNING, "Fireing event 'plugin activated' failed", thr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginDeactivated(PluginProxy plugin, boolean log) {
        ArrayList<PluginStateListener> arrayList = this.mPluginStateListenerList;
        synchronized (arrayList) {
            for (PluginStateListener listener : this.mPluginStateListenerList) {
                try {
                    listener.pluginDeactivated(plugin);
                }
                catch (Throwable thr) {
                    if (!log) continue;
                    mLog.log(Level.WARNING, "Fireing event 'plugin deactivated' failed", thr);
                }
            }
        }
    }

    private void fireTvDataAdded(final MutableChannelDayProgram newProg) {
        ArrayList<PluginListItem> items = PluginProxyManager.sortPluginProxiesForDataPostProcessing(this.getPluginListCopy());
        for (PluginListItem item : items) {
            if (!item.getPlugin().isActivated()) continue;
            final AbstractPluginProxy plugin = item.getPlugin();
            try {
                Thread t = new Thread("handle tv data added"){

                    @Override
                    public void run() {
                        plugin.handleTvDataAdded(newProg);
                    }
                };
                t.start();
                if (!t.isAlive()) continue;
                try {
                    t.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable t) {
                mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataAdded(MutableChannelDayProgram)' of Plugin '" + plugin + "'.", t);
            }
        }
    }

    private void fireTvDataAdded(ChannelDayProgram newProg) {
        this.runWithThreadPool(new TvDataAddedThreadPoolMethod(newProg));
    }

    private void fireTvDataDeleted(ChannelDayProgram deletedProg) {
        this.runWithThreadPool(new TvDataDeletedThreadPoolMethod(deletedProg));
    }

    private void fireTvDataTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
        this.runWithThreadPool(new TvDataTouchedThreadPoolMethod(removedDayProgram, addedDayProgram));
    }

    private void fireTvDataUpdateFinished() {
        this.runWithThreadPool(new TvDataUpdateFinishedThreadPoolMethod());
    }

    private void fireTvDataUpdateStarted(Date until) {
        for (PluginListItem item : this.getPluginListCopy()) {
            if (!item.getPlugin().isActivated()) continue;
            AbstractPluginProxy plugin = item.getPlugin();
            try {
                plugin.handleTvDataUpdateStarted(until);
            }
            catch (Throwable t) {
                mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataUpdateStarted' of Plugin '" + plugin + "'.", t);
            }
        }
    }

    private synchronized void createThreadPool(ThreadPoolMethod threadPoolMethod) {
        if (this.mThreadPool == null) {
            int processors = Runtime.getRuntime().availableProcessors();
            this.mThreadPool = Executors.newFixedThreadPool(processors);
            for (int i = 0; i < processors; ++i) {
                this.mThreadPool.execute(() -> {
                    while (true) {
                        ThreadPoolMethod poolMethod = null;
                        ArrayList<ThreadPoolMethod> arrayList = this.mPoolMethods;
                        synchronized (arrayList) {
                            if (!this.mPoolMethods.isEmpty()) {
                                try {
                                    poolMethod = this.mPoolMethods.remove(0);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (poolMethod != null) {
                            poolMethod.run();
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                });
            }
        }
    }

    private void runWithThreadPool(ThreadPoolMethod threadPoolMethod) {
        this.mPoolMethods.add(threadPoolMethod);
        if (this.mThreadPool == null) {
            this.createThreadPool(threadPoolMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<PluginListItem> getPluginListCopy() {
        ArrayList<PluginListItem> localList;
        ArrayList<PluginListItem> arrayList = this.mPluginList;
        synchronized (arrayList) {
            localList = new ArrayList<PluginListItem>(this.mPluginList);
        }
        return localList;
    }

    public void fireTvBrowserStartFinished() {
        ((PluginManagerImpl)PluginManagerImpl.getInstance()).handleTvBrowserStartFinished();
        for (PluginListItem item : this.getPluginListCopy()) {
            AbstractPluginProxy plugin = item.getPlugin();
            if (!plugin.isActivated()) continue;
            this.runWithThreadPool(new TvBrowserStartFinishedThreadPoolMethod(plugin));
        }
    }

    public void fireTvBrowserStartFinished(PluginProxy plugin) throws Throwable {
        if (this.mStartFinishedPlugins.contains(plugin)) {
            return;
        }
        this.mStartFinishedPlugins.add(plugin);
        plugin.handleTvBrowserStartFinished();
    }

    public void fireTvBrowserSettingsChanged() {
        ((PluginManagerImpl)PluginManagerImpl.getInstance()).handleTvBrowserStartFinished();
        for (PluginListItem item : this.getPluginListCopy()) {
            AbstractPluginProxy plugin = item.getPlugin();
            if (!plugin.isActivated()) continue;
            this.runWithThreadPool(new TvBrowserSettingsChangedThreadPoolMethod(plugin));
        }
    }

    public void fireTvBrowserVersionUpdate(Version previousVersion) {
        this.runWithThreadPool(new TvBrowserVersionUpdateThreadPoolMethod(previousVersion));
    }

    private static ArrayList<PluginListItem> sortPluginProxiesForDataPostProcessing(ArrayList<PluginListItem> toSort) {
        final String[] sortedPlugins = Settings.DataPostProcessing.ORDER.getStringArray();
        Collections.sort(toSort, new Comparator<PluginListItem>(){

            @Override
            public int compare(PluginListItem pp1, PluginListItem pp2) {
                int result = 0;
                int pp1Index = -1;
                int pp2Index = -1;
                for (int i = 0; i < sortedPlugins.length; ++i) {
                    if (pp1.getPlugin().getId().equals(sortedPlugins[i])) {
                        pp1Index = i;
                        continue;
                    }
                    if (!pp2.getPlugin().getId().equals(sortedPlugins[i])) continue;
                    pp2Index = i;
                }
                if (pp1Index != -1 && pp2Index != -1) {
                    if (pp1Index > pp2Index) {
                        result = -1;
                    } else if (pp1Index < pp2Index) {
                        result = 1;
                    }
                } else if (pp1Index == -1 && pp2Index == -1) {
                    result = pp1.getPlugin().getInfo().getName().compareToIgnoreCase(pp2.getPlugin().getInfo().getName());
                } else if (pp1Index == -1) {
                    result = 1;
                } else if (pp2Index == -1) {
                    result = -1;
                }
                return result;
            }
        });
        return toSort;
    }

    private static class PluginListItem {
        private AbstractPluginProxy mPlugin;
        private int mState;

        public PluginListItem(AbstractPluginProxy plugin) {
            this.mPlugin = plugin;
            this.mState = 2;
        }

        public AbstractPluginProxy getPlugin() {
            return this.mPlugin;
        }

        public void setState(int state) {
            this.mState = state;
            this.mPlugin.setActivated(state == 3);
        }

        public int getState() {
            return this.mState;
        }
    }

    private class TvDataAddedThreadPoolMethod
    extends ThreadPoolMethod {
        private ChannelDayProgram mChannelDayProgram;

        public TvDataAddedThreadPoolMethod(ChannelDayProgram newProg) {
            super("HandleTvDataAdded(ChannelDayProgram) for '" + newProg.getChannel() + "' on " + newProg.getDate());
            this.mChannelDayProgram = newProg;
        }

        @Override
        public void run() {
            for (PluginListItem item : PluginProxyManager.this.getPluginListCopy()) {
                if (!item.getPlugin().isActivated()) continue;
                AbstractPluginProxy plugin = item.getPlugin();
                try {
                    plugin.handleTvDataAdded(this.mChannelDayProgram);
                }
                catch (Throwable t) {
                    mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataAdded(ChannelDayProgram)' of Plugin '" + plugin + "'.", t);
                }
            }
        }
    }

    private class TvDataDeletedThreadPoolMethod
    extends ThreadPoolMethod {
        private ChannelDayProgram mChannelDayProgram;

        public TvDataDeletedThreadPoolMethod(ChannelDayProgram deletedProg) {
            super("handleTvDataDeleted for '" + deletedProg.getChannel() + "' on " + deletedProg.getDate());
        }

        @Override
        public void run() {
            for (PluginListItem item : PluginProxyManager.this.getPluginListCopy()) {
                if (!item.getPlugin().isActivated()) continue;
                AbstractPluginProxy plugin = item.getPlugin();
                try {
                    plugin.handleTvDataDeleted(this.mChannelDayProgram);
                }
                catch (Throwable t) {
                    mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataDeleted' of Plugin '" + plugin + "'.", t);
                }
            }
        }
    }

    private class TvDataTouchedThreadPoolMethod
    extends ThreadPoolMethod {
        private ChannelDayProgram mRemovedDayProgram;
        private ChannelDayProgram mAddedDayProgram;

        public TvDataTouchedThreadPoolMethod(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
            super("handleTvDataTouched" + (String)(removedDayProgram != null ? " for '" + removedDayProgram.getChannel() + "' on " + removedDayProgram.getDate() : ""));
            this.mRemovedDayProgram = removedDayProgram;
            this.mAddedDayProgram = addedDayProgram;
        }

        @Override
        public void run() {
            for (PluginListItem item : PluginProxyManager.this.getPluginListCopy()) {
                if (!item.getPlugin().isActivated()) continue;
                AbstractPluginProxy plugin = item.getPlugin();
                try {
                    plugin.handleTvDataTouched(this.mRemovedDayProgram, this.mAddedDayProgram);
                }
                catch (Throwable t) {
                    mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataTouched' of Plugin '" + plugin + "'.", t);
                }
            }
        }
    }

    private class TvDataUpdateFinishedThreadPoolMethod
    extends ThreadPoolMethod {
        public TvDataUpdateFinishedThreadPoolMethod() {
            super("handleTvDataUpdateFinished");
        }

        @Override
        public void run() {
            for (PluginListItem item : PluginProxyManager.this.getPluginListCopy()) {
                if (!item.getPlugin().isActivated()) continue;
                AbstractPluginProxy plugin = item.getPlugin();
                try {
                    plugin.handleTvDataUpdateFinished();
                }
                catch (Throwable t) {
                    mLog.log(Level.WARNING, "A not catched error occured in 'handleTvDataUpdateFinished' of Plugin '" + plugin + "'.", t);
                }
            }
        }
    }

    private class TvBrowserVersionUpdateThreadPoolMethod
    extends ThreadPoolMethod {
        private Version mPreviousVersion;

        public TvBrowserVersionUpdateThreadPoolMethod(Version previousVersion) {
            super("handleTvBrowserVersionUpdate");
            this.mPreviousVersion = previousVersion;
        }

        @Override
        public void run() {
            for (PluginListItem item : PluginProxyManager.this.getPluginListCopy()) {
                if (!item.getPlugin().isActivated()) continue;
                AbstractPluginProxy plugin = item.getPlugin();
                try {
                    plugin.doHandleTvBrowserVersionUpdate(this.mPreviousVersion);
                }
                catch (Throwable t) {
                    mLog.log(Level.WARNING, "A not catched error occured in 'handleTvBrowserVersionUpdate' of Plugin '" + plugin + "'.", t);
                }
            }
        }
    }

    private abstract class ThreadPoolMethod {
        public ThreadPoolMethod(String name) {
        }

        public abstract void run();
    }

    private class TvBrowserSettingsChangedThreadPoolMethod
    extends ThreadPoolMethod {
        private AbstractPluginProxy mPlugin;

        public TvBrowserSettingsChangedThreadPoolMethod(AbstractPluginProxy plugin) {
            super("HandleSettingsChanged");
            this.mPlugin = plugin;
        }

        @Override
        public void run() {
            try {
                this.mPlugin.handleTvBrowserSettingsChanged();
            }
            catch (Throwable t) {
                mLog.log(Level.WARNING, "A not catched error occured in 'fireTvBrowserSettingsChanged' of Plugin '" + this.mPlugin + "'.", t);
            }
        }
    }

    private class TvBrowserStartFinishedThreadPoolMethod
    extends ThreadPoolMethod {
        private AbstractPluginProxy mPlugin;

        public TvBrowserStartFinishedThreadPoolMethod(AbstractPluginProxy plugin) {
            super("HandleStartFinished");
            this.mPlugin = plugin;
        }

        @Override
        public void run() {
            try {
                PluginProxyManager.this.fireTvBrowserStartFinished(this.mPlugin);
            }
            catch (Throwable t) {
                mLog.log(Level.WARNING, "A not catched error occured in 'fireTvBrowserStartFinishedThread' of Plugin '" + this.mPlugin + "'.", t);
            }
            if (this.mPlugin.hasArtificialPluginTree()) {
                int childCount = this.mPlugin.getArtificialRootNode().size();
                if (childCount > 0 && childCount < 100) {
                    this.mPlugin.getArtificialRootNode().update();
                } else {
                    this.mPlugin.removeArtificialPluginTree();
                }
                SwingUtilities.invokeLater(() -> MainFrame.getInstance().updatePluginTree());
            }
        }
    }
}

