/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search.regexsearch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.search.AbstractSearcher;
import util.exc.TvBrowserException;

public class RegexSearcher
extends AbstractSearcher {
    public static final int TYPE_EXACT = 0;
    public static final int TYPE_KEYWORD = 1;
    public static final int TYPE_WHOLE_TERM = 2;
    private Pattern mPattern;
    private String preFilter;

    public RegexSearcher(Pattern pattern) {
        this.mPattern = pattern;
    }

    public RegexSearcher(String regex, boolean caseSensitive) throws TvBrowserException {
        this.mPattern = StringUtils.isBlank((CharSequence)regex) ? null : RegexSearcher.createSearchPattern(regex, caseSensitive);
    }

    public RegexSearcher(String regex, boolean caseSensitive, String searchTerm) throws TvBrowserException {
        this(regex, caseSensitive);
        String[] parts = searchTerm.split("\\s");
        this.preFilter = parts[0];
        for (String part : parts) {
            if (part.length() <= this.preFilter.length()) continue;
            this.preFilter = part;
        }
        this.preFilter = this.preFilter.toLowerCase();
    }

    public static Pattern createSearchPattern(String regex, boolean caseSensitive) throws TvBrowserException {
        Pattern pattern;
        int flags = 32;
        if (!caseSensitive) {
            flags |= 2;
            flags |= 0x40;
        }
        try {
            pattern = Pattern.compile(regex, flags);
        }
        catch (PatternSyntaxException exc) {
            throw new TvBrowserException(RegexSearcher.class, "error.1", "Syntax error in the regular expression of the search pattern!", exc);
        }
        return pattern;
    }

    public static String searchTextToRegex(String searchText, int type) {
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return "";
        }
        String regex = "\\Q" + searchText.replaceAll("\\s+", "\\\\E\\\\s+\\\\Q") + "\\E";
        switch (type) {
            case 1: {
                regex = ".*" + regex + ".*";
                break;
            }
            case 2: {
                regex = ".*(?!-|\\B|\\+)" + regex + "(?!-|\\B|\\+).*";
            }
        }
        return regex;
    }

    @Override
    protected boolean matches(String value) {
        if (this.mPattern == null) {
            return false;
        }
        if (this.preFilter != null && value.toLowerCase().indexOf(this.preFilter) < 0) {
            return false;
        }
        Matcher matcher = this.mPattern.matcher(value);
        return matcher.matches();
    }

    public Pattern getPattern() {
        return this.mPattern;
    }
}

