/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tvbrowser.core.filters.PluginFilter;
import tvbrowser.core.filters.SeparatorFilter;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.core.PendingFilterLoader;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.SearchFormSettings;
import util.ui.UiUtilities;

public class FilterFavorite
extends Favorite
implements PendingFilterLoader {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterFavorite.class);
    public static final String TYPE_ID = "filterFavorite";
    private String mFilterName;
    private ProgramFilter mFilterInstance;
    private boolean mFilterIsAcceptable;

    public FilterFavorite() {
        this.mFilterName = "";
        this.mFilterIsAcceptable = false;
        this.setName(this.mFilterName);
        this.mSearchFormSettings = this.createSearchFormSettings();
    }

    public FilterFavorite(ProgramFilter filter) {
        this.mFilterName = filter.getName();
        this.mFilterIsAcceptable = FilterFavorite.filterIsAcceptable(filter);
        this.setName(this.mFilterName);
        if (this.mFilterIsAcceptable) {
            this.mFilterInstance = filter;
        }
        this.mSearchFormSettings = this.createSearchFormSettings();
    }

    public FilterFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        in.readInt();
        this.mFilterName = in.readUTF();
        this.mFilterIsAcceptable = true;
        this.mSearchFormSettings = this.createSearchFormSettings();
        FavoritesPlugin.getInstance().addPendingFavorite(this);
    }

    private SearchFormSettings createSearchFormSettings() {
        SearchFormSettings formSettings = new SearchFormSettings(".*");
        formSettings.setSearchIn(1);
        formSettings.setSearcherType(3);
        return formSettings;
    }

    public String getFilterName() {
        return this.mFilterName;
    }

    public static boolean filterIsAcceptable(ProgramFilter filter) {
        return !(filter instanceof FavoriteFilter) && !(filter instanceof ShowAllFilter) && !(filter instanceof SeparatorFilter) && !(filter instanceof PluginFilter) && (!(filter instanceof UserFilter) || ((UserFilter)filter).acceptableForFilterFavorite());
    }

    public ProgramFilter getProgramFilter() {
        if (this.mFilterInstance == null) {
            ProgramFilter[] filters;
            for (ProgramFilter filter : filters = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                if (filter == null || !filter.getName().equals(this.mFilterName)) continue;
                if (FilterFavorite.filterIsAcceptable(filter)) {
                    this.mFilterInstance = filter;
                    break;
                }
                this.mFilterIsAcceptable = false;
                break;
            }
        }
        return this.mFilterInstance;
    }

    @Override
    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        ArrayList<Program> foundPrograms = new ArrayList<Program>();
        ProgramFilter test = this.getProgramFilter();
        if (this.mFilterIsAcceptable && test != null) {
            Program[] programs;
            for (Program prog : programs = super.internalSearchForPrograms()) {
                if (!test.accept(prog)) continue;
                foundPrograms.add(prog);
            }
        }
        return foundPrograms.toArray(new Program[foundPrograms.size()]);
    }

    @Override
    public boolean matches(Program p) {
        ProgramFilter test = this.getProgramFilter();
        if (this.mFilterIsAcceptable && test != null) {
            return test.accept(p);
        }
        return false;
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.mFilterName);
    }

    @Override
    public void loadPendingFilter() {
        this.getProgramFilter();
    }

    @Override
    public boolean isValidSearch() {
        return this.mFilterIsAcceptable;
    }

    public boolean updateFilter(ProgramFilter filter, boolean updatePrograms) {
        boolean result;
        boolean bl = result = this.mFilterInstance != null && this.mFilterInstance.equals(filter) || this.mFilterName.equals(filter.getName());
        if (result) {
            this.mFilterName = filter.getName();
            this.mFilterIsAcceptable = FilterFavorite.filterIsAcceptable(filter);
            this.mFilterInstance = this.mFilterIsAcceptable ? filter : null;
        }
        boolean bl2 = result = this.updateFilterExclusion(filter, false) || result;
        if (result && updatePrograms) {
            try {
                this.updatePrograms();
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean deleteFilter(ProgramFilter filter, boolean updatePrograms) {
        boolean result;
        boolean bl = result = this.mFilterInstance != null && this.mFilterInstance.equals(filter) || this.mFilterName.equals(filter.getName());
        if (result) {
            this.mFilterIsAcceptable = false;
            this.mFilterInstance = null;
        }
        boolean bl2 = result = this.deleteFilterExclusion(filter, false) || result;
        if (result && updatePrograms) {
            try {
                this.updatePrograms();
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String getTypeName() {
        return LOCALIZER.msg("typeName", "Filter Favorite");
    }

    class Configurator
    implements FavoriteConfigurator {
        private JComboBox<ProgramFilter> mFilterSelection;

        Configurator() {
        }

        @Override
        public JPanel createConfigurationPanel() {
            ProgramFilter[] availableFilters;
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default:grow,3dlu,default"), "3dlu");
            pb.border(Borders.createEmptyBorder((String)"2dlu,0dlu,2dlu,0dlu"));
            ArrayList<ProgramFilter> selectableFilter = new ArrayList<ProgramFilter>();
            for (ProgramFilter filter : availableFilters = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                if (!FilterFavorite.filterIsAcceptable(filter)) continue;
                selectableFilter.add(filter);
            }
            this.mFilterSelection = new JComboBox<ProgramFilter>(selectableFilter.toArray(new ProgramFilter[selectableFilter.size()]));
            if (FilterFavorite.this.mFilterInstance != null) {
                this.mFilterSelection.setSelectedItem(FilterFavorite.this.mFilterInstance);
            }
            JButton editFilter = new JButton(SelectFilterDlg.LOCALIZER.msg("title", "Edit Filters"));
            editFilter.addActionListener(e -> {
                ProgramFilter[] availableFilter;
                SelectFilterDlg filterDlg = SelectFilterDlg.create(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
                filterDlg.setVisible(true);
                Object selected = this.mFilterSelection.getSelectedItem();
                ((DefaultComboBoxModel)this.mFilterSelection.getModel()).removeAllElements();
                for (ProgramFilter filter : availableFilter = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                    if (filter instanceof FavoriteFilter) continue;
                    ((DefaultComboBoxModel)this.mFilterSelection.getModel()).addElement(filter);
                }
                this.mFilterSelection.setSelectedItem(selected);
            });
            pb.addLabelRowFull(false, LOCALIZER.msg("message", "Programs that are accepted by this filter will be marked as Favorite:"));
            pb.addRow(this.mFilterSelection, 1);
            pb.add(editFilter, 3);
            return pb.getPanel();
        }

        @Override
        public void save() {
            ProgramFilter filter = (ProgramFilter)this.mFilterSelection.getSelectedItem();
            if (filter != null) {
                FilterFavorite.this.mFilterName = filter.getName();
                FilterFavorite.this.setName(FilterFavorite.this.mFilterName);
                FilterFavorite.this.mFilterIsAcceptable = FilterFavorite.filterIsAcceptable(filter);
                FilterFavorite.this.mFilterInstance = FilterFavorite.this.mFilterIsAcceptable ? filter : null;
            }
        }

        @Override
        public boolean check() {
            if (this.mFilterSelection.getSelectedItem() == null || !FilterFavorite.filterIsAcceptable((ProgramFilter)this.mFilterSelection.getSelectedItem())) {
                JOptionPane.showMessageDialog(this.mFilterSelection, LOCALIZER.msg("notAcceptable.message", "The current filter cannot be accepted by this Favorite!"), LOCALIZER.msg("notAcceptable.title", "Invalid filter"), 2);
                return false;
            }
            return true;
        }
    }
}

