/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.searchfield;

import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramSearcher;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.SearchFormSettings;

public class SearchFilter
implements ProgramFilter {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchFilter.class);
    private static SearchFilter mInstance;
    private SearchFormSettings mSearcherForm;
    private ProgramSearcher mSearch;
    private ProgramFieldType[] mFieldTypes;

    private SearchFilter() {
    }

    public void setSearch(SearchFormSettings searchFormSettings) throws TvBrowserException {
        this.mSearcherForm = searchFormSettings;
        this.mSearch = this.mSearcherForm.createSearcher();
        this.mFieldTypes = this.mSearcherForm.getFieldTypes();
    }

    void deactivateSearch() {
        this.mSearcherForm = null;
    }

    public boolean isActive() {
        return this.mSearcherForm != null;
    }

    @Override
    public boolean accept(Program prog) {
        if (this.mSearch == null) {
            return true;
        }
        return this.mSearch.matches(prog, this.mFieldTypes);
    }

    @Override
    public String getName() {
        return mLocalizer.msg("searchFor", "Search for {0}", this.mSearcherForm.getSearchText());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static SearchFilter getInstance() {
        if (mInstance == null) {
            mInstance = new SearchFilter();
        }
        return mInstance;
    }
}

