/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview.contextmenu;

import devplugin.ActionMenu;
import devplugin.PluginInfo;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.contextmenu.AbstractContextMenu;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.menu.MenuUtil;

public abstract class PluginContextMenu
extends AbstractContextMenu {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginContextMenu.class);
    private ActionMenu[] mActionMenus;
    private Action mDefaultAction;
    private TreePath mPath;

    public PluginContextMenu(PluginTree tree, TreePath path, ActionMenu[] menus) {
        super(tree);
        this.initDefaultActions(path, menus);
    }

    private void initDefaultActions(TreePath path, ActionMenu[] menus) {
        this.mDefaultAction = this.getCollapseExpandAction(path);
        this.mPath = path;
        this.mActionMenus = menus;
        if (this.mActionMenus == null) {
            this.mActionMenus = new ActionMenu[0];
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JMenuItem menuItem;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem defaultMI = new JMenuItem(this.mDefaultAction);
        menu.add(defaultMI);
        defaultMI.setFont(MenuUtil.CONTEXT_MENU_BOLDFONT);
        menu.add(this.getExpandAllMenuItem(this.mPath));
        menu.add(this.getCollapseAllMenuItem(this.mPath));
        menu.add(this.getFilterMenuItem(this.mPath));
        menu.add(this.getExportMenu(this.mPath));
        ActionMenu pluginAction = this.getButtonAction();
        if (pluginAction != null) {
            menu.addSeparator();
            ActionMenu[] action = pluginAction.getAction();
            JMenuItem pluginMI = new JMenuItem((Action)action);
            pluginMI.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
            menu.add(pluginMI);
        }
        if (this.mActionMenus.length > 0) {
            for (ActionMenu actionMenu : this.mActionMenus) {
                JMenuItem menuItem2 = MenuUtil.createMenuItem(actionMenu);
                menu.add(menuItem2);
            }
        }
        menu.addSeparator();
        if (this.hasSettingsTab()) {
            menuItem = MenuUtil.createMenuItem(Localizer.getEllipsisLocalization("i18n_settings"));
            menuItem.setIcon(TVBrowserIcons.preferences(16));
            menuItem.addActionListener(e -> MainFrame.getInstance().showSettingsDialog(this.getPluginId()));
            menu.add(menuItem);
        }
        menuItem = MenuUtil.createMenuItem(mLocalizer.msg("disablePlugin", "Disable plugin"));
        menuItem.addActionListener(e -> {
            PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(this.getPluginId());
            if (plugin != null) {
                try {
                    PluginProxyManager.getInstance().deactivatePlugin(plugin);
                }
                catch (TvBrowserException e1) {
                    e1.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        ImageIcon icon = IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16);
        menuItem = MenuUtil.createMenuItem(Localizer.getLocalization("i18n_help"));
        menuItem.setIcon(icon);
        menuItem.addActionListener(e -> {
            PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(this.getPluginId());
            if (plugin != null) {
                String helpUrl = plugin.getInfo().getHelpUrl();
                if (helpUrl == null) {
                    helpUrl = PluginInfo.getHelpUrl(plugin.getId());
                }
                if (helpUrl != null) {
                    Launch.openURL(helpUrl);
                }
            }
        });
        menu.add(menuItem);
        return menu;
    }

    protected abstract String getPluginId();

    protected abstract boolean hasSettingsTab();

    protected abstract ActionMenu getButtonAction();

    @Override
    public Action getDefaultAction() {
        return null;
    }
}

