/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import devplugin.Program;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ChannelPanel;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTable;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableModelListener;
import tvbrowser.ui.programtable.background.BackgroundPainter;
import util.ui.persona.Persona;

public class ProgramTableScrollPane
extends JScrollPane
implements ProgramTableModelListener,
MouseWheelListener,
ChangeListener {
    private static final double SCROLL_OFFSET_FROM_TOP = 0.25;
    private ProgramTable mProgramTable;
    private ChannelPanel mChannelPanel;
    private boolean initialScrollingDone = false;
    private int mScrolledTime = -1;
    private KeyListener mKeyListener;
    private long mLastScrollTime;
    private Thread mCleanScrollBackground;
    private AtomicReference<Channel> mScrollChannel = new AtomicReference<Object>(null);

    public ProgramTableScrollPane(ProgramTableModel model, KeyListener keyListener) {
        this.setFocusable(true);
        this.mKeyListener = keyListener;
        this.mProgramTable = new ProgramTable(model, keyListener);
        this.setViewportView(this.mProgramTable);
        this.getViewport().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.setWheelScrollingEnabled(false);
        this.addMouseWheelListener(this);
        this.getHorizontalScrollBar().setUnitIncrement(Settings.ProgramTable.COLUMN_WIDTH.getInt());
        this.getVerticalScrollBar().setUnitIncrement(50);
        this.getHorizontalScrollBar().setFocusable(false);
        this.getVerticalScrollBar().setFocusable(false);
        this.mChannelPanel = new ChannelPanel(this.mProgramTable.getColumnWidth(), model.getShownChannels(), keyListener);
        JPanel dummy = new JPanel();
        dummy.setOpaque(false);
        this.setRowHeaderView(dummy);
        this.getRowHeader().setOpaque(false);
        this.setColumnHeaderView(this.mChannelPanel);
        this.getColumnHeader().setOpaque(false);
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
        JPanel leftUpper = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    ProgramTableScrollPane.this.paintComponentInternal(g);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        JPanel rightUpper = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    ProgramTableScrollPane.this.paintComponentInternal(g);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        this.setCorner("UPPER_LEFT_CORNER", leftUpper);
        this.setCorner("UPPER_RIGHT_CORNER", rightUpper);
        model.addProgramTableModelListener(this);
        this.mProgramTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("backgroundpainter")) {
                    BackgroundPainter painter = (BackgroundPainter)evt.getNewValue();
                    ProgramTableScrollPane.this.handleBackgroundPainterChanged(painter);
                }
            }
        });
        this.handleBackgroundPainterChanged(this.mProgramTable.getBackgroundPainter());
        this.getViewport().addChangeListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ProgramTableScrollPane.this.updateScrollBars();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ProgramTableScrollPane.this.resetScrolledTime();
            }
        });
        this.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramTableScrollPane.this.requestFocus();
            }
        });
        this.getHorizontalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramTableScrollPane.this.requestFocus();
            }
        });
    }

    private void paintComponentInternal(Graphics g) {
        Color c = Persona.getInstance().getAccentColor().darker().darker().darker();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 110));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        c = Persona.testPersonaForegroundAgainst(Persona.getInstance().getTextColor());
        g.setColor(c);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public ProgramTable getProgramTable() {
        return this.mProgramTable;
    }

    public void forceRepaintAll() {
        this.getProgramTable().forceRepaintAll();
        this.tableDataChanged(null);
        this.getProgramTable().tableDataChanged(null);
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.mProgramTable != null) {
            this.mProgramTable.repaint();
        }
        if (this.mChannelPanel != null) {
            this.mChannelPanel.repaint();
        }
    }

    public void updateChannelPanel() {
        this.mChannelPanel = new ChannelPanel(this.mProgramTable.getColumnWidth(), this.mProgramTable.getModel().getShownChannels(), this.mKeyListener);
        this.setColumnHeaderView(this.mChannelPanel);
        this.repaint();
    }

    public void updateChannelLabelForChannel(Channel ch) {
        this.mChannelPanel.updateChannelLabelForChannel(ch);
        ((DefaultProgramTableModel)this.mProgramTable.getModel()).setChannels(ChannelList.getSubscribedChannels());
    }

    public void setColumnWidth(int columnWidth) {
        this.mProgramTable.setColumnWidth(columnWidth);
        this.mChannelPanel.setColumnWidth(columnWidth);
        this.getHorizontalScrollBar().setUnitIncrement(columnWidth);
        this.updateScrollBars();
    }

    public synchronized void scrollToChannel(Channel channel) {
        final Channel wait = channel;
        this.mScrollChannel.set(wait);
        int column = -1;
        if (this.getHorizontalScrollBar().isVisible()) {
            channel = Channel.getChannelForChannel(channel);
            Channel[] shownChannelArr = this.mProgramTable.getModel().getShownChannels();
            for (int col = 0; col < shownChannelArr.length; ++col) {
                int max;
                if (!channel.equals(shownChannelArr[col])) continue;
                column = col;
                Point scrollPos = this.getViewport().getViewPosition();
                if (scrollPos == null) break;
                int visibleColumns = this.getViewport().getWidth() / this.mProgramTable.getColumnWidth();
                scrollPos.x = (col - visibleColumns / 2) * this.mProgramTable.getColumnWidth();
                if (scrollPos.x < 0) {
                    scrollPos.x = 0;
                }
                if (scrollPos.x > (max = this.mProgramTable.getWidth() - this.getViewport().getWidth())) {
                    scrollPos.x = max;
                }
                this.getViewport().setViewPosition(scrollPos);
                break;
            }
        } else if (Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING.getBoolean()) {
            Channel[] shownChannelArr = this.mProgramTable.getModel().getShownChannels();
            for (int col = 0; col < shownChannelArr.length; ++col) {
                if (!channel.equals(shownChannelArr[col])) continue;
                column = col;
            }
        }
        if (Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING.getBoolean()) {
            this.mProgramTable.getBackgroundPainter().setSelectedColumn(column);
            this.mProgramTable.repaint();
            this.mCleanScrollBackground = new Thread("CLEAN SCROLL BACKGROUND THREAD"){

                @Override
                public void run() {
                    int count = 0;
                    while (count++ < 50 && ProgramTableScrollPane.this.mScrollChannel.get() != null && wait.equals(ProgramTableScrollPane.this.mScrollChannel.get())) {
                        try {
                            8.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ProgramTableScrollPane.this.mScrollChannel.get() != null && wait.equals(ProgramTableScrollPane.this.mScrollChannel.get())) {
                        ProgramTableScrollPane.this.mProgramTable.getBackgroundPainter().setSelectedColumn(-1);
                        ProgramTableScrollPane.this.mProgramTable.repaint();
                    }
                }
            };
            this.mCleanScrollBackground.start();
        }
    }

    public void highlightChannel(Channel channel) {
        int column = -1;
        Channel[] shownChannelArr = this.mProgramTable.getModel().getShownChannels();
        for (int col = 0; col < shownChannelArr.length; ++col) {
            if (!channel.equals(shownChannelArr[col])) continue;
            column = col;
        }
        this.mProgramTable.getBackgroundPainter().setSelectedColumn(column);
        this.mProgramTable.repaint();
    }

    public void unHighlightChannel(Channel channel) {
        int column = -1;
        Channel[] shownChannelArr = this.mProgramTable.getModel().getShownChannels();
        for (int col = 0; col < shownChannelArr.length; ++col) {
            if (!channel.equals(shownChannelArr[col])) continue;
            column = col;
        }
        if (this.mProgramTable.getBackgroundPainter().getSelectedColumn() != -1 && this.mProgramTable.getBackgroundPainter().getSelectedColumn() == column) {
            this.mProgramTable.getBackgroundPainter().setSelectedColumn(-1);
            this.mProgramTable.repaint();
        }
    }

    public void scrollToTime(int minutesAfterMidnight) {
        int max;
        Point scrollPos = this.getViewport().getViewPosition();
        scrollPos.y = this.mProgramTable.getTimeY(minutesAfterMidnight) - (int)Math.round((double)this.getViewport().getHeight() * 0.25);
        if (scrollPos.y < 0) {
            scrollPos.y = 0;
        }
        if (scrollPos.y > (max = Math.max(0, this.mProgramTable.getHeight() - this.getViewport().getHeight()))) {
            scrollPos.y = max;
        }
        this.getViewport().setViewPosition(scrollPos);
        this.mScrolledTime = minutesAfterMidnight;
    }

    protected void handleBackgroundPainterChanged(BackgroundPainter painter) {
        this.setRowHeaderView(painter.getTableWest());
    }

    @Override
    public void tableDataChanged(Runnable callback) {
        this.mChannelPanel.setShownChannels(this.mProgramTable.getModel().getShownChannels(), this.mKeyListener);
        if (Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("timeBlock") && Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.getBoolean()) {
            this.getRowHeader().getView().repaint();
        }
        if (callback != null) {
            callback.run();
        }
    }

    @Override
    public void tableCellUpdated(int col, int row) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (Settings.ProgramTable.AUTO_CHANGE_DATE.getBoolean() && (this.getVerticalScrollBar().getValue() + this.getVerticalScrollBar().getVisibleAmount() >= this.getVerticalScrollBar().getMaximum() || this.getVerticalScrollBar().getValue() == this.getVerticalScrollBar().getMinimum())) {
            if (System.currentTimeMillis() - this.mLastScrollTime <= 500L && System.currentTimeMillis() - this.mLastScrollTime >= 200L) {
                if (e.getWheelRotation() < 0) {
                    MainFrame.getInstance().goToPreviousDay(() -> this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getMaximum()));
                } else {
                    MainFrame.getInstance().goToNextDay(() -> MainFrame.getInstance().scrollToTime(Settings.ProgramTable.END_OF_DAY.getInt(), false));
                }
                e.consume();
                return;
            }
            if (System.currentTimeMillis() - this.mLastScrollTime > 500L) {
                this.mLastScrollTime = System.currentTimeMillis();
            }
        }
        JScrollBar scrollBar = null;
        int amount = 0;
        scrollBar = (e.getModifiersEx() & 0x40) != 0 && !Settings.ProgramTable.SCROLL_HORIZONTAL.getBoolean() || this.getComponentAt(e.getPoint()).equals(this.getColumnHeader()) || this.getComponentAt(e.getPoint()).equals(this.getHorizontalScrollBar()) || Settings.ProgramTable.SCROLL_HORIZONTAL.getBoolean() && !this.getComponentAt(e.getPoint()).equals(this.getVerticalScrollBar()) && (e.getModifiersEx() & 0x40) == 0 ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (scrollBar != null) {
            if (e.getScrollType() == 0) {
                amount = e.getUnitsToScroll() * scrollBar.getUnitIncrement();
            } else if (e.getScrollType() == 1) {
                amount = e.getWheelRotation() * scrollBar.getBlockIncrement(1);
            }
            if (amount != 0) {
                scrollBar.setValue(scrollBar.getValue() + amount);
            }
        }
    }

    public void right() {
        this.mProgramTable.right();
    }

    public void up() {
        this.mProgramTable.up();
    }

    public void down() {
        this.mProgramTable.down();
    }

    public void left() {
        this.mProgramTable.left();
    }

    public void closePopupMenuIfVisible() {
        this.mProgramTable.closePopupMenuIfVisible();
    }

    public void togglePopupMenu() {
        this.mProgramTable.togglePopupFromKeyboard();
    }

    public void handleKeyboardAction(ContextMenuManager.ContextMenuAction action) {
        this.mProgramTable.handleKeyboardAction(action);
    }

    public Program deSelectItem(boolean getProgram) {
        return this.mProgramTable.deSelectItem(getProgram);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Point viewPos;
        if (e.getSource() == this.viewport && (viewPos = this.viewport.getViewPosition()) != null) {
            Channel[] shownChannels = MainFrame.getInstance().getProgramTableModel().getShownChannels();
            if (shownChannels.length == 0) {
                return;
            }
            int columnIndex = (viewPos.x + this.viewport.getWidth() / 2) / this.mProgramTable.getColumnWidth();
            if (columnIndex >= shownChannels.length) {
                columnIndex = shownChannels.length - 1;
            }
            MainFrame.getInstance().selectChannel(shownChannels[columnIndex]);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.initialScrollingDone) {
            this.initialScrollingDone = true;
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            this.scrollToTime(hour * 60);
            this.updateScrollBars();
        }
    }

    private void updateScrollBars() {
        int columnWidth = this.mProgramTable.getColumnWidth();
        this.getHorizontalScrollBar().setBlockIncrement(this.getFullColumns() * columnWidth);
    }

    private int getFullColumns() {
        int columnWidth = this.mProgramTable.getColumnWidth();
        int fullColumns = (this.getViewport().getWidth() + 8) / columnWidth;
        if (fullColumns < 1) {
            return 1;
        }
        return fullColumns;
    }

    public int getScrolledTime() {
        return this.mScrolledTime;
    }

    public void resetScrolledTime() {
        this.mScrolledTime = -1;
    }

    public void scrollPageRight() {
        this.scrollPageHorizontal(1);
    }

    public void scrollPageLeft() {
        this.scrollPageHorizontal(-1);
    }

    private void scrollPageHorizontal(int direction) {
        int max;
        JScrollBar scrollBar = this.getHorizontalScrollBar();
        int pos = scrollBar.getValue() + direction * this.getFullColumns() * this.mProgramTable.getColumnWidth();
        if (pos > (max = scrollBar.getMaximum() - scrollBar.getVisibleAmount())) {
            pos = max;
        }
        if (pos < 0) {
            pos = 0;
        }
        scrollBar.setValue(pos);
    }

    public void updatePersona() {
        this.mChannelPanel.updatePersona();
    }
}

