/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TimeBlockBackgroundStyle;
import util.i18n.Localizer;

public class UiTimeBlockBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(UiTimeBlockBackgroundStyle.class);
    private JSpinner mTimeBlockSizeSp;
    private JCheckBox mTimeBlockShowWestChB;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mTimeBlockSizeSp = new JSpinner(new SpinnerNumberModel(Settings.ProgramTable.TIME_BLOCK_SIZE.getInt(), 1, 23, 1));
        this.mTimeBlockShowWestChB = new JCheckBox(TimeBlockBackgroundStyle.LOCALIZER.msg("timeBlock.showWest", "Show left border"), Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.getBoolean());
        this.mContent = new JPanel((LayoutManager)new FormLayout("default,5dlu,default:grow", "default,2dlu,default"));
        this.mContent.add((Component)new JLabel(TimeBlockBackgroundStyle.LOCALIZER.msg("timeBlock.blockSize", "Block size")), CC.xy((int)1, (int)1));
        this.mContent.add((Component)this.mTimeBlockSizeSp, CC.xy((int)3, (int)1));
        this.mContent.add((Component)this.mTimeBlockShowWestChB, CC.xyw((int)1, (int)3, (int)3));
        return this.mContent;
    }

    @Override
    public void storeSettings() {
        if (this.mContent == null) {
            return;
        }
        Integer blockSize = (Integer)this.mTimeBlockSizeSp.getValue();
        Settings.ProgramTable.TIME_BLOCK_SIZE.setInt(blockSize);
        Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.setBoolean(this.mTimeBlockShowWestChB.isSelected());
    }

    @Override
    public String getName() {
        return LOCALIZER.msg("style", "Theme color time block");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "uiTimeBlock";
    }
}

