/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import devplugin.ProgramFieldType;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import util.settings.Property;
import util.settings.PropertyManager;

public class ProgramFieldTypeArrayProperty
extends Property {
    private static final Logger mLog = Logger.getLogger(ProgramFieldTypeArrayProperty.class.getName());
    private ProgramFieldType[] mDefaultValue;
    private ProgramFieldType[] mCachedValue;

    public ProgramFieldTypeArrayProperty(PropertyManager manager, String key, ProgramFieldType[] defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public ProgramFieldType[] getDefault() {
        return this.mDefaultValue;
    }

    public ProgramFieldType[] getProgramFieldTypeArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString != null) {
                if (StringUtils.isBlank((CharSequence)asString)) {
                    this.mCachedValue = new ProgramFieldType[0];
                } else {
                    String[] splits = asString.split(",");
                    try {
                        ProgramFieldType[] arr = new ProgramFieldType[splits.length];
                        for (int i = 0; i < splits.length; ++i) {
                            int id = Integer.parseInt(splits[i]);
                            arr[i] = ProgramFieldType.getTypeForId(id);
                        }
                        this.mCachedValue = arr;
                    }
                    catch (NumberFormatException exc) {
                        mLog.warning("Property " + this.getKey() + " has an illegal value: '" + asString + "'. Using the default.");
                    }
                }
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setProgramFieldTypeArray(ProgramFieldType[] value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        boolean equalsDefault = false;
        if (this.mDefaultValue != null && value.length == this.mDefaultValue.length) {
            equalsDefault = true;
            for (int i = 0; i < value.length; ++i) {
                if (value[i].equals(this.mDefaultValue[i])) continue;
                equalsDefault = false;
                break;
            }
        }
        if (equalsDefault) {
            this.setProperty(null);
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < value.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(value[i].getTypeId());
            }
            this.setProperty(buffer.toString());
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

